/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.sourcemanip;

import argo.jdom.JdomParser;
import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import argo.saj.InvalidSyntaxException;
import com.google.common.base.Joiner;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.gradle.common.Constants;

public class GLConstantFixer {
    private static final String[] PACKAGES = new String[]{"GL11", "GL12", "GL13", "GL14", "GL15", "GL20", "GL21", "ARBMultitexture", "ARBOcclusionQuery", "ARBVertexBufferObject", "ARBShaderObjects"};
    private static final JdomParser JDOM_PARSER = new JdomParser();
    private final JsonRootNode json;
    public static final Pattern CALL_REGEX = Pattern.compile("(" + Joiner.on((String)"|").join((Object[])PACKAGES) + ")\\.([\\w]+)\\(.+\\)");
    public static final Pattern CONSTANT_REGEX = Pattern.compile("(?<![-.\\w])\\d+(?![.\\w])");
    private static final String ADD_AFTER = "org.lwjgl.opengl.GL11";
    private static final String CHECK = "org.lwjgl.opengl.";
    private static final String IMPORT_CHECK = "import org.lwjgl.opengl.";
    private static final String IMPORT_REPLACE = "import org.lwjgl.opengl.GL11;";

    public GLConstantFixer() throws IOException, InvalidSyntaxException {
        String text = Resources.toString((URL)Resources.getResource((String)"gl.json"), (Charset)Charset.defaultCharset());
        this.json = JDOM_PARSER.parse(text);
    }

    public String fixOGL(String text) {
        if (!text.contains(IMPORT_CHECK)) {
            return text;
        }
        text = this.annotateConstants(text);
        for (String pack : PACKAGES) {
            if (!text.contains(pack + ".")) continue;
            text = this.updateImports(text, CHECK + pack);
        }
        return text;
    }

    private String annotateConstants(String text) {
        Matcher rootMatch = CALL_REGEX.matcher(text);
        StringBuffer out = new StringBuffer(text.length());
        while (rootMatch.find()) {
            String fullCall = rootMatch.group();
            String pack = rootMatch.group(1);
            String method = rootMatch.group(2);
            Matcher constantMatcher = CONSTANT_REGEX.matcher(fullCall);
            StringBuffer innerOut = new StringBuffer(fullCall.length());
            while (constantMatcher.find()) {
                String constant = constantMatcher.group();
                String answer = null;
                for (JsonNode group : this.json.getElements()) {
                    JsonNode listNode = group.getElements().get(0);
                    if (!listNode.isNode(pack) || !this.jsonArrayContains(listNode.getArrayNode(pack), method)) continue;
                    listNode = group.getElements().get(1);
                    for (Map.Entry<JsonStringNode, JsonNode> entry : listNode.getFields().entrySet()) {
                        if (!entry.getValue().isNode(constant)) continue;
                        answer = entry.getKey().getText() + "." + entry.getValue().getStringValue(constant);
                    }
                }
                if (answer == null) continue;
                constantMatcher.appendReplacement(innerOut, Matcher.quoteReplacement(answer));
            }
            constantMatcher.appendTail(innerOut);
            if (fullCall == null) continue;
            rootMatch.appendReplacement(out, Matcher.quoteReplacement(innerOut.toString()));
        }
        rootMatch.appendTail(out);
        return out.toString();
    }

    private boolean jsonArrayContains(List<JsonNode> nodes, String str) {
        boolean hasMethod = false;
        for (JsonNode testMethod : nodes) {
            hasMethod = testMethod.getText().equals(str);
            if (!hasMethod) continue;
            return hasMethod;
        }
        return false;
    }

    private String updateImports(String text, String imp) {
        if (!text.contains("import " + imp + ";")) {
            text = text.replace(IMPORT_REPLACE, IMPORT_REPLACE + Constants.NEWLINE + "import " + imp + ";");
        }
        return text;
    }
}

