/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.sourcemanip;

import com.google.code.regexp.Matcher;
import com.google.code.regexp.Pattern;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.gradle.common.Constants;

public class FFPatcher {
    static final String MODIFIERS = "public|protected|private|static|abstract|final|native|synchronized|transient|volatile|strictfp";
    public static final Pattern SYNTHETICS = Pattern.compile((String)"(?m)(\\s*// \\$FF: (synthetic|bridge) method(\\r\\n|\\n|\\r)){1,2}\\s*(?<modifiers>(?:(?:public|protected|private|static|abstract|final|native|synchronized|transient|volatile|strictfp) )*)(?<return>.+?) (?<method>.+?)\\((?<arguments>.*)\\)\\s*\\{(\\r\\n|\\n|\\r)\\s*return this\\.(?<method2>.+?)\\((?<arguments2>.*)\\);(\\r\\n|\\n|\\r)\\s*\\}");
    public static final Pattern TYPECAST = Pattern.compile((String)"\\([\\w\\.]+\\)");
    public static final String TRAILING = "(?m)[ \\t]+$";
    public static final String NEWLINES = "(?m)^(\\r\\n|\\r|\\n){2,}";
    public static final Pattern MODIFIERS_REG = Pattern.compile((String)"(public|protected|private|static|abstract|final|native|synchronized|transient|volatile|strictfp)");
    public static final String LIST = ", ";
    public static final Pattern ENUM_CLASS = Pattern.compile((String)"(?m)^(?<modifiers>(?:(?:public|protected|private|static|abstract|final|native|synchronized|transient|volatile|strictfp) )*)(?<type>enum) (?<name>[\\w$]+)(?: implements (?<implements>[\\w$.]+(?:, [\\w$.]+)*))? \\{(?:\\r\\n|\\r|\\n)(?<body>(?:.*(?:\\r\\n|\\n|\\r))*?)(?<end>\\})");
    public static final Pattern ENUM_ENTRIES = Pattern.compile((String)"(?m)^ +(?<name>[\\w$]+)\\(\"(?:[\\w$]+)\", [0-9]+(?:, (?<body>.*?))?\\)(?<end>(?:;|,)(?:\\r\\n|\\n|\\r)+)");
    public static final String EMPTY_SUPER = "(?m)^ +super\\(\\);(\\r\\n|\\n|\\r)";
    public static final String TRAILINGZERO = "([0-9]+\\.[0-9]*[1-9])0+([DdFfEe])";
    public static final String CONSTRUCTOR = "(?m)^ +(?<modifiers>(?:(?:public|protected|private|static|abstract|final|native|synchronized|transient|volatile|strictfp) )*)%s\\((?<parameters>.*?)\\)(?: throws (?<throws>[\\w$.]+(?:, [\\w$.]+)*))? \\{(?:(?<empty>\\}(?:\\r\\n|\\r|\\n)+)|(?:(?<body>(?:\\r\\n|\\r|\\n)(?:.*?(?:\\r\\n|\\r|\\n))*?)(?<end> {3}\\}(?:\\r\\n|\\r|\\n)+)))";
    public static final String ENUM_VALS = "(?m)^ +// \\$FF: synthetic field(\\r\\n|\\n|\\r) +private static final %s\\[\\] [$\\w]+ = new %s\\[\\]\\{.*?\\};(\\r\\n|\\n|\\r)";

    public static String processFile(String fileName, String text) throws IOException {
        String classname = fileName.split("\\.")[0];
        StringBuffer out = new StringBuffer();
        Matcher m = SYNTHETICS.matcher((CharSequence)text);
        while (m.find()) {
            m.appendReplacement(out, FFPatcher.synthetic_replacement(m).replace("$", "\\$"));
        }
        m.appendTail(out);
        text = out.toString();
        text = text.replaceAll(TRAILING, "");
        Matcher match = ENUM_CLASS.matcher((CharSequence)text);
        while (match.find()) {
            if (!classname.equals(match.group("name"))) {
                throw new RuntimeException("ERROR PARSING ENUM !!!!! Class Name != File Name");
            }
            ArrayList<String> mods = new ArrayList<String>();
            Matcher modMatch = MODIFIERS_REG.matcher((CharSequence)match.group("modifiers"));
            while (modMatch.find()) {
                mods.add(modMatch.group());
            }
            if (!Strings.isNullOrEmpty((String)match.group("modifiers")) && mods.isEmpty()) {
                throw new RuntimeException("ERROR PARSING ENUM !!!!! no modifiers!");
            }
            ArrayList<String> interfaces = new ArrayList();
            if (!Strings.isNullOrEmpty((String)match.group("implements"))) {
                interfaces = Arrays.asList(match.group("implements").split(LIST));
            }
            text = text.replace(match.group(), FFPatcher.processEnum(classname, match.group("type"), mods, interfaces, match.group("body"), match.group("end")));
        }
        text = text.replaceAll(EMPTY_SUPER, "");
        text = text.replaceAll(TRAILINGZERO, "");
        text = text.replaceAll(NEWLINES, Constants.NEWLINE);
        text = text.replaceAll("(\\r\\n|\\r|\\n)", Constants.NEWLINE);
        text = text.replaceAll("(\r\n|\r|\n)", Constants.NEWLINE);
        return text;
    }

    private static String synthetic_replacement(Matcher match) {
        String arg2;
        if (!match.group("method").equals(match.group("method2"))) {
            return match.group();
        }
        String arg1 = match.group("arguments");
        if (arg1.equals(arg2 = match.group("arguments2")) && arg1.equals("")) {
            return "";
        }
        String[] args = match.group("arguments").split(LIST);
        for (int x = 0; x < args.length; ++x) {
            args[x] = args[x].split(" ")[1];
        }
        StringBuilder b = new StringBuilder();
        b.append(args[0]);
        for (int x = 1; x < args.length; ++x) {
            b.append(LIST).append(args[x]);
        }
        arg1 = b.toString();
        if (arg1.equals(arg2)) {
            return "";
        }
        return match.group();
    }

    private static String processEnum(String classname, String classtype, List<String> modifiers, List<String> interfaces, String body, String end) {
        Matcher match = ENUM_ENTRIES.matcher((CharSequence)body);
        while (match.find()) {
            String entryBody = "";
            if (!Strings.isNullOrEmpty((String)match.group("body"))) {
                entryBody = "(" + match.group("body") + ")";
            }
            body = body.replace(match.group(), "   " + match.group("name") + entryBody + match.group("end"));
        }
        String valuesRegex = String.format(ENUM_VALS, classname, classname);
        body = body.replaceAll(valuesRegex, "");
        String conRegex = String.format(CONSTRUCTOR, classname);
        match = Pattern.compile((String)conRegex).matcher((CharSequence)body);
        while (match.find()) {
            String methodEnd;
            String methodBody;
            ArrayList<String> mods = new ArrayList<String>();
            Matcher modMatch = MODIFIERS_REG.matcher((CharSequence)match.group("modifiers"));
            while (modMatch.find()) {
                mods.add(modMatch.group());
            }
            if (!Strings.isNullOrEmpty((String)match.group("modifiers")) && mods.isEmpty()) {
                throw new RuntimeException("ERROR PARSING ENUM CONSTRUCTOR! !!!!! no modifiers!");
            }
            ArrayList<String> params = new ArrayList();
            if (!Strings.isNullOrEmpty((String)match.group("parameters"))) {
                params = Arrays.asList(match.group("parameters").split(LIST));
            }
            ArrayList<String> exc = new ArrayList();
            if (!Strings.isNullOrEmpty((String)match.group("throws"))) {
                exc = Arrays.asList(match.group("throws").split(LIST));
            }
            if (!Strings.isNullOrEmpty((String)match.group("empty"))) {
                methodBody = "";
                methodEnd = match.group("empty");
            } else {
                methodBody = match.group("body");
                methodEnd = match.group("end");
            }
            body = body.replace(match.group(), FFPatcher.processConstructor(classname, mods, params, exc, methodBody, methodEnd));
        }
        StringBuilder out = new StringBuilder("");
        if (!modifiers.isEmpty()) {
            out.append(Joiner.on((String)" ").join(modifiers)).append(" ");
        }
        out.append(classtype).append(' ').append(classname);
        if (!interfaces.isEmpty()) {
            out.append(" implements ").append(Joiner.on((String)LIST).join(interfaces));
        }
        out.append(" {").append(Constants.NEWLINE).append(body).append(end);
        return out.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String processConstructor(String classname, List<String> mods, List<String> params, List<String> exc, String methodBody, String methodEnd) {
        if (params.size() < 2) throw new RuntimeException("not enough parameters in enum");
        if (!params.get(0).startsWith("String ") || !params.get(1).startsWith("int ")) throw new RuntimeException("invalid initial parameters in enum");
        params = params.subList(2, params.size());
        if (Strings.isNullOrEmpty((String)methodBody) && params.isEmpty()) {
            return "";
        }
        StringBuilder out = new StringBuilder("   ");
        if (mods != null && !mods.isEmpty()) {
            out.append(Joiner.on((String)" ").join(mods)).append(" ");
        }
        out.append(classname).append("(").append(Joiner.on((String)LIST).join(params)).append(")");
        if (exc != null && !exc.isEmpty()) {
            out.append(" throws ").append(Joiner.on((String)LIST).join(exc));
        }
        out.append(" {").append(methodBody).append(methodEnd);
        return out.toString();
    }
}

