/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import argo.saj.InvalidSyntaxException;
import com.github.abrarsyed.jastyle.ASFormatter;
import com.github.abrarsyed.jastyle.OptParser;
import com.google.common.base.Joiner;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.patching.ContextualPatch;
import net.minecraftforge.gradle.sourcemanip.FFPatcher;
import net.minecraftforge.gradle.sourcemanip.FmlCleanup;
import net.minecraftforge.gradle.sourcemanip.GLConstantFixer;
import net.minecraftforge.gradle.sourcemanip.McpCleanup;
import net.minecraftforge.gradle.tasks.abstractutil.CachedTask;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaExecSpec;

public class DecompileTask
extends CachedTask {
    @InputFile
    private DelayedFile inJar;
    @InputFile
    private DelayedFile fernFlower;
    @InputFile
    private DelayedFile patch;
    @InputFile
    private DelayedFile astyleConfig;
    @OutputFile
    @CachedTask.Cached
    private DelayedFile outJar;
    private HashMap<String, String> sourceMap = new HashMap();
    private HashMap<String, byte[]> resourceMap = new HashMap();
    private static final Pattern BEFORE = Pattern.compile("(?m)((case|default).+(?:\\r\\n|\\r|\\n))(?:\\r\\n|\\r|\\n)");
    private static final Pattern AFTER = Pattern.compile("(?m)(?:\\r\\n|\\r|\\n)((?:\\r\\n|\\r|\\n)[ \\t]+(case|default))");

    @TaskAction
    protected void doMCPStuff() throws Throwable {
        File temp = new File(this.getTemporaryDir(), this.getInJar().getName());
        this.getLogger().info("Decompiling Jar");
        this.decompile(this.getInJar(), this.getTemporaryDir(), this.getFernFlower());
        this.getLogger().info("Loading decompiled jar");
        this.readJarAndFix(temp);
        this.getLogger().info("Applying MCP patches");
        this.applyMcpPatches(this.getPatch());
        this.getLogger().info("Cleaning source");
        this.applyMcpCleanup(this.getAstyleConfig());
        this.getLogger().info("Saving Jar");
        this.saveJar(this.getOutJar());
    }

    private void decompile(final File inJar, final File outJar, final File fernFlower) {
        this.getProject().javaexec((Closure)new Closure<JavaExecSpec>((Object)this){
            private static final long serialVersionUID = 4608694547855396167L;

            public JavaExecSpec call() {
                JavaExecSpec exec = (JavaExecSpec)this.getDelegate();
                exec.args(new Object[]{fernFlower.getAbsolutePath(), "-din=0", "-rbr=0", "-dgs=1", "-asc=1", "-log=ERROR", inJar.getAbsolutePath(), outJar.getAbsolutePath()});
                exec.setMain("-jar");
                exec.setWorkingDir((Object)fernFlower.getParentFile());
                exec.classpath(new Object[]{Constants.getClassPath()});
                exec.setStandardOutput(Constants.getNullStream());
                return exec;
            }

            public JavaExecSpec call(Object obj) {
                return this.call();
            }
        });
    }

    private void readJarAndFix(File jar) throws IOException {
        ZipInputStream zin = new ZipInputStream(new FileInputStream(jar));
        ZipEntry entry = null;
        while ((entry = zin.getNextEntry()) != null) {
            if (entry.getName().contains("META-INF")) continue;
            if (entry.isDirectory() || !entry.getName().endsWith(".java")) {
                this.resourceMap.put(entry.getName(), ByteStreams.toByteArray((InputStream)zin));
                continue;
            }
            String fileStr = new String(ByteStreams.toByteArray((InputStream)zin), Charset.defaultCharset());
            fileStr = FFPatcher.processFile(new File(entry.getName()).getName(), fileStr);
            this.sourceMap.put(entry.getName(), fileStr);
        }
        zin.close();
    }

    private void applyMcpPatches(File patchFile) throws Throwable {
        ContextualPatch patch = ContextualPatch.create(Files.toString((File)patchFile, (Charset)Charset.defaultCharset()), new ContextProvider(this.sourceMap));
        boolean fuzzed = false;
        List<ContextualPatch.PatchReport> errors = patch.patch(false);
        for (ContextualPatch.PatchReport report : errors) {
            if (!report.getStatus().isSuccess()) {
                this.getLogger().log(LogLevel.ERROR, "Patching failed: " + report.getTarget(), report.getFailure());
                for (ContextualPatch.HunkReport hunk : report.getHunks()) {
                    if (hunk.getStatus().isSuccess()) continue;
                    this.getLogger().error("Hunk " + hunk.getHunkID() + " failed!");
                }
                throw report.getFailure();
            }
            if (report.getStatus() == ContextualPatch.PatchStatus.Fuzzed) {
                this.getLogger().log(LogLevel.INFO, "Patching fuzzed: " + report.getTarget(), report.getFailure());
                fuzzed = true;
                for (ContextualPatch.HunkReport hunk : report.getHunks()) {
                    if (hunk.getStatus().isSuccess()) continue;
                    this.getLogger().info("Hunk " + hunk.getHunkID() + " fuzzed " + hunk.getFuzz() + "!");
                }
                continue;
            }
            this.getLogger().info("Patch succeeded: " + report.getTarget());
        }
        if (fuzzed) {
            this.getLogger().lifecycle("Patches Fuzzed!");
        }
    }

    private void applyMcpCleanup(File conf) throws IOException, InvalidSyntaxException {
        ASFormatter formatter = new ASFormatter();
        OptParser parser = new OptParser(formatter);
        parser.parseOptionFile(conf);
        GLConstantFixer fixer = new GLConstantFixer();
        for (String file : this.sourceMap.keySet()) {
            String text = this.sourceMap.get(file);
            this.getLogger().debug("Processing file: " + file);
            this.getLogger().debug("processing comments");
            text = McpCleanup.stripComments(text);
            this.getLogger().debug("fixing imports comments");
            text = McpCleanup.fixImports(text);
            this.getLogger().debug("various other cleanup");
            text = McpCleanup.cleanup(text);
            this.getLogger().debug("fixing OGL constants");
            text = fixer.fixOGL(text);
            this.getLogger().debug("formatting source");
            StringReader reader = new StringReader(text);
            StringWriter writer = new StringWriter();
            formatter.format((Reader)reader, (Writer)writer);
            ((Reader)reader).close();
            ((Writer)writer).flush();
            ((Writer)writer).close();
            text = ((Object)writer).toString();
            this.getLogger().debug("applying FML transformations");
            text = BEFORE.matcher(text).replaceAll("$1");
            text = AFTER.matcher(text).replaceAll("$1");
            text = FmlCleanup.renameClass(text);
            this.sourceMap.put(file, text);
        }
    }

    private void saveJar(File output) throws IOException {
        ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(output));
        for (Map.Entry<String, byte[]> entry : this.resourceMap.entrySet()) {
            zout.putNextEntry(new ZipEntry(entry.getKey()));
            zout.write(entry.getValue());
            zout.closeEntry();
        }
        for (Map.Entry<String, Object> entry : this.sourceMap.entrySet()) {
            zout.putNextEntry(new ZipEntry(entry.getKey()));
            zout.write(((String)entry.getValue()).getBytes());
            zout.closeEntry();
        }
        zout.close();
    }

    public HashMap<String, String> getSourceMap() {
        return this.sourceMap;
    }

    public void setSourceMap(HashMap<String, String> sourceMap) {
        this.sourceMap = sourceMap;
    }

    public File getAstyleConfig() {
        return this.astyleConfig.call();
    }

    public void setAstyleConfig(DelayedFile astyleConfig) {
        this.astyleConfig = astyleConfig;
    }

    public File getFernFlower() {
        return this.fernFlower.call();
    }

    public void setFernFlower(DelayedFile fernFlower) {
        this.fernFlower = fernFlower;
    }

    public File getInJar() {
        return this.inJar.call();
    }

    public void setInJar(DelayedFile inJar) {
        this.inJar = inJar;
    }

    public File getOutJar() {
        return this.outJar.call();
    }

    public void setOutJar(DelayedFile outJar) {
        this.outJar = outJar;
    }

    public File getPatch() {
        return this.patch.call();
    }

    public void setPatch(DelayedFile patch) {
        this.patch = patch;
    }

    public HashMap<String, byte[]> getResourceMap() {
        return this.resourceMap;
    }

    public void setResourceMap(HashMap<String, byte[]> resourceMap) {
        this.resourceMap = resourceMap;
    }

    private class ContextProvider
    implements ContextualPatch.IContextProvider {
        private Map<String, String> fileMap;
        private final int STRIP = 1;

        public ContextProvider(Map<String, String> fileMap) {
            this.fileMap = fileMap;
        }

        private String strip(String target) {
            target = target.replace('\\', '/');
            int index = 0;
            for (int x = 0; x < 1; ++x) {
                index = target.indexOf(47, index) + 1;
            }
            return target.substring(index);
        }

        @Override
        public List<String> getData(String target) {
            if (this.fileMap.containsKey(target = this.strip(target))) {
                String[] lines = this.fileMap.get(target).split("\r\n|\r|\n");
                ArrayList<String> ret = new ArrayList<String>();
                for (String line : lines) {
                    ret.add(line);
                }
                return ret;
            }
            return null;
        }

        @Override
        public void setData(String target, List<String> data) {
            this.fileMap.put(this.strip(target), Joiner.on((String)Constants.NEWLINE).join(data));
        }
    }
}

