/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user;

import com.google.common.base.Throwables;
import com.google.common.io.Files;
import groovy.lang.Closure;
import groovy.util.Node;
import groovy.util.XmlParser;
import groovy.xml.XmlUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.minecraftforge.gradle.common.BasePlugin;
import net.minecraftforge.gradle.common.version.Library;
import net.minecraftforge.gradle.common.version.json.JsonFactory;
import net.minecraftforge.gradle.delayed.DelayedBase;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.CopyAssetsTask;
import net.minecraftforge.gradle.tasks.DecompileTask;
import net.minecraftforge.gradle.tasks.GenSrgTask;
import net.minecraftforge.gradle.tasks.MergeJarsTask;
import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.abstractutil.ExtractTask;
import net.minecraftforge.gradle.tasks.user.ApplyBinPatchesTask;
import net.minecraftforge.gradle.tasks.user.SourceCopyTask;
import net.minecraftforge.gradle.tasks.user.reobf.ArtifactSpec;
import net.minecraftforge.gradle.tasks.user.reobf.ReobfTask;
import net.minecraftforge.gradle.user.UserExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.GroovySourceSet;
import org.gradle.api.tasks.ScalaSourceSet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.internal.FileReferenceFactory;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.Module;
import org.gradle.plugins.ide.idea.model.PathFactory;
import org.gradle.plugins.ide.idea.model.SingleEntryModuleLibrary;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class UserBasePlugin
extends BasePlugin<UserExtension> {
    private boolean hasApplied = false;
    private static final byte[] LOCATION_BEFORE = new byte[]{64, -79, -117, -127, 35, -68, 0, 20, 26, 37, -106, -25, -93, -109, -66, 30};
    private static final byte[] LOCATION_AFTER = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -64, 88, -5, -13, 35, -68, 0, 20, 26, 81, -13, -116, 123, -69, 119, -58};

    @Override
    public void applyPlugin() {
        this.applyExternalPlugin("java");
        this.applyExternalPlugin("maven");
        this.applyExternalPlugin("eclipse");
        this.applyExternalPlugin("idea");
        this.configureDeps();
        this.configureCompilation();
        this.configureEclipse();
        this.configureIntellij();
        this.tasks();
        DefaultTask task = this.makeTask("setupCIWorkspace", DefaultTask.class);
        task.dependsOn(new Object[]{"genSrgs", "deobfBinJar"});
        task.setGroup("ForgeGradle");
        task = this.makeTask("setupDevWorkspace", DefaultTask.class);
        task.dependsOn(new Object[]{"genSrgs", "deobfBinJar", "copyAssets", "extractNatives"});
        task.setGroup("ForgeGradle");
        task = this.makeTask("setupDecompWorkspace", DefaultTask.class);
        task.dependsOn(new Object[]{"setupDevWorkspace"});
        task.setGroup("ForgeGradle");
        this.project.getTasks().getByName("eclipseClasspath").dependsOn(new Object[]{"setupDevWorkspace"});
        this.project.getTasks().getByName("reobf").dependsOn(new Object[]{"genSrgs"});
        this.project.getTasks().getByName("compileJava").dependsOn(new Object[]{"deobfBinJar"});
        this.project.getTasks().getByName("compileApiJava").dependsOn(new Object[]{"deobfBinJar"});
    }

    @Override
    protected Class<UserExtension> getExtensionClass() {
        return UserExtension.class;
    }

    @Override
    protected String getDevJson() {
        return DelayedBase.resolve("{BUILD_DIR}/unpacked/dev.json", this.project, new DelayedBase.IDelayedResolver[0]);
    }

    private void tasks() {
        MergeJarsTask task = this.makeTask("mergeJars", MergeJarsTask.class);
        task.setClient(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft/{MC_VERSION}/minecraft-{MC_VERSION}.jar"));
        task.setServer(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_server/{MC_VERSION}/minecraft_server-{MC_VERSION}.jar"));
        task.setOutJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        task.setMergeCfg(this.delayedFile("{BUILD_DIR}/unpacked/conf/mcp_merge.cfg"));
        task.dependsOn(new Object[]{"extractUserDev", "downloadClient", "downloadServer"});
        GenSrgTask task2 = this.makeTask("genSrgs", GenSrgTask.class);
        task2.setInSrg(this.delayedFile("{BUILD_DIR}/unpacked/conf/packaged.srg"));
        task2.setNotchToMcpSrg(this.delayedFile("{BUILD_DIR}/unpacked/conf/notch-mcp.srg"));
        task2.setMcpToSrgSrg(this.delayedFile("{BUILD_DIR}/unpacked/conf/mcp-srg.srg"));
        task2.setMcpToNotchSrg(this.delayedFile("{BUILD_DIR}/unpacked/conf/mcp-notch.srg"));
        task2.setMethodsCsv(this.delayedFile("{BUILD_DIR}/unpacked/mappings/methods.csv"));
        task2.setFieldsCsv(this.delayedFile("{BUILD_DIR}/unpacked/mappings/fields.csv"));
        task2.dependsOn(new Object[]{"extractUserDev"});
        ApplyBinPatchesTask binTask = this.makeTask("applyBinPatches", ApplyBinPatchesTask.class);
        binTask.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        binTask.setOutJar(this.getBinPatchOut());
        binTask.setPatches(this.delayedFile("{BUILD_DIR}/unpacked/devbinpatches.pack.lzma"));
        binTask.setClassesJar(this.delayedFile("{BUILD_DIR}/unpacked/binaries.jar"));
        binTask.setResources(this.delayedFileTree("{BUILD_DIR}/unpacked/src/main/resources"));
        binTask.dependsOn(new Object[]{"mergeJars"});
        ProcessJarTask deobfBinTask = this.makeTask("deobfBinJar", ProcessJarTask.class);
        deobfBinTask.setSrg(this.delayedFile("{BUILD_DIR}/unpacked/conf/notch-mcp.srg"));
        deobfBinTask.setOutDirtyJar(this.delayedFile("{BUILD_DIR}/deobfuscated-bin.jar"));
        this.addATs(deobfBinTask);
        deobfBinTask.setExceptorCfg(this.delayedFile("{BUILD_DIR}/unpacked/conf/packaged.exc"));
        deobfBinTask.dependsOn(new Object[]{"downloadMcpTools", "mergeJars", "genSrgs"});
        deobfBinTask.dependsOn(new Object[]{binTask});
        ProcessJarTask deobfTask = this.makeTask("deobfuscateJar", ProcessJarTask.class);
        deobfTask.setSrg(this.delayedFile("{BUILD_DIR}/unpacked/conf/packaged.srg"));
        deobfTask.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        deobfTask.setOutDirtyJar(this.delayedFile("{BUILD_DIR}/deobfuscated.jar"));
        this.addATs(deobfTask);
        deobfTask.setExceptorCfg(this.delayedFile("{BUILD_DIR}/unpacked/conf/packaged.exc"));
        deobfTask.dependsOn(new Object[]{"downloadMcpTools", "mergeJars", "genSrgs"});
        ReobfTask task4 = this.makeTask("reobf", ReobfTask.class);
        task4.reobf(this.project.getTasks().getByName("jar"), new Action<ArtifactSpec>(){

            public void execute(ArtifactSpec arg0) {
                JavaPluginConvention javaConv = (JavaPluginConvention)UserBasePlugin.this.project.getConvention().getPlugins().get("java");
                arg0.setClasspath(((SourceSet)javaConv.getSourceSets().getByName("main")).getCompileClasspath());
            }
        });
        this.project.getTasks().getByName("assemble").dependsOn(new Object[]{task4});
        CopyAssetsTask task5 = this.makeTask("copyAssets", CopyAssetsTask.class);
        task5.setAssetsDir(this.delayedFile("{CACHE_DIR}/minecraft/assets"));
        task5.setOutputDir(this.delayedFile("{ASSET_DIR}"));
        task5.setAssetIndex(this.getAssetIndexClosure());
        task5.dependsOn(new Object[]{"getAssets"});
    }

    private void delayedTasks() {
        ProcessJarTask deobf = (ProcessJarTask)this.project.getTasks().getByName("deobfuscateJar");
        boolean clean = deobf.isClean();
        DelayedFile decompOut = clean ? this.getDecompOut() : this.delayedFile("{BUILD_DIR}/decompiled.jar");
        DecompileTask decompile = this.makeTask("decompile", DecompileTask.class);
        decompile.setInJar(deobf.getDelayedOutput());
        decompile.setOutJar(decompOut);
        decompile.setFernFlower(this.delayedFile("{CACHE_DIR}/minecraft/fernflower.jar"));
        decompile.setPatch(this.delayedFile("{BUILD_DIR}/unpacked/conf/packaged.patch"));
        decompile.setAstyleConfig(this.delayedFile("{BUILD_DIR}/unpacked/conf/astyle.cfg"));
        decompile.dependsOn(new Object[]{"downloadMcpTools", "deobfuscateJar", "genSrgs"});
        this.doPostDecompTasks(clean, decompOut);
    }

    protected abstract void doPostDecompTasks(boolean var1, DelayedFile var2);

    protected abstract DelayedFile getBinPatchOut();

    protected abstract DelayedFile getDecompOut();

    protected abstract void addATs(ProcessJarTask var1);

    private void configureDeps() {
        this.project.getConfigurations().create("userDevPackageDepConfig");
        this.project.getConfigurations().create("apiJavaDocsConfig");
        this.project.getConfigurations().create("apiSrcConfig");
        this.project.getConfigurations().create("minecraftNatives");
        this.project.getConfigurations().create("minecraft");
        ExtractTask extractUserDev = this.makeTask("extractUserDev", ExtractTask.class);
        extractUserDev.into(this.delayedFile("{BUILD_DIR}/unpacked"));
        extractUserDev.doLast((Action)new Action<Task>(){

            public void execute(Task arg0) {
                UserBasePlugin.this.readAndApplyJson(UserBasePlugin.this.delayedFile("{BUILD_DIR}/unpacked/dev.json").call(), "minecraft", "minecraftNatives", arg0.getLogger());
            }
        });
        ExtractTask extractNatives = this.makeTask("extractNatives", ExtractTask.class);
        extractNatives.into(this.delayedFile("{BUILD_DIR}/natives"));
        extractNatives.dependsOn(new Object[]{"extractUserDev"});
        this.project.getDependencies().add("compile", (Object)this.project.fileTree((Object)"libs"));
    }

    protected void configureCompilation() {
        Configuration config = this.project.getConfigurations().getByName("minecraft");
        Javadoc javadoc = (Javadoc)this.project.getTasks().getByName("javadoc");
        javadoc.getClasspath().add((FileCollection)config);
        JavaPluginConvention javaConv = (JavaPluginConvention)this.project.getConvention().getPlugins().get("java");
        IdeaModel ideaConv = (IdeaModel)this.project.getExtensions().getByName("idea");
        EclipseModel eclipseConv = (EclipseModel)this.project.getExtensions().getByName("eclipse");
        SourceSet main = (SourceSet)javaConv.getSourceSets().getByName("main");
        SourceSet test = (SourceSet)javaConv.getSourceSets().getByName("test");
        SourceSet api = (SourceSet)javaConv.getSourceSets().create("api");
        javaConv.setSourceCompatibility((Object)"1.6");
        javaConv.setTargetCompatibility((Object)"1.6");
        api.setCompileClasspath(api.getCompileClasspath().plus((FileCollection)config));
        main.setCompileClasspath(main.getCompileClasspath().plus((FileCollection)config).plus((FileCollection)api.getOutput()));
        test.setCompileClasspath(test.getCompileClasspath().plus((FileCollection)config).plus((FileCollection)api.getOutput()).plus(main.getCompileClasspath()));
        ((Collection)((Map)ideaConv.getModule().getScopes().get("COMPILE")).get("plus")).add(config);
        eclipseConv.getClasspath().getPlusConfigurations().add(config);
        ideaConv.getModule().getSourceDirs().addAll(main.getAllSource().getFiles());
        ideaConv.getModule().getSourceDirs().addAll(test.getAllSource().getFiles());
        ideaConv.getModule().getSourceDirs().addAll(api.getAllSource().getFiles());
    }

    private void doSourceReplacement() {
        ScalaCompile compile;
        ScalaSourceSet set;
        JavaPluginConvention javaConv = (JavaPluginConvention)this.project.getConvention().getPlugins().get("java");
        SourceSet main = (SourceSet)javaConv.getSourceSets().getByName("main");
        SourceCopyTask task = this.makeTask("sourceMainJava", SourceCopyTask.class);
        task.setSource(main.getJava());
        task.replace(((UserExtension)this.getExtension()).getReplacements());
        task.include(((UserExtension)this.getExtension()).getIncludes());
        task.setOutput(this.delayedFile("{BUILD_DIR}/sources/java"));
        JavaCompile compile2 = (JavaCompile)this.project.getTasks().getByName(main.getCompileJavaTaskName());
        compile2.dependsOn(new Object[]{"sourceMainJava"});
        compile2.setSource((Object)task.getOutput());
        if (this.project.getPlugins().hasPlugin("scala")) {
            set = (ScalaSourceSet)new DslObject((Object)main).getConvention().getPlugins().get("scala");
            task = this.makeTask("sourceMainScala", SourceCopyTask.class);
            task.setSource(set.getScala());
            task.replace(((UserExtension)this.getExtension()).getReplacements());
            task.include(((UserExtension)this.getExtension()).getIncludes());
            task.setOutput(this.delayedFile("{BUILD_DIR}/sources/scala"));
            compile = (ScalaCompile)this.project.getTasks().getByName(main.getCompileTaskName("scala"));
            compile.dependsOn(new Object[]{"sourceMainScala"});
            compile.setSource((Object)task.getOutput());
        }
        if (this.project.getPlugins().hasPlugin("groovy")) {
            set = (GroovySourceSet)new DslObject((Object)main).getConvention().getPlugins().get("groovy");
            task = this.makeTask("sourceMainGroovy", SourceCopyTask.class);
            task.setSource(set.getGroovy());
            task.replace(((UserExtension)this.getExtension()).getReplacements());
            task.include(((UserExtension)this.getExtension()).getIncludes());
            task.setOutput(this.delayedFile("{BUILD_DIR}/sources/groovy"));
            compile = (GroovyCompile)this.project.getTasks().getByName(main.getCompileTaskName("groovy"));
            compile.dependsOn(new Object[]{"sourceMainGroovy"});
            compile.setSource((Object)task.getOutput());
        }
    }

    protected void configureEclipse() {
        EclipseModel eclipseConv = (EclipseModel)this.project.getExtensions().getByName("eclipse");
        eclipseConv.getClasspath().setDownloadJavadoc(true);
        eclipseConv.getClasspath().setDownloadSources(true);
        eclipseConv.getClasspath().getFile().getWhenMerged().add((Action)new Action<Classpath>(){

            public void execute(Classpath classpath) {
                String natives = UserBasePlugin.this.delayedString("{BUILD_DIR}/natives").call().replace('\\', '/');
                for (ClasspathEntry e : classpath.getEntries()) {
                    org.gradle.plugins.ide.eclipse.model.Library lib;
                    if (!(e instanceof org.gradle.plugins.ide.eclipse.model.Library) || !(lib = (org.gradle.plugins.ide.eclipse.model.Library)e).getPath().contains("lwjg") && !lib.getPath().contains("jinput")) continue;
                    lib.setNativeLibraryLocation(natives);
                }
            }
        });
        DefaultTask task = this.makeTask("afterEclipseImport", DefaultTask.class);
        task.doLast((Action)new Action<Object>(){

            public void execute(Object obj) {
                try {
                    Node root = new XmlParser().parseText(Files.toString((File)UserBasePlugin.this.project.file((Object)".classpath"), (Charset)Charset.defaultCharset()));
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("name", "org.eclipse.jdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY");
                    map.put("value", UserBasePlugin.this.delayedString("{BUILD_DIR}/natives").call());
                    for (Node child : root.children()) {
                        if (!child.attribute((Object)"path").equals("org.springsource.ide.eclipse.gradle.classpathcontainer")) continue;
                        child.appendNode((Object)"attributes").appendNode((Object)"attribute", map);
                        break;
                    }
                    String result = XmlUtil.serialize((Node)root);
                    UserBasePlugin.this.project.getLogger().lifecycle(result);
                    Files.write((CharSequence)result, (File)UserBasePlugin.this.project.file((Object)".classpath"), (Charset)Charset.defaultCharset());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
    }

    protected void configureIntellij() {
        IdeaModel ideaConv = (IdeaModel)this.project.getExtensions().getByName("idea");
        ideaConv.getModule().getExcludeDirs().addAll(this.project.files(new Object[]{".gradle", "build"}).getFiles());
        ideaConv.getModule().setDownloadJavadoc(true);
        ideaConv.getModule().setDownloadSources(true);
        DefaultTask task = this.makeTask("genIntellijRuns", DefaultTask.class);
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                try {
                    String module = task.getProject().getProjectDir().getCanonicalPath();
                    File file = UserBasePlugin.this.project.file((Object)".idea/workspace.xml");
                    if (!file.exists()) {
                        throw new RuntimeException("Only run this task after importing a build.gradle file into intellij!");
                    }
                    DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                    Document doc = docBuilder.parse(file);
                    UserBasePlugin.this.injectIntellijRuns(doc, module);
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "no");
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("encoding", "UTF-8");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                    DOMSource source = new DOMSource(doc);
                    StreamResult result = new StreamResult(file);
                    transformer.transform(source, result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        if (ideaConv.getWorkspace().getIws() == null) {
            return;
        }
        ideaConv.getWorkspace().getIws().withXml((Closure)new Closure<Object>((Object)this, null){

            public Object call(Object ... obj) {
                Element root = ((XmlProvider)this.getDelegate()).asElement();
                Document doc = root.getOwnerDocument();
                try {
                    UserBasePlugin.this.injectIntellijRuns(doc, UserBasePlugin.this.project.getProjectDir().getCanonicalPath());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    public final void injectIntellijRuns(Document doc, String module) throws DOMException, IOException {
        Element root = null;
        NodeList list = doc.getElementsByTagName("component");
        for (int i = 0; i < list.getLength(); ++i) {
            Element e = (Element)list.item(i);
            if (!"RunManager".equals(e.getAttribute("name"))) continue;
            root = e;
            break;
        }
        Element child = doc.createElement("configuration");
        child.setAttribute("default", "false");
        child.setAttribute("name", "Minecraft Client");
        child.setAttribute("type", "Application");
        child.setAttribute("factoryName", "Application");
        child.setAttribute("default", "false");
        root.appendChild(child);
        Element sub = doc.createElement("extension");
        sub.setAttribute("name", "coverage");
        sub.setAttribute("enabled", "false");
        sub.setAttribute("sample_coverage", "true");
        sub.setAttribute("runner", "idea");
        child.appendChild(sub);
        sub = doc.createElement("option");
        sub.setAttribute("name", "MAIN_CLASS_NAME");
        sub.setAttribute("value", "net.minecraft.launchwrapper.Launch");
        child.appendChild(sub);
        sub = doc.createElement("option");
        sub.setAttribute("name", "VM_PARAMETERS");
        sub.setAttribute("value", "-Xincgc -Xmx1024M -Xms1024M -Djava.library.path=\"" + this.delayedFile("{BUILD_DIR}/natives").call().getCanonicalPath().replace(module, "$PROJECT_DIR$") + "\" -Dfml.ignoreInvalidMinecraftCertificates=true");
        child.appendChild(sub);
        sub = doc.createElement("option");
        sub.setAttribute("name", "PROGRAM_PARAMETERS");
        sub.setAttribute("value", "--version 1.6 --tweakClass cpw.mods.fml.common.launcher.FMLTweaker --username=Player1234");
        child.appendChild(sub);
        sub = doc.createElement("option");
        sub.setAttribute("name", "WORKING_DIRECTORY");
        sub.setAttribute("value", "file://" + this.delayedFile("{ASSET_DIR}").call().getParentFile().getCanonicalPath().replace(module, "$PROJECT_DIR$"));
        child.appendChild(sub);
        sub = doc.createElement("option");
        sub.setAttribute("name", "ALTERNATIVE_JRE_PATH_ENABLED");
        sub.setAttribute("value", "false");
        child.appendChild(sub);
        sub = doc.createElement("option");
        sub.setAttribute("name", "ALTERNATIVE_JRE_PATH");
        sub.setAttribute("value", "");
        child.appendChild(sub);
        sub = doc.createElement("option");
        sub.setAttribute("name", "ENABLE_SWING_INSPECTOR");
        sub.setAttribute("value", "false");
        child.appendChild(sub);
        sub = doc.createElement("option");
        sub.setAttribute("name", "ENV_VARIABLES");
        child.appendChild(sub);
        sub = doc.createElement("option");
        sub.setAttribute("name", "PASS_PARENT_ENVS");
        sub.setAttribute("value", "true");
        child.appendChild(sub);
        sub = doc.createElement("module");
        sub.setAttribute("name", ((IdeaModel)this.project.getExtensions().getByName("idea")).getModule().getName());
        child.appendChild(sub);
        child.appendChild(doc.createElement("envs"));
        sub = doc.createElement("RunnerSettings");
        sub.setAttribute("RunnerId", "Run");
        child.appendChild(sub);
        sub = doc.createElement("ConfigurationWrapper");
        sub.setAttribute("RunnerId", "Run");
        child.appendChild(sub);
        child.appendChild(doc.createElement("method"));
        child = doc.createElement("configuration");
        child.setAttribute("default", "false");
        child.setAttribute("name", "Minecraft Server");
        child.setAttribute("type", "Application");
        child.setAttribute("factoryName", "Application");
        child.setAttribute("default", "false");
        root.appendChild(child);
        sub = doc.createElement("extension");
        sub.setAttribute("name", "coverage");
        sub.setAttribute("enabled", "false");
        sub.setAttribute("sample_coverage", "true");
        sub.setAttribute("runner", "idea");
        child.appendChild(sub);
        sub = doc.createElement("option");
        sub.setAttribute("name", "MAIN_CLASS_NAME");
        sub.setAttribute("value", "cpw.mods.fml.relauncher.ServerLaunchWrapper");
        child.appendChild(sub);
        sub = doc.createElement("option");
        sub.setAttribute("name", "VM_PARAMETERS");
        sub.setAttribute("value", "-Xincgc -Dfml.ignoreInvalidMinecraftCertificates=true");
        child.appendChild(sub);
        sub = doc.createElement("option");
        sub.setAttribute("name", "PROGRAM_PARAMETERS");
        sub.setAttribute("value", "");
        child.appendChild(sub);
        sub = doc.createElement("option");
        sub.setAttribute("name", "WORKING_DIRECTORY");
        sub.setAttribute("value", "file://" + this.delayedFile("{ASSET_DIR}").call().getParentFile().getCanonicalPath().replace(module, "$PROJECT_DIR$"));
        child.appendChild(sub);
        sub = doc.createElement("option");
        sub.setAttribute("name", "ALTERNATIVE_JRE_PATH_ENABLED");
        sub.setAttribute("value", "false");
        child.appendChild(sub);
        sub = doc.createElement("option");
        sub.setAttribute("name", "ALTERNATIVE_JRE_PATH");
        sub.setAttribute("value", "");
        child.appendChild(sub);
        sub = doc.createElement("option");
        sub.setAttribute("name", "ENABLE_SWING_INSPECTOR");
        sub.setAttribute("value", "false");
        child.appendChild(sub);
        sub = doc.createElement("option");
        sub.setAttribute("name", "ENV_VARIABLES");
        child.appendChild(sub);
        sub = doc.createElement("option");
        sub.setAttribute("name", "PASS_PARENT_ENVS");
        sub.setAttribute("value", "true");
        child.appendChild(sub);
        sub = doc.createElement("module");
        sub.setAttribute("name", ((IdeaModel)this.project.getExtensions().getByName("idea")).getModule().getName());
        child.appendChild(sub);
        child.appendChild(doc.createElement("envs"));
        sub = doc.createElement("RunnerSettings");
        sub.setAttribute("RunnerId", "Run");
        child.appendChild(sub);
        sub = doc.createElement("ConfigurationWrapper");
        sub.setAttribute("RunnerId", "Run");
        child.appendChild(sub);
        child.appendChild(doc.createElement("method"));
    }

    @Override
    public void afterEvaluate() {
        super.afterEvaluate();
        if (this.delayedFile("{BUILD_DIR}/unpacked/dev.json").call().exists()) {
            this.readAndApplyJson(this.delayedFile("{BUILD_DIR}/unpacked/dev.json").call(), "minecraft", "minecraftNatives", this.project.getLogger());
        }
        ((ExtractTask)((Object)this.project.getTasks().findByName("extractUserDev"))).from(this.delayedFile(this.project.getConfigurations().getByName("userDevPackageDepConfig").getSingleFile().getAbsolutePath()));
        ((Task)this.project.getTasks().findByName("getAssetsIndex")).dependsOn(new Object[]{"extractUserDev"});
        ProcessJarTask binDeobf = (ProcessJarTask)this.project.getTasks().getByName("deobfBinJar");
        ProcessJarTask decompDeobf = (ProcessJarTask)this.project.getTasks().getByName("deobfuscateJar");
        binDeobf.addTransformer(((UserExtension)this.getExtension()).getAccessTransformers().toArray());
        JavaPluginConvention javaConv = (JavaPluginConvention)this.project.getConvention().getPlugins().get("java");
        SourceSet main = (SourceSet)javaConv.getSourceSets().getByName("main");
        SourceSet api = (SourceSet)javaConv.getSourceSets().getByName("api");
        for (File at : main.getResources().getFiles()) {
            if (!at.getName().toLowerCase().endsWith("_at.cfg")) continue;
            binDeobf.addTransformer(at);
            decompDeobf.addTransformer(at);
        }
        for (File at : api.getResources().getFiles()) {
            if (!at.getName().toLowerCase().endsWith("_at.cfg")) continue;
            binDeobf.addTransformer(at);
            decompDeobf.addTransformer(at);
        }
        this.delayedTasks();
        this.doSourceReplacement();
        final File deobfOut = ((ProcessJarTask)this.project.getTasks().getByName("deobfBinJar")).getOutJar();
        this.project.getDependencies().add("minecraft", (Object)this.project.files(new Object[]{deobfOut}));
        EclipseModel eclipseConv = (EclipseModel)this.project.getExtensions().getByName("eclipse");
        eclipseConv.getClasspath().getFile().getWhenMerged().add((Action)new Action<Classpath>(){
            FileReferenceFactory factory = new FileReferenceFactory();

            public void execute(Classpath classpath) {
                for (ClasspathEntry e : classpath.getEntries()) {
                    org.gradle.plugins.ide.eclipse.model.Library lib;
                    if (!(e instanceof org.gradle.plugins.ide.eclipse.model.Library) || !(lib = (org.gradle.plugins.ide.eclipse.model.Library)e).getLibrary().getFile().equals(deobfOut)) continue;
                    lib.setJavadocPath(this.factory.fromFile(UserBasePlugin.this.project.getConfigurations().getByName("apiJavaDocsConfig").getSingleFile()));
                    lib.setSourcePath(this.factory.fromFile(UserBasePlugin.this.project.getConfigurations().getByName("apiSrcConfig").getSingleFile()));
                }
            }
        });
        IdeaModel ideaConv = (IdeaModel)this.project.getExtensions().getByName("idea");
        ideaConv.getModule().getIml().getWhenMerged().add((Action)new Action<Module>(){
            PathFactory factory = new PathFactory();

            public void execute(Module module) {
                for (Dependency d : module.getDependencies()) {
                    SingleEntryModuleLibrary lib;
                    if (!(d instanceof SingleEntryModuleLibrary) || !(lib = (SingleEntryModuleLibrary)d).getLibraryFile().equals(deobfOut)) continue;
                    lib.getJavadoc().add(this.factory.path("jar://" + UserBasePlugin.this.project.getConfigurations().getByName("apiJavaDocsConfig").getSingleFile().getAbsolutePath().replace('\\', '/') + "!/"));
                    lib.getSources().add(this.factory.path("jar://" + UserBasePlugin.this.project.getConfigurations().getByName("apiSrcConfig").getSingleFile().getAbsolutePath().replace('\\', '/') + "!/"));
                }
            }
        });
        this.fixEclipseProject("eclipse/.metadata/.plugins/org.eclipse.core.resources/.projects/Minecraft/.location");
    }

    @Override
    public void finalCall() {
        Configuration config = this.project.getConfigurations().getByName("minecraft");
        Javadoc javadoc = (Javadoc)this.project.getTasks().getByName("javadoc");
        javadoc.getClasspath().add((FileCollection)config);
        JavaPluginConvention javaConv = (JavaPluginConvention)this.project.getConvention().getPlugins().get("java");
        SourceSet main = (SourceSet)javaConv.getSourceSets().getByName("main");
        main.getCompileConfigurationName();
        Configuration compileConfig = this.project.getConfigurations().getByName(main.getCompileConfigurationName());
        compileConfig.extendsFrom(new Configuration[]{config});
    }

    protected void fixEclipseProject(String path) {
        File f = new File(path);
        if (f.exists()) {
            String projectDir = "URI//" + this.project.getProjectDir().toURI().toString();
            try {
                FileOutputStream fos = new FileOutputStream(f);
                fos.write(LOCATION_BEFORE);
                fos.write((byte)((projectDir.length() & 0xFF) >> 8));
                fos.write((byte)((projectDir.length() & 0xFF) >> 0));
                fos.write(projectDir.getBytes());
                fos.write(LOCATION_AFTER);
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void readAndApplyJson(File file, String depConfig, String nativeConfig, Logger log) {
        if (this.version == null) {
            try {
                this.version = JsonFactory.loadVersion(file);
            }
            catch (Exception e) {
                log.error("" + file + " could not be parsed");
                Throwables.propagate((Throwable)e);
            }
        }
        if (this.hasApplied) {
            return;
        }
        DependencyHandler handler = this.project.getDependencies();
        if (this.project.getConfigurations().getByName(depConfig).getState() == Configuration.State.UNRESOLVED) {
            for (Library lib : this.version.getLibraries()) {
                if (lib.natives != null) continue;
                handler.add(depConfig, (Object)lib.getArtifactName());
            }
        } else {
            log.info("RESOLVED: " + depConfig);
        }
        if (this.project.getConfigurations().getByName(nativeConfig).getState() == Configuration.State.UNRESOLVED) {
            for (Library lib : this.version.getLibraries()) {
                if (lib.natives == null) continue;
                handler.add(nativeConfig, (Object)lib.getArtifactName());
            }
        } else {
            log.info("RESOLVED: " + nativeConfig);
        }
        this.hasApplied = true;
        ExtractTask task = (ExtractTask)((Object)this.project.getTasks().findByName("extractNatives"));
        for (File dep : this.project.getConfigurations().getByName("minecraftNatives").getFiles()) {
            log.info("ADDING NATIVE: " + dep.getPath());
            task.from(this.delayedFile(dep.getAbsolutePath()));
            task.exclude("META-INF/**", "META-INF/**");
        }
    }

    @Override
    public String resolve(String pattern, Project project, UserExtension exten) {
        pattern = super.resolve(pattern, project, exten);
        pattern = pattern.replace("{API_VERSION}", exten.getApiVersion());
        return pattern;
    }
}

