/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import com.google.common.io.ByteStreams;
import de.oceanlabs.mcp.mcinjector.MCInjectorImpl;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import joptsimple.internal.Strings;
import net.md_5.specialsource.AccessMap;
import net.md_5.specialsource.Jar;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.RemapperPreprocessor;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JarProvider;
import net.md_5.specialsource.provider.JointProvider;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.abstractutil.CachedTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ProcessJarTask
extends CachedTask {
    @InputFile
    private DelayedFile inJar;
    @InputFile
    private DelayedFile srg;
    @InputFile
    private DelayedFile exceptorCfg;
    @OutputFile
    @CachedTask.Cached
    private DelayedFile outCleanJar;
    @OutputFile
    @CachedTask.Cached
    private DelayedFile outDirtyJar = new DelayedFile(this.getProject(), "{BUILD_DIR}/deobfuscated.jar");
    private ArrayList<DelayedFile> ats = new ArrayList();
    private boolean isClean = true;

    public void addTransformer(DelayedFile ... obj) {
        for (DelayedFile object : obj) {
            this.ats.add(object);
        }
    }

    public void addTransformer(Object ... obj) {
        for (Object object : obj) {
            if (object instanceof File) {
                this.ats.add(new DelayedFile(this.getProject(), ((File)object).getAbsolutePath()));
            } else if (object instanceof String) {
                this.ats.add(new DelayedFile(this.getProject(), (String)object));
            } else {
                this.ats.add(new DelayedFile(this.getProject(), object.toString()));
            }
            this.isClean = false;
        }
    }

    @TaskAction
    public void doTask() throws IOException {
        File tempObfJar = new File(this.getTemporaryDir(), "deobfed.jar");
        File tempExcJar = new File(this.getTemporaryDir(), "excepted.jar");
        HashSet<File> ats = new HashSet<File>();
        for (DelayedFile obj : this.ats) {
            ats.add(this.getProject().file((Object)obj).getCanonicalFile());
        }
        this.getLogger().lifecycle("Applying SpecialSource...");
        this.deobfJar(this.getInJar(), tempObfJar, this.getSrg(), ats);
        this.getLogger().lifecycle("Applying Exceptor...");
        this.applyExceptor(tempObfJar, tempExcJar, this.getExceptorCfg(), new File(this.getTemporaryDir(), "exceptor.log"));
        File out = this.isClean ? this.getOutCleanJar() : this.getOutDirtyJar();
        this.getLogger().lifecycle("Injecting source info...");
        this.injectSourceInfo(tempExcJar, out);
    }

    private void deobfJar(File inJar, File outJar, File srg, Collection<File> ats) throws IOException {
        this.getLogger().debug("INPUT: " + inJar);
        this.getLogger().debug("OUTPUT: " + outJar);
        JarMapping mapping = new JarMapping();
        mapping.loadMappings(srg);
        AccessMap accessMap = new AccessMap();
        this.getLogger().info("Using AccessTransformers...");
        for (File at : ats) {
            this.getLogger().info("" + at);
            accessMap.loadAccessTransformer(at);
        }
        RemapperPreprocessor processor = new RemapperPreprocessor(null, mapping, accessMap);
        JarRemapper remapper = new JarRemapper(processor, mapping);
        Jar input = Jar.init((File)inJar);
        JointProvider inheritanceProviders = new JointProvider();
        inheritanceProviders.add((InheritanceProvider)new JarProvider(input));
        mapping.setFallbackInheritanceProvider((InheritanceProvider)inheritanceProviders);
        remapper.remapJar(input, outJar);
    }

    public void applyExceptor(File inJar, File outJar, File config, File log) throws IOException {
        this.getLogger().debug("INPUT: " + inJar);
        this.getLogger().debug("OUTPUT: " + outJar);
        this.getLogger().debug("CONFIG: " + config);
        MCInjectorImpl.process((String)inJar.getCanonicalPath(), (String)outJar.getCanonicalPath(), (String)config.getCanonicalPath(), (String)log.getCanonicalPath(), null, (int)0, null, (boolean)false);
    }

    private void injectSourceInfo(File inJar, File outJar) throws IOException {
        ZipFile in = new ZipFile(inJar);
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outJar)));
        for (ZipEntry zipEntry : Collections.list(in.entries())) {
            if (zipEntry.getName().contains("META-INF")) continue;
            if (zipEntry.isDirectory()) {
                out.putNextEntry(zipEntry);
                continue;
            }
            ZipEntry n = new ZipEntry(zipEntry.getName());
            n.setTime(zipEntry.getTime());
            out.putNextEntry(n);
            byte[] data = ByteStreams.toByteArray((InputStream)in.getInputStream(zipEntry));
            if (zipEntry.getName().endsWith(".class")) {
                data = this.correctSourceName(zipEntry.getName(), data);
            }
            out.write(data);
        }
        out.flush();
        out.close();
        in.close();
    }

    private byte[] correctSourceName(String name, byte[] data) {
        ClassReader reader = new ClassReader(data);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        if (Strings.isNullOrEmpty((String)node.sourceFile) || !node.sourceFile.endsWith(".java")) {
            node.sourceFile = name.substring(name.lastIndexOf(47) + 1).replace(".class", ".java");
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public File getExceptorCfg() {
        return this.exceptorCfg.call();
    }

    public void setExceptorCfg(DelayedFile exceptorCfg) {
        this.exceptorCfg = exceptorCfg;
    }

    public File getInJar() {
        return this.inJar.call();
    }

    public void setInJar(DelayedFile inJar) {
        this.inJar = inJar;
    }

    public File getSrg() {
        return this.srg.call();
    }

    public void setSrg(DelayedFile srg) {
        this.srg = srg;
    }

    public File getOutCleanJar() {
        return this.outCleanJar.call();
    }

    public void setOutCleanJar(DelayedFile outJar) {
        this.outCleanJar = outJar;
    }

    public File getOutDirtyJar() {
        return this.outDirtyJar.call();
    }

    public void setOutDirtyJar(DelayedFile outDirtyJar) {
        this.outDirtyJar = outDirtyJar;
    }

    public boolean isClean() {
        return this.isClean;
    }

    public DelayedFile getDelayedOutput() {
        return this.isClean ? this.outCleanJar : this.outDirtyJar;
    }

    public File getOutJar() {
        return this.isClean ? this.outCleanJar.call() : this.outDirtyJar.call();
    }

    @InputFiles
    public FileCollection getAts() {
        return this.getProject().files(this.ats.toArray());
    }
}

