/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.dev;

import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import edu.sc.seis.launch4j.Launch4jPluginExtension;
import groovy.lang.Closure;
import groovy.util.MapEntry;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.common.BasePlugin;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.common.version.Library;
import net.minecraftforge.gradle.common.version.json.JsonFactory;
import net.minecraftforge.gradle.delayed.DelayedBase;
import net.minecraftforge.gradle.dev.DevConstants;
import net.minecraftforge.gradle.dev.DevExtension;
import net.minecraftforge.gradle.tasks.CopyAssetsTask;
import net.minecraftforge.gradle.tasks.GenSrgTask;
import net.minecraftforge.gradle.tasks.MergeJarsTask;
import net.minecraftforge.gradle.tasks.abstractutil.DownloadTask;
import net.minecraftforge.gradle.tasks.abstractutil.ExtractTask;
import net.minecraftforge.gradle.tasks.dev.CompressLZMA;
import net.minecraftforge.gradle.tasks.dev.MergeMappingsTask;
import org.apache.shiro.util.AntPathMatcher;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.process.ExecSpec;

public abstract class DevBasePlugin
extends BasePlugin<DevExtension> {
    private AntPathMatcher antMatcher = new AntPathMatcher();
    protected static final String[] JAVA_FILES = new String[]{"**.java", "*.java", "**/*.java"};

    @Override
    public void applyPlugin() {
        this.applyExternalPlugin("launch4j");
        this.project.getTasks().getByName("uploadArchives").dependsOn(new Object[]{"launch4j"});
        ExtractTask task = this.makeTask("extractWorkspace", ExtractTask.class);
        task.getOutputs().upToDateWhen((Closure)new Closure<Boolean>(null){

            public Boolean call(Object ... obj) {
                File file = new File(DevBasePlugin.this.project.getProjectDir(), "eclipse");
                return file.exists() && file.isDirectory();
            }
        });
        task.from(this.delayedFile("eclipse-workspace-dev.zip"));
        task.into(this.delayedFile("eclipse"));
        DownloadTask task1 = this.makeTask("downloadBaseInstaller", DownloadTask.class);
        task1.setOutput(this.delayedFile("{BUILD_DIR}/tmp/installer_base.{INSTALLER_VERSION}.jar"));
        task1.setUrl(this.delayedString("http://files.minecraftforge.net/installer/forge-installer-{INSTALLER_VERSION}-shrunk.jar"));
        task1 = this.makeTask("downloadL4J", DownloadTask.class);
        task1.setOutput(this.delayedFile("{CACHE_DIR}/minecraft/launch4j.zip"));
        task1.setUrl(this.delayedString(DevConstants.LAUNCH4J_URL));
        task = this.makeTask("extractL4J", ExtractTask.class);
        task.dependsOn(new Object[]{"downloadL4J"});
        task.from(this.delayedFile("{CACHE_DIR}/minecraft/launch4j.zip"));
        task.into(this.delayedFile("{BUILD_DIR}/launch4j_exec"));
        MergeMappingsTask task2 = this.makeTask("fixMappings", MergeMappingsTask.class);
        task2.setPackageCSV(this.delayedFile("{MAPPINGS_DIR}/packages.csv"));
        task2.setInSRG(this.delayedFile("{MAPPINGS_DIR}/joined.srg"));
        task2.setInEXC(this.delayedFile("{MAPPINGS_DIR}/joined.exc"));
        task2.setOutSRG(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/packaged-{MC_VERSION}.srg"));
        task2.setOutEXC(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/packaged-{MC_VERSION}.exc"));
        task2.setInPatch(this.delayedFile("{MAPPINGS_DIR}/patches/minecraft_ff.patch"));
        task2.setOutPatch(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/packaged-{MC_VERSION}.patch"));
        CompressLZMA task3 = this.makeTask("compressDeobfData", CompressLZMA.class);
        task3.setInputFile(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/packaged-{MC_VERSION}.srg"));
        task3.setOutputFile(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/deobfuscation_data-{MC_VERSION}.lzma"));
        task3.dependsOn(new Object[]{"fixMappings"});
        MergeJarsTask task4 = this.makeTask("mergeJars", MergeJarsTask.class);
        task4.setClient(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft/{MC_VERSION}/minecraft-{MC_VERSION}.jar"));
        task4.setServer(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_server/{MC_VERSION}/minecraft_server-{MC_VERSION}.jar"));
        task4.setOutJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        task4.setMergeCfg(this.delayedFile("{FML_DIR}/mcp_merge.cfg"));
        task4.dependsOn(new Object[]{"downloadClient", "downloadServer"});
        CopyAssetsTask task5 = this.makeTask("copyAssets", CopyAssetsTask.class);
        task5.setAssetsDir(this.delayedFile("{CACHE_DIR}/minecraft/assets"));
        task5.setOutputDir(this.delayedFile("eclipse/run/assets"));
        task5.setAssetIndex(this.getAssetIndexClosure());
        task5.dependsOn(new Object[]{"getAssets", "extractWorkspace"});
        GenSrgTask task6 = this.makeTask("genSrgs", GenSrgTask.class);
        task6.setInSrg(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/packaged-{MC_VERSION}.srg"));
        task6.setNotchToMcpSrg(this.delayedFile("{BUILD_DIR}/tmp/notch2mcp.srg"));
        task6.setMcpToSrgSrg(this.delayedFile("{BUILD_DIR}/tmp/mcp2srg.srg"));
        task6.setMcpToNotchSrg(this.delayedFile("{BUILD_DIR}/tmp/mcp2notch.srg"));
        task6.setMethodsCsv(this.delayedFile("{MAPPINGS_DIR}/methods.csv"));
        task6.setFieldsCsv(this.delayedFile("{MAPPINGS_DIR}/fields.csv"));
        task6.dependsOn(new Object[]{"fixMappings"});
    }

    private void configureLaunch4J() {
        File installer = ((Zip)this.project.getTasks().getByName("packageInstaller")).getArchivePath();
        File output = new File(installer.getParentFile(), installer.getName().replace(".jar", "-win.exe"));
        this.project.getArtifacts().add("archives", (Object)output);
        Launch4jPluginExtension ext = (Launch4jPluginExtension)this.project.getExtensions().getByName("launch4j");
        ext.setOutfile(output.getAbsolutePath());
        ext.setJar(installer.getAbsolutePath());
        String command = this.delayedFile("{BUILD_DIR}/launch4j_exec").call().getAbsolutePath();
        command = command + "/launch4j";
        if (Constants.OPERATING_SYSTEM == Constants.OperatingSystem.WINDOWS) {
            command = command + "c.exe";
        } else {
            final String extraCommand = command;
            Task task = this.project.getTasks().getByName("extractL4J");
            task.doLast((Action)new Action<Task>(){

                public void execute(Task task) {
                    File f = new File(extraCommand);
                    if (!f.canExecute()) {
                        boolean worked = f.setExecutable(true);
                        DevBasePlugin.this.project.getLogger().info("Setting file +X " + worked + " : " + f.getPath());
                    }
                    FileTree tree = DevBasePlugin.this.delayedFileTree("{BUILD_DIR}/launch4j_exec/bin").call();
                    tree.visit(new FileVisitor(){

                        public void visitDir(FileVisitDetails dirDetails) {
                        }

                        public void visitFile(FileVisitDetails fileDetails) {
                            if (!fileDetails.getFile().canExecute()) {
                                boolean worked = fileDetails.getFile().setExecutable(true);
                                DevBasePlugin.this.project.getLogger().info("Setting file +X " + worked + " : " + fileDetails.getPath());
                            }
                        }
                    });
                }
            });
        }
        ext.setLaunch4jCmd(command);
        Task task = this.project.getTasks().getByName("generateXmlConfig");
        task.dependsOn(new Object[]{"packageInstaller", "extractL4J"});
        task.getInputs().file((Object)installer);
        String icon = ext.getIcon();
        if (icon == null || icon.isEmpty()) {
            icon = this.delayedFile("{BUILD_DIR}/launch4j_exec/demo/SimpleApp/l4j/SimpleApp.ico").call().getAbsolutePath();
        }
        icon = new File(icon).getAbsolutePath();
        ext.setIcon(icon);
        ext.setMainClassName(this.delayedString("{MAIN_CLASS}").call());
    }

    @Override
    protected final String getDevJson() {
        return DelayedBase.resolve("{FML_DIR}/jsons/{MC_VERSION}-dev.json", this.project, this);
    }

    @Override
    public void afterEvaluate() {
        super.afterEvaluate();
        this.configureLaunch4J();
        try {
            Copy copyTask = this.makeTask("extractNatives", Copy.class);
            copyTask.exclude(new String[]{"META-INF", "META-INF/**", "META-INF/*"});
            copyTask.into((Object)this.delayedString("eclipse/run/bin/natives").call());
            copyTask.dependsOn(new Object[]{"extractWorkspace"});
            String devJson = this.getDevJson();
            if (devJson == null) {
                this.project.getLogger().info("Dev json not set, could not create native downloads tasks");
                return;
            }
            if (this.version == null) {
                File jsonFile = this.delayedFile(devJson).call().getAbsoluteFile();
                try {
                    this.version = JsonFactory.loadVersion(jsonFile);
                }
                catch (Exception e) {
                    this.project.getLogger().error("" + jsonFile + " could not be parsed");
                    Throwables.propagate((Throwable)e);
                }
            }
            int i = 1;
            for (Library lib : this.version.getLibraries()) {
                if (lib.extract == null) continue;
                String path = lib.getPathNatives();
                DownloadTask task = this.makeTask("downloadNatives-" + i, DownloadTask.class);
                task.setOutput(this.delayedFile("{CACHE_DIR}/" + path));
                task.setUrl(this.delayedString(lib.getUrl() + path));
                copyTask.from(new Object[]{this.delayedZipTree("{CACHE_DIR}/" + path)});
                copyTask.dependsOn(new Object[]{"downloadNatives-" + i});
                ++i;
            }
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    @Override
    protected Class<DevExtension> getExtensionClass() {
        return DevExtension.class;
    }

    protected String getServerClassPath(File json) {
        try {
            JsonRootNode node = Constants.PARSER.parse(Files.newReader((File)json, (Charset)Charset.defaultCharset()));
            StringBuilder buf = new StringBuilder();
            for (JsonNode lib : node.getArrayNode("versionInfo", "libraries")) {
                if (!lib.isNode("serverreq") || !lib.getBooleanValue("serverreq").booleanValue()) continue;
                String[] pts = lib.getStringValue("name").split(":");
                buf.append(String.format("libraries/%s/%s/%s/%s-%s.jar ", pts[0].replace('.', '/'), pts[1], pts[2], pts[1], pts[2]));
            }
            buf.append(this.delayedString("minecraft_server.{MC_VERSION}").call());
            return buf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String resolve(String pattern, Project project, DevExtension exten) {
        pattern = super.resolve(pattern, project, exten);
        pattern = pattern.replace("{MAIN_CLASS}", exten.getMainClass());
        pattern = pattern.replace("{INSTALLER_VERSION}", exten.getInstallerVersion());
        pattern = pattern.replace("{FML_DIR}", exten.getFmlDir());
        pattern = pattern.replace("{MAPPINGS_DIR}", exten.getFmlDir() + "/conf");
        return pattern;
    }

    protected static String runGit(Project project, final File workDir, final String ... args) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        project.exec((Closure)new Closure<ExecSpec>((Object)project, (Object)project){

            public ExecSpec call() {
                ExecSpec exec = (ExecSpec)this.getDelegate();
                exec.setExecutable((Object)"git");
                exec.args((Object[])args);
                exec.setStandardOutput((OutputStream)out);
                exec.setWorkingDir((Object)workDir);
                return exec;
            }
        });
        return out.toString().trim();
    }

    private boolean shouldSign(String path, List<String> includes, List<String> excludes) {
        for (String exclude : excludes) {
            if (!this.antMatcher.matches(exclude, path)) continue;
            return false;
        }
        for (String include : includes) {
            if (!this.antMatcher.matches(include, path)) continue;
            return true;
        }
        return includes.size() == 0;
    }

    protected void signJar(File archive, String keyName, String ... filters) throws IOException {
        ZipEntry n;
        if (!this.project.hasProperty("jarsigner")) {
            return;
        }
        ArrayList<String> excludes = new ArrayList<String>();
        ArrayList<String> includes = new ArrayList<String>();
        for (String s : filters) {
            if (s.startsWith("!")) {
                excludes.add(s.substring(1));
                continue;
            }
            includes.add(s);
        }
        HashMap unsigned = Maps.newHashMap();
        File temp = new File(archive.getAbsoluteFile() + ".tmp");
        File signed = new File(archive.getAbsoluteFile() + ".signed");
        if (temp.exists()) {
            temp.delete();
        }
        if (signed.exists()) {
            signed.delete();
        }
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(temp)));
        ZipFile base = new ZipFile(archive);
        for (ZipEntry zipEntry : Collections.list(base.entries())) {
            if (this.shouldSign(zipEntry.getName(), includes, excludes)) {
                ZipEntry n2 = new ZipEntry(zipEntry.getName());
                n2.setTime(zipEntry.getTime());
                out.putNextEntry(n2);
                ByteStreams.copy((InputStream)base.getInputStream(zipEntry), (OutputStream)out);
                continue;
            }
            unsigned.put(zipEntry.getName(), new MapEntry((Object)ByteStreams.toByteArray((InputStream)base.getInputStream(zipEntry)), (Object)zipEntry.getTime()));
        }
        base.close();
        out.close();
        Map jarsigner = (Map)this.project.property("jarsigner");
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("alias", keyName);
        hashMap.put("storepass", jarsigner.get("storepass"));
        hashMap.put("keypass", jarsigner.get("keypass"));
        hashMap.put("keystore", new File((String)jarsigner.get("keystore")).getAbsolutePath());
        hashMap.put("jar", temp.getAbsolutePath());
        hashMap.put("signedjar", signed.getAbsolutePath());
        this.project.getAnt().invokeMethod("signjar", (Object)hashMap);
        archive.delete();
        temp.delete();
        out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(archive)));
        base = new ZipFile(signed);
        for (ZipEntry zipEntry : Collections.list(base.entries())) {
            if (zipEntry.isDirectory()) {
                out.putNextEntry(zipEntry);
                continue;
            }
            n = new ZipEntry(zipEntry.getName());
            n.setTime(zipEntry.getTime());
            out.putNextEntry(n);
            ByteStreams.copy((InputStream)base.getInputStream(zipEntry), (OutputStream)out);
        }
        base.close();
        for (Map.Entry entry : unsigned.entrySet()) {
            n = new ZipEntry((String)entry.getKey());
            n.setTime((Long)((Map.Entry)entry.getValue()).getValue());
            out.putNextEntry(n);
            out.write((byte[])((Map.Entry)entry.getValue()).getKey());
        }
        out.close();
        signed.delete();
    }
}

