/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common;

import com.google.common.base.Throwables;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import net.minecraftforge.gradle.FileLogListenner;
import net.minecraftforge.gradle.common.BaseExtension;
import net.minecraftforge.gradle.common.JenkinsExtension;
import net.minecraftforge.gradle.common.version.AssetIndex;
import net.minecraftforge.gradle.common.version.Version;
import net.minecraftforge.gradle.common.version.json.JsonFactory;
import net.minecraftforge.gradle.delayed.DelayedBase;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.delayed.DelayedFileTree;
import net.minecraftforge.gradle.delayed.DelayedString;
import net.minecraftforge.gradle.tasks.DownloadAssetsTask;
import net.minecraftforge.gradle.tasks.ObtainFernFlowerTask;
import net.minecraftforge.gradle.tasks.abstractutil.DownloadTask;
import org.gradle.BuildListener;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.api.tasks.Delete;
import org.gradle.testfixtures.ProjectBuilder;

public abstract class BasePlugin<K extends BaseExtension>
implements Plugin<Project>,
DelayedBase.IDelayedResolver<K> {
    public Project project;
    public Version version;
    public AssetIndex assetIndex;
    private static boolean displayBanner = true;

    public final void apply(Project arg) {
        this.project = arg;
        FileLogListenner listenner = new FileLogListenner(this.project.file((Object)".gradle/gradle.log"));
        this.project.getLogging().addStandardOutputListener((StandardOutputListener)listenner);
        this.project.getLogging().addStandardErrorListener((StandardOutputListener)listenner);
        this.project.getGradle().addBuildListener((BuildListener)listenner);
        if (this.project.getBuildDir().getAbsolutePath().contains("!")) {
            this.project.getLogger().error("Build path has !, This will screw over a lot of java things as ! is used to denote archive paths, REMOVE IT if you want to continue");
            throw new RuntimeException("Build path contains !");
        }
        this.project.getExtensions().create("minecraft", this.getExtensionClass(), new Object[]{this.project});
        this.project.getExtensions().create("jenkins", JenkinsExtension.class, new Object[]{this.project});
        this.addMavenRepo("forge", "http://files.minecraftforge.net/maven");
        this.project.getRepositories().mavenCentral();
        this.addMavenRepo("minecraft", "https://libraries.minecraft.net/");
        this.project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                BasePlugin.this.afterEvaluate();
                try {
                    File index;
                    if (BasePlugin.this.version != null && (index = BasePlugin.this.delayedFile("{CACHE_DIR}/minecraft/assets/indexes/" + BasePlugin.this.version.getAssets() + ".json").call()).exists()) {
                        BasePlugin.this.parseAssetIndex();
                    }
                }
                catch (Exception e) {
                    Throwables.propagate((Throwable)e);
                }
                BasePlugin.this.finalCall();
            }
        });
        this.makeObtainTasks();
        this.applyPlugin();
    }

    public abstract void applyPlugin();

    protected abstract String getDevJson();

    public void afterEvaluate() {
        if (!displayBanner) {
            return;
        }
        this.project.getLogger().lifecycle("****************************");
        this.project.getLogger().lifecycle(" Powered By MCP:            ");
        this.project.getLogger().lifecycle(" http://mcp.ocean-labs.de/  ");
        this.project.getLogger().lifecycle(" Searge, ProfMobius, Fesh0r,");
        this.project.getLogger().lifecycle(" R4wk, ZeuX, IngisKahn      ");
        this.project.getLogger().lifecycle(this.delayedString(" MCP Data version : {MCP_VERSION}").call());
        this.project.getLogger().lifecycle("****************************");
        displayBanner = false;
    }

    public void finalCall() {
    }

    private void makeObtainTasks() {
        DownloadTask task = this.makeTask("downloadClient", DownloadTask.class);
        task.setOutput(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft/{MC_VERSION}/minecraft-{MC_VERSION}.jar"));
        task.setUrl(this.delayedString("http://s3.amazonaws.com/Minecraft.Download/versions/{MC_VERSION}/{MC_VERSION}.jar"));
        task = this.makeTask("downloadServer", DownloadTask.class);
        task.setOutput(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_server/{MC_VERSION}/minecraft_server-{MC_VERSION}.jar"));
        task.setUrl(this.delayedString("http://s3.amazonaws.com/Minecraft.Download/versions/{MC_VERSION}/minecraft_server.{MC_VERSION}.jar"));
        ObtainFernFlowerTask mcpTask = this.makeTask("downloadMcpTools", ObtainFernFlowerTask.class);
        mcpTask.setMcpUrl(this.delayedString("http://mcp.ocean-labs.de/files/archive/mcp804.zip"));
        mcpTask.setFfJar(this.delayedFile("{CACHE_DIR}/minecraft/fernflower.jar"));
        DownloadTask getAssetsIndex = this.makeTask("getAssetsIndex", DownloadTask.class);
        getAssetsIndex.setUrl(this.delayedString("https://s3.amazonaws.com/Minecraft.Download/indexes/{ASSET_INDEX}.json"));
        getAssetsIndex.setOutput(this.delayedFile("{CACHE_DIR}/minecraft/assets/indexes/{ASSET_INDEX}.json"));
        getAssetsIndex.setDoesCache(false);
        getAssetsIndex.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                try {
                    BasePlugin.this.parseAssetIndex();
                }
                catch (Exception e) {
                    Throwables.propagate((Throwable)e);
                }
            }
        });
        getAssetsIndex.getOutputs().upToDateWhen((Closure)new Closure<Boolean>((Object)this, null){

            public Boolean call(Object ... obj) {
                return false;
            }
        });
        DownloadAssetsTask assets = this.makeTask("getAssets", DownloadAssetsTask.class);
        assets.setAssetsDir(this.delayedFile("{CACHE_DIR}/minecraft/assets"));
        assets.setIndex(this.getAssetIndexClosure());
        assets.dependsOn(new Object[]{"getAssetsIndex"});
        Delete clearCache = this.makeTask("cleanCache", Delete.class);
        clearCache.delete(new Object[]{this.delayedFile("{CACHE_DIR}/minecraft")});
    }

    public void parseAssetIndex() throws JsonSyntaxException, JsonIOException, IOException {
        this.assetIndex = JsonFactory.loadAssetsIndex(this.delayedFile("{CACHE_DIR}/minecraft/assets/indexes/{ASSET_INDEX}.json").call());
    }

    public Closure<AssetIndex> getAssetIndexClosure() {
        return new Closure<AssetIndex>((Object)this, null){

            public AssetIndex call(Object ... obj) {
                return BasePlugin.this.getAssetIndex();
            }
        };
    }

    public AssetIndex getAssetIndex() {
        return this.assetIndex;
    }

    protected Class<K> getExtensionClass() {
        return BaseExtension.class;
    }

    public final K getExtension() {
        return (K)((BaseExtension)this.project.getExtensions().getByName("minecraft"));
    }

    public DefaultTask makeTask(String name) {
        return this.makeTask(name, DefaultTask.class);
    }

    public <T extends Task> T makeTask(String name, Class<T> type) {
        return BasePlugin.makeTask(this.project, name, type);
    }

    public static <T extends Task> T makeTask(Project proj, String name, Class<T> type) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", name);
        map.put("type", type);
        return (T)proj.task(map, name);
    }

    public static Project getProject(File buildFile, Project parent) {
        ProjectBuilder builder = ProjectBuilder.builder();
        builder = buildFile != null ? builder.withProjectDir(buildFile.getParentFile()).withName(buildFile.getParentFile().getName()) : builder.withProjectDir(new File("."));
        if (parent != null) {
            builder = builder.withParent(parent);
        }
        Project project = builder.build();
        if (buildFile != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("from", buildFile.getAbsolutePath());
            project.apply(map);
        }
        return project;
    }

    public void applyExternalPlugin(String plugin) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("plugin", plugin);
        this.project.apply(map);
    }

    public void addMavenRepo(final String name, final String url) {
        this.project.getRepositories().maven((Action)new Action<MavenArtifactRepository>(){

            public void execute(MavenArtifactRepository repo) {
                repo.setName(name);
                repo.setUrl((Object)url);
            }
        });
    }

    @Override
    public String resolve(String pattern, Project project, K exten) {
        if (this.version != null) {
            pattern = pattern.replace("{ASSET_INDEX}", this.version.getAssets());
        }
        return pattern;
    }

    protected DelayedString delayedString(String path) {
        return new DelayedString(this.project, path, new DelayedBase.IDelayedResolver[]{this});
    }

    protected DelayedFile delayedFile(String path) {
        return new DelayedFile(this.project, path, new DelayedBase.IDelayedResolver[]{this});
    }

    protected DelayedFileTree delayedFileTree(String path) {
        return new DelayedFileTree(this.project, path, new DelayedBase.IDelayedResolver[]{this});
    }

    protected DelayedFileTree delayedZipTree(String path) {
        return new DelayedFileTree(this.project, path, true, this);
    }
}

