/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.dev;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lzma.streams.LzmaOutputStream;
import net.minecraftforge.gradle.delayed.DelayedFile;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class CompressLZMA
extends DefaultTask {
    @InputFile
    private DelayedFile inputFile;
    @OutputFile
    private DelayedFile outputFile;

    @TaskAction
    public void doTask() throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.getInputFile()));
        LzmaOutputStream out = new LzmaOutputStream.Builder((OutputStream)new FileOutputStream(this.getOutputFile())).useEndMarkerMode(true).build();
        ByteStreams.copy((InputStream)in, (OutputStream)out);
        in.close();
        out.close();
    }

    public File getInputFile() {
        return this.inputFile.call();
    }

    public void setInputFile(DelayedFile inputFile) {
        this.inputFile = inputFile;
    }

    public File getOutputFile() {
        return this.outputFile.call();
    }

    public void setOutputFile(DelayedFile outputFile) {
        this.outputFile = outputFile;
    }
}

