/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.user.reobf;

import com.google.common.io.Files;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Date;
import net.md_5.specialsource.Jar;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.provider.ClassLoaderProvider;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JarProvider;
import net.md_5.specialsource.provider.JointProvider;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.dev.ObfuscateTask;
import net.minecraftforge.gradle.tasks.user.reobf.ArtifactSpec;
import net.minecraftforge.gradle.tasks.user.reobf.DelayedThingy;
import net.minecraftforge.gradle.tasks.user.reobf.ReobfTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public class ObfArtifact
extends AbstractPublishArtifact {
    Object toObfArtifact;
    private String name;
    private String extension;
    private String classifier;
    private Date date;
    private File file;
    private FileCollection classpath;
    private String type;
    private final Closure<Object> toObfGenerator;
    private final Task caller;
    final ArtifactSpec outputSpec;

    public ObfArtifact(AbstractArchiveTask toObf, ArtifactSpec artifactSpec, ReobfTask task) {
        this(new DelayedThingy(toObf), artifactSpec, task);
        this.toObfArtifact = (PublishArtifact)toObf;
    }

    public ObfArtifact(PublishArtifact toObf, ArtifactSpec artifactSpec, ReobfTask task) {
        this(new DelayedThingy(toObf), artifactSpec, task);
        this.toObfArtifact = toObf;
    }

    public ObfArtifact(File toObf, ArtifactSpec artifactSpec, ReobfTask task) {
        this(new DelayedThingy(toObf), artifactSpec, task);
        this.toObfArtifact = toObf;
    }

    public ObfArtifact(Closure<Object> toObf, ArtifactSpec outputSpec, ReobfTask task) {
        super(new Object[]{task});
        this.caller = task;
        this.toObfGenerator = toObf;
        this.outputSpec = outputSpec;
    }

    public File getToObf() {
        Object toObf = null;
        if (this.toObfGenerator != null) {
            toObf = this.toObfGenerator.call();
        }
        if (toObf == null) {
            return null;
        }
        if (toObf instanceof File) {
            return (File)toObf;
        }
        return new File(toObf.toString());
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.toObfArtifact != null) {
            return ((File)this.toObfArtifact).getName();
        }
        if (this.outputSpec.getBaseName() != null) {
            return this.outputSpec.getBaseName().toString();
        }
        return this.getFile() == null ? null : this.getFile().getName();
    }

    public FileCollection getClasspath() {
        if (this.classpath != null) {
            return this.classpath;
        }
        if (this.outputSpec.getClasspath() != null) {
            return (FileCollection)this.outputSpec.getClasspath();
        }
        return null;
    }

    public String getExtension() {
        if (this.extension != null) {
            return this.extension;
        }
        if (this.toObfArtifact != null) {
            return ((PublishArtifact)this.toObfArtifact).getExtension();
        }
        if (this.outputSpec.getExtension() != null) {
            return this.outputSpec.getExtension().toString();
        }
        return Files.getFileExtension(this.getFile() == null ? null : this.getFile().getName());
    }

    public String getType() {
        return this.getExtension();
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClassifier() {
        if (this.classifier != null) {
            return this.classifier;
        }
        if (this.toObfArtifact != null) {
            return ((PublishArtifact)this.toObfArtifact).getClassifier();
        }
        if (this.outputSpec.getClassifier() != null) {
            return this.outputSpec.getClassifier().toString();
        }
        return null;
    }

    public Date getDate() {
        if (this.date == null) {
            File file = this.getFile();
            if (file == null) {
                return null;
            }
            long modified = file.lastModified();
            if (modified == 0L) {
                return null;
            }
            new Date(modified);
        }
        return this.date;
    }

    public File getFile() {
        if (this.file == null) {
            File input = this.getToObf();
            this.outputSpec.resolve();
            this.name = this.outputSpec.getArchiveName().toString();
            this.classifier = this.outputSpec.getClassifier().toString();
            this.extension = this.outputSpec.getExtension().toString();
            this.classpath = (FileCollection)this.outputSpec.getClasspath();
            this.file = new File(input.getParentFile(), this.outputSpec.getArchiveName().toString());
            return this.file;
        }
        return this.file;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    void generate() throws IOException {
        File toObf = this.getToObf();
        if (toObf == null) {
            throw new InvalidUserDataException("Unable to obfuscate as the file to obfuscate has not been specified");
        }
        File output = this.getFile();
        File inTemp = new File(this.caller.getTemporaryDir(), "jarIn.jar");
        Files.copy((File)toObf, (File)inTemp);
        JarMapping mapping = new JarMapping();
        mapping.loadMappings(new DelayedFile(this.caller.getProject(), "{BUILD_DIR}/unpacked/conf/mcp-srg.srg").call());
        JarRemapper remapper = new JarRemapper(null, mapping);
        Jar input = Jar.init((File)inTemp);
        JointProvider inheritanceProviders = new JointProvider();
        inheritanceProviders.add((InheritanceProvider)new JarProvider(input));
        if (this.classpath != null) {
            inheritanceProviders.add((InheritanceProvider)new ClassLoaderProvider((ClassLoader)new URLClassLoader(ObfuscateTask.toUrls(this.classpath))));
        }
        mapping.setFallbackInheritanceProvider((InheritanceProvider)inheritanceProviders);
        remapper.remapJar(input, output);
    }
}

