/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.delayed.DelayedString;
import net.minecraftforge.gradle.tasks.abstractutil.CachedTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class DownloadTask
extends CachedTask {
    @Input
    private DelayedString url;
    @OutputFile
    @CachedTask.Cached
    private DelayedFile output;

    @TaskAction
    public void doTask() throws IOException {
        File outputFile = this.getProject().file((Object)this.getOutput());
        outputFile.getParentFile().mkdirs();
        outputFile.createNewFile();
        this.getLogger().info("Downloading " + this.getUrl() + " to " + outputFile);
        HttpURLConnection connect = (HttpURLConnection)new URL(this.getUrl()).openConnection();
        connect.setInstanceFollowRedirects(true);
        InputStream inStream = connect.getInputStream();
        FileOutputStream outStream = new FileOutputStream(outputFile);
        int data = inStream.read();
        while (data != -1) {
            ((OutputStream)outStream).write(data);
            data = inStream.read();
        }
        inStream.close();
        outStream.flush();
        ((OutputStream)outStream).close();
        this.getLogger().info("Download complete");
    }

    public File getOutput() {
        return this.output.call();
    }

    public void setOutput(DelayedFile output) {
        this.output = output;
    }

    public String getUrl() {
        return this.url.call();
    }

    public void setUrl(DelayedString url) {
        this.url = url;
    }
}

