/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user;

import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import groovy.util.Node;
import groovy.util.XmlParser;
import groovy.xml.XmlUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.gradle.common.BasePlugin;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedBase;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.delayed.DelayedFileTree;
import net.minecraftforge.gradle.delayed.DelayedString;
import net.minecraftforge.gradle.tasks.DecompileTask;
import net.minecraftforge.gradle.tasks.GenSrgTask;
import net.minecraftforge.gradle.tasks.MergeJarsTask;
import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.abstractutil.ExtractTask;
import net.minecraftforge.gradle.tasks.user.ApplyBinPatchesTask;
import net.minecraftforge.gradle.tasks.user.reobf.ArtifactSpec;
import net.minecraftforge.gradle.tasks.user.reobf.ReobfTask;
import net.minecraftforge.gradle.user.UserExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.Library;
import org.gradle.plugins.ide.eclipse.model.internal.FileReferenceFactory;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.Module;
import org.gradle.plugins.ide.idea.model.PathFactory;
import org.gradle.plugins.ide.idea.model.SingleEntryModuleLibrary;

public abstract class UserBasePlugin
extends BasePlugin<UserExtension>
implements DelayedBase.IDelayedResolver<UserExtension> {
    private boolean hasApplied = false;
    private static final byte[] LOCATION_BEFORE = new byte[]{64, -79, -117, -127, 35, -68, 0, 20, 26, 37, -106, -25, -93, -109, -66, 30};
    private static final byte[] LOCATION_AFTER = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -64, 88, -5, -13, 35, -68, 0, 20, 26, 81, -13, -116, 123, -69, 119, -58};

    @Override
    public void applyPlugin() {
        this.applyExternalPlugin("java");
        this.applyExternalPlugin("maven");
        this.applyExternalPlugin("eclipse");
        this.applyExternalPlugin("idea");
        this.configureDeps();
        this.configureCompilation();
        this.configureEclipse();
        this.configureIntellij();
        this.tasks();
        DefaultTask task = this.makeTask("setupCIWorkspace", DefaultTask.class);
        task.dependsOn(new Object[]{"genSrgs", "deobfBinJar"});
        task.setGroup("ForgeGradle");
        task = this.makeTask("setupDevWorkspace", DefaultTask.class);
        task.dependsOn(new Object[]{"genSrgs", "deobfBinJar", "copyAssets", "extractNatives"});
        task.setGroup("ForgeGradle");
        task = this.makeTask("setupDecompWorkspace", DefaultTask.class);
        task.dependsOn(new Object[]{"setupDevWorkspace"});
        task.setGroup("ForgeGradle");
        project.getTasks().getByName("eclipseClasspath").dependsOn(new Object[]{"setupDevWorkspace"});
    }

    @Override
    protected Class<UserExtension> getExtensionClass() {
        return UserExtension.class;
    }

    @Override
    protected String getDevJson() {
        return DelayedBase.resolve("{BUILD_DIR}/unpacked/dev.json", project, new DelayedBase.IDelayedResolver[0]);
    }

    private void tasks() {
        MergeJarsTask task = this.makeTask("mergeJars", MergeJarsTask.class);
        task.setClient(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft/{MC_VERSION}/minecraft-{MC_VERSION}.jar"));
        task.setServer(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_server/{MC_VERSION}/minecraft_server-{MC_VERSION}.jar"));
        task.setOutJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        task.setMergeCfg(this.delayedFile("{BUILD_DIR}/unpacked/conf/mcp_merge.cfg"));
        task.dependsOn(new Object[]{"extractUserDev", "downloadClient", "downloadServer"});
        GenSrgTask task2 = this.makeTask("genSrgs", GenSrgTask.class);
        task2.setInSrg(this.delayedFile("{BUILD_DIR}/unpacked/conf/packaged.srg"));
        task2.setNotchToMcpSrg(this.delayedFile("{BUILD_DIR}/unpacked/conf/notch-mcp.srg"));
        task2.setMcpToSrgSrg(this.delayedFile("{BUILD_DIR}/unpacked/conf/mcp-srg.srg"));
        task2.setMcpToNotchSrg(this.delayedFile("{BUILD_DIR}/unpacked/conf/mcp-notch.srg"));
        task2.setMethodsCsv(this.delayedFile("{BUILD_DIR}/unpacked/mappings/methods.csv"));
        task2.setFieldsCsv(this.delayedFile("{BUILD_DIR}/unpacked/mappings/fields.csv"));
        task2.dependsOn(new Object[]{"extractUserDev"});
        ApplyBinPatchesTask binTask = this.makeTask("applyBinPatches", ApplyBinPatchesTask.class);
        binTask.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        binTask.setOutJar(this.getBinPatchOut());
        binTask.setPatches(this.delayedFile("{BUILD_DIR}/unpacked/devbinpatches.pack.lzma"));
        binTask.setClassesJar(this.delayedFile("{BUILD_DIR}/unpacked/binaries.jar"));
        binTask.setResources(this.delayedFileTree("{BUILD_DIR}/unpacked/src/main/resources"));
        binTask.dependsOn(new Object[]{"mergeJars"});
        ProcessJarTask deobfBinTask = this.makeTask("deobfBinJar", ProcessJarTask.class);
        deobfBinTask.setSrg(this.delayedFile("{BUILD_DIR}/unpacked/conf/notch-mcp.srg"));
        deobfBinTask.setOutDirtyJar(this.delayedFile("{BUILD_DIR}/deobfuscated-bin.jar"));
        this.addATs(deobfBinTask);
        deobfBinTask.setExceptorCfg(this.delayedFile("{BUILD_DIR}/unpacked/conf/packaged.exc"));
        deobfBinTask.dependsOn(new Object[]{"downloadMcpTools", "mergeJars", "genSrgs"});
        deobfBinTask.dependsOn(new Object[]{binTask});
        ProcessJarTask deobfTask = this.makeTask("deobfuscateJar", ProcessJarTask.class);
        deobfTask.setSrg(this.delayedFile("{BUILD_DIR}/unpacked/conf/packaged.srg"));
        deobfTask.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        deobfTask.setOutDirtyJar(this.delayedFile("{BUILD_DIR}/deobfuscated.jar"));
        this.addATs(deobfTask);
        deobfTask.setExceptorCfg(this.delayedFile("{BUILD_DIR}/unpacked/conf/packaged.exc"));
        deobfTask.dependsOn(new Object[]{"downloadMcpTools", "mergeJars", "genSrgs"});
        ReobfTask task4 = this.makeTask("reobf", ReobfTask.class);
        task4.reobf(project.getTasks().getByName("jar"), new Action<ArtifactSpec>(){

            public void execute(ArtifactSpec arg0) {
                JavaPluginConvention javaConv = (JavaPluginConvention)BasePlugin.project.getConvention().getPlugins().get("java");
                arg0.setClasspath(((SourceSet)javaConv.getSourceSets().getByName("main")).getCompileClasspath());
            }
        });
        project.getTasks().getByName("assemble").dependsOn(new Object[]{task4});
        Sync task5 = this.makeTask("copyAssets", Sync.class);
        task5.from(new Object[]{this.delayedFile("{CACHE_DIR}/minecraft/assets")});
        task5.into((Object)this.delayedFile("{ASSET_DIR}"));
        task5.dependsOn(new Object[]{"getAssets"});
    }

    private void delayedTasks() {
        ProcessJarTask deobf = (ProcessJarTask)project.getTasks().getByName("deobfuscateJar");
        boolean clean = deobf.isClean();
        DelayedFile decompOut = clean ? this.getDecompOut() : this.delayedFile("{BUILD_DIR}/decompiled.jar");
        DecompileTask decompile = this.makeTask("decompile", DecompileTask.class);
        decompile.setInJar(deobf.getDelayedOutput());
        decompile.setOutJar(decompOut);
        decompile.setFernFlower(this.delayedFile("{CACHE_DIR}/minecraft/fernflower.jar"));
        decompile.setPatch(this.delayedFile("{BUILD_DIR}/unpacked/conf/packaged.patch"));
        decompile.setAstyleConfig(this.delayedFile("{BUILD_DIR}/unpacked/conf/astyle.cfg"));
        decompile.dependsOn(new Object[]{"downloadMcpTools", "deobfuscateJar", "genSrgs"});
        this.doPostDecompTasks(clean, decompOut);
    }

    protected abstract void doPostDecompTasks(boolean var1, DelayedFile var2);

    protected abstract DelayedFile getBinPatchOut();

    protected abstract DelayedFile getDecompOut();

    protected abstract void addATs(ProcessJarTask var1);

    private void configureDeps() {
        project.getConfigurations().create("userDevPackageDepConfig");
        project.getConfigurations().create("apiJavaDocsConfig");
        project.getConfigurations().create("apiSrcConfig");
        project.getConfigurations().create("minecraftNatives");
        project.getConfigurations().create("minecraft");
        ExtractTask extractUserDev = this.makeTask("extractUserDev", ExtractTask.class);
        extractUserDev.into(this.delayedFile("{BUILD_DIR}/unpacked"));
        extractUserDev.doLast((Action)new Action<Task>(){

            public void execute(Task arg0) {
                UserBasePlugin.this.readAndApplyJson(UserBasePlugin.this.delayedFile("{BUILD_DIR}/unpacked/dev.json").call(), "minecraft", "minecraftNatives", arg0.getLogger());
            }
        });
        ExtractTask extractNatives = this.makeTask("extractNatives", ExtractTask.class);
        extractNatives.into(this.delayedFile("{BUILD_DIR}/natives"));
        extractNatives.dependsOn(new Object[]{"extractUserDev"});
    }

    protected void configureCompilation() {
        Configuration config = project.getConfigurations().getByName("minecraft");
        Javadoc javadoc = (Javadoc)project.getTasks().getByName("javadoc");
        javadoc.getClasspath().add((FileCollection)config);
        JavaPluginConvention javaConv = (JavaPluginConvention)project.getConvention().getPlugins().get("java");
        IdeaModel ideaConv = (IdeaModel)project.getExtensions().getByName("idea");
        EclipseModel eclipseConv = (EclipseModel)project.getExtensions().getByName("eclipse");
        SourceSet main = (SourceSet)javaConv.getSourceSets().getByName("main");
        SourceSet api = (SourceSet)javaConv.getSourceSets().create("api");
        javaConv.setSourceCompatibility((Object)"1.6");
        javaConv.setTargetCompatibility((Object)"1.6");
        api.setCompileClasspath(api.getCompileClasspath().plus((FileCollection)config));
        main.setCompileClasspath(main.getCompileClasspath().plus((FileCollection)config).plus((FileCollection)api.getOutput()));
        ((Collection)((Map)ideaConv.getModule().getScopes().get("COMPILE")).get("plus")).add(config);
        eclipseConv.getClasspath().getPlusConfigurations().add(config);
        ideaConv.getModule().getSourceDirs().addAll(main.getAllSource().getFiles());
        ideaConv.getModule().getSourceDirs().addAll(api.getAllSource().getFiles());
    }

    protected void configureEclipse() {
        EclipseModel eclipseConv = (EclipseModel)project.getExtensions().getByName("eclipse");
        eclipseConv.getClasspath().setDownloadJavadoc(true);
        eclipseConv.getClasspath().setDownloadSources(true);
        eclipseConv.getClasspath().getFile().getWhenMerged().add((Action)new Action<Classpath>(){

            public void execute(Classpath classpath) {
                String natives = UserBasePlugin.this.delayedString("{BUILD_DIR}/natives").call().replace('\\', '/');
                for (ClasspathEntry e : classpath.getEntries()) {
                    Library lib;
                    if (!(e instanceof Library) || !(lib = (Library)e).getPath().contains("lwjg") && !lib.getPath().contains("jinput")) continue;
                    lib.setNativeLibraryLocation(natives);
                }
            }
        });
        DefaultTask task = this.makeTask("afterEclipseImport", DefaultTask.class);
        task.doLast((Action)new Action<Object>(){

            public void execute(Object obj) {
                try {
                    Node root = new XmlParser().parseText(Files.toString((File)BasePlugin.project.file((Object)".classpath"), (Charset)Charset.defaultCharset()));
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("name", "org.eclipse.jdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY");
                    map.put("value", UserBasePlugin.this.delayedString("{BUILD_DIR}/natives").call());
                    for (Node child : root.children()) {
                        if (!child.attribute((Object)"path").equals("org.springsource.ide.eclipse.gradle.classpathcontainer")) continue;
                        child.appendNode((Object)"attributes").appendNode((Object)"attribute", map);
                        break;
                    }
                    String result = XmlUtil.serialize((Node)root);
                    BasePlugin.project.getLogger().lifecycle(result);
                    Files.write((CharSequence)result, (File)BasePlugin.project.file((Object)".classpath"), (Charset)Charset.defaultCharset());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
    }

    protected void configureIntellij() {
        IdeaModel ideaConv = (IdeaModel)project.getExtensions().getByName("idea");
        ideaConv.getModule().getExcludeDirs().addAll(project.files(new Object[]{".gradle", "build"}).getFiles());
        ideaConv.getModule().setDownloadJavadoc(true);
        ideaConv.getModule().setDownloadSources(true);
    }

    @Override
    public void afterEvaluate() {
        super.afterEvaluate();
        if (this.delayedFile("{BUILD_DIR}/unpacked/dev.json").call().exists()) {
            this.readAndApplyJson(this.delayedFile("{BUILD_DIR}/unpacked/dev.json").call(), "minecraft", "minecraftNatives", project.getLogger());
        }
        ((ExtractTask)((Object)project.getTasks().findByName("extractUserDev"))).from(this.delayedFile(project.getConfigurations().getByName("userDevPackageDepConfig").getSingleFile().getAbsolutePath()));
        ProcessJarTask binDeobf = (ProcessJarTask)project.getTasks().getByName("deobfBinJar");
        ProcessJarTask decompDeobf = (ProcessJarTask)project.getTasks().getByName("deobfuscateJar");
        binDeobf.addTransformer(((UserExtension)this.getExtension()).getAccessTransformers().toArray());
        JavaPluginConvention javaConv = (JavaPluginConvention)project.getConvention().getPlugins().get("java");
        SourceSet main = (SourceSet)javaConv.getSourceSets().getByName("main");
        SourceSet api = (SourceSet)javaConv.getSourceSets().getByName("api");
        for (File at : main.getResources().getFiles()) {
            if (!at.getName().toLowerCase().endsWith("_at.cfg")) continue;
            binDeobf.addTransformer(at);
            decompDeobf.addTransformer(at);
        }
        for (File at : api.getResources().getFiles()) {
            if (!at.getName().toLowerCase().endsWith("_at.cfg")) continue;
            binDeobf.addTransformer(at);
            decompDeobf.addTransformer(at);
        }
        this.delayedTasks();
        final File deobfOut = ((ProcessJarTask)project.getTasks().getByName("deobfBinJar")).getOutJar();
        project.getDependencies().add("minecraft", (Object)project.files(new Object[]{deobfOut}));
        EclipseModel eclipseConv = (EclipseModel)project.getExtensions().getByName("eclipse");
        eclipseConv.getClasspath().getFile().getWhenMerged().add((Action)new Action<Classpath>(){
            FileReferenceFactory factory = new FileReferenceFactory();

            public void execute(Classpath classpath) {
                for (ClasspathEntry e : classpath.getEntries()) {
                    Library lib;
                    if (!(e instanceof Library) || !(lib = (Library)e).getLibrary().getFile().equals(deobfOut)) continue;
                    lib.setJavadocPath(this.factory.fromFile(BasePlugin.project.getConfigurations().getByName("apiJavaDocsConfig").getSingleFile()));
                    lib.setSourcePath(this.factory.fromFile(BasePlugin.project.getConfigurations().getByName("apiSrcConfig").getSingleFile()));
                }
            }
        });
        IdeaModel ideaConv = (IdeaModel)project.getExtensions().getByName("idea");
        ideaConv.getModule().getIml().getWhenMerged().add((Action)new Action<Module>(){
            PathFactory factory = new PathFactory();

            public void execute(Module module) {
                for (Dependency d : module.getDependencies()) {
                    SingleEntryModuleLibrary lib;
                    if (!(d instanceof SingleEntryModuleLibrary) || !(lib = (SingleEntryModuleLibrary)d).getLibraryFile().equals(deobfOut)) continue;
                    lib.getJavadoc().add(this.factory.path("jar://" + BasePlugin.project.getConfigurations().getByName("apiJavaDocsConfig").getSingleFile().getAbsolutePath().replace('\\', '/') + "!/"));
                    lib.getSources().add(this.factory.path("jar://" + BasePlugin.project.getConfigurations().getByName("apiSrcConfig").getSingleFile().getAbsolutePath().replace('\\', '/') + "!/"));
                }
            }
        });
        this.fixEclipseProject("eclipse/.metadata/.plugins/org.eclipse.core.resources/.projects/Minecraft/.location");
    }

    protected void fixEclipseProject(String path) {
        File f = new File(path);
        if (f.exists() && f.length() == 0L) {
            String projectDir = "URI//file:/" + project.getProjectDir().getAbsolutePath().replace('\\', '/');
            try {
                FileOutputStream fos = new FileOutputStream(f);
                fos.write(LOCATION_BEFORE);
                fos.write((byte)((projectDir.length() & 0xFF) >> 8));
                fos.write((byte)((projectDir.length() & 0xFF) >> 0));
                fos.write(projectDir.getBytes());
                fos.write(LOCATION_AFTER);
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void readAndApplyJson(File file, String depConfig, String nativeConfig, Logger log) {
        if (this.hasApplied) {
            return;
        }
        ArrayList<String> libs = new ArrayList<String>();
        ArrayList<String> natives = new ArrayList<String>();
        try {
            BufferedReader reader = Files.newReader((File)file, (Charset)Charset.defaultCharset());
            JsonRootNode root = Constants.PARSER.parse(reader);
            log.lifecycle("READING JSON NOW");
            for (JsonNode node : root.getArrayNode("libraries")) {
                String dep = node.getStringValue("name");
                if (dep.contains("_fixed")) continue;
                if (node.isNode("extract")) {
                    String osName = System.getProperty("os.name").toLowerCase();
                    if (osName.contains("linux") || osName.contains("unix")) {
                        natives.add(dep + ":" + node.getStringValue("natives", "linux"));
                    } else if (osName.contains("win")) {
                        natives.add(dep + ":" + node.getStringValue("natives", "windows"));
                    } else if (osName.contains("mac")) {
                        natives.add(dep + ":" + node.getStringValue("natives", "osx"));
                    } else {
                        natives.add(dep + ":" + node.getStringValue("natives", "linux"));
                        natives.add(dep + ":" + node.getStringValue("natives", "windows"));
                        natives.add(dep + ":" + node.getStringValue("natives", "osx"));
                    }
                    natives.add(dep);
                    continue;
                }
                libs.add(dep);
            }
            ((Reader)reader).close();
            DependencyHandler handler = project.getDependencies();
            if (project.getConfigurations().getByName(depConfig).getState() == Configuration.State.UNRESOLVED) {
                for (String dep : libs) {
                    handler.add(depConfig, (Object)dep);
                }
            } else {
                log.info("RESOLVED: " + depConfig);
            }
            if (project.getConfigurations().getByName(nativeConfig).getState() == Configuration.State.UNRESOLVED) {
                for (String dep : natives) {
                    handler.add(nativeConfig, (Object)dep);
                }
            } else {
                log.info("RESOLVED: " + nativeConfig);
            }
            this.hasApplied = true;
            ExtractTask task = (ExtractTask)((Object)project.getTasks().findByName("extractNatives"));
            for (File dep : project.getConfigurations().getByName("minecraftNatives").getFiles()) {
                log.info("ADDING NATIVE: " + dep.getPath());
                task.from(this.delayedFile(dep.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public String resolve(String pattern, Project project, UserExtension exten) {
        pattern = pattern.replace("{API_VERSION}", exten.getApiVersion());
        return pattern;
    }

    @Override
    protected DelayedString delayedString(String path) {
        return new DelayedString(project, path, new DelayedBase.IDelayedResolver[]{this});
    }

    @Override
    protected DelayedFile delayedFile(String path) {
        return new DelayedFile(project, path, new DelayedBase.IDelayedResolver[]{this});
    }

    @Override
    protected DelayedFileTree delayedFileTree(String path) {
        return new DelayedFileTree(project, path, new DelayedBase.IDelayedResolver[]{this});
    }

    @Override
    protected DelayedFileTree delayedZipTree(String path) {
        return new DelayedFileTree(project, path, true, this);
    }
}

