/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user;

import java.io.File;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.PatchJarTask;
import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.RemapSourcesTask;
import net.minecraftforge.gradle.user.UserBasePlugin;
import net.minecraftforge.gradle.user.UserExtension;
import org.gradle.api.Task;
import org.gradle.api.tasks.bundling.Zip;

public class FmlUserPlugin
extends UserBasePlugin {
    @Override
    public void applyPlugin() {
        super.applyPlugin();
        ProcessJarTask procTask = (ProcessJarTask)project.getTasks().getByName("deobfBinJar");
        procTask.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}.jar"));
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}-mcp.jar"));
        procTask = (ProcessJarTask)project.getTasks().getByName("deobfuscateJar");
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}-srg.jar"));
        Task task = project.getTasks().getByName("setupDecompWorkspace");
        task.dependsOn(new Object[]{"remapJar"});
    }

    @Override
    public void afterEvaluate() {
        project.getDependencies().add("userDevPackageDepConfig", (Object)("cpw.mods:fml:" + ((UserExtension)this.getExtension()).getApiVersion() + ":userdev"));
        super.afterEvaluate();
    }

    @Override
    protected void addATs(ProcessJarTask task) {
        task.addTransformer(this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources/fml_at.cfg"));
    }

    @Override
    protected DelayedFile getBinPatchOut() {
        return this.delayedFile("{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}.jar");
    }

    @Override
    protected DelayedFile getDecompOut() {
        return this.delayedFile("{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}-decomp.jar");
    }

    @Override
    protected void doPostDecompTasks(boolean isClean, DelayedFile decompOut) {
        DelayedFile fmled = this.delayedFile(isClean ? "{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}-fmled.jar" : "{BUILD_DIR}/decompiled-fmled.jar");
        DelayedFile injected = this.delayedFile(isClean ? "{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}-src-injected.jar" : "{BUILD_DIR}/decompiled-fmlinjected.jar");
        DelayedFile remapped = this.delayedFile(isClean ? "{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}-src.jar" : "{BUILD_DIR}/decompiled-remapped.jar");
        PatchJarTask fmlPatches = this.makeTask("doFmlPatches", PatchJarTask.class);
        fmlPatches.dependsOn(new Object[]{"decompile"});
        fmlPatches.setInJar(decompOut);
        fmlPatches.setOutJar(fmled);
        fmlPatches.setInPatches(this.delayedFile("{BUILD_DIR}/unpacked/fmlpatches.zip"));
        Zip inject = this.makeTask("addFmlSources", Zip.class);
        inject.dependsOn(new Object[]{"doFmlPatches"});
        inject.from(new Object[]{fmled.toZipTree()});
        inject.from(new Object[]{this.delayedFile("{BUILD_DIR}/unpacked/src/main/java")});
        inject.from(new Object[]{this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources")});
        File injectFile = injected.call();
        inject.setDestinationDir(injectFile.getParentFile());
        inject.setArchiveName(injectFile.getName());
        RemapSourcesTask remap = this.makeTask("remapJar", RemapSourcesTask.class);
        remap.dependsOn(new Object[]{"addFmlSources"});
        remap.setInJar(injected);
        remap.setOutJar(remapped);
        remap.setFieldsCsv(this.delayedFile("{BUILD_DIR}/unpacked/mappings/fields.csv"));
        remap.setMethodsCsv(this.delayedFile("{BUILD_DIR}/unpacked/mappings/methods.csv"));
        remap.setParamsCsv(this.delayedFile("{BUILD_DIR}/unpacked/mappings/params.csv"));
        project.getDependencies().add("apiSrcConfig", (Object)project.files(new Object[]{remapped}));
    }
}

