/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user;

import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.user.UserBasePlugin;
import net.minecraftforge.gradle.user.UserExtension;

public class ForgeUserPlugin
extends UserBasePlugin {
    @Override
    public void applyPlugin() {
        super.applyPlugin();
        ProcessJarTask procTask = (ProcessJarTask)project.getTasks().getByName("deobfBinJar");
        procTask.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}.jar"));
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-mcp.jar"));
        procTask = (ProcessJarTask)project.getTasks().getByName("deobfuscateJar");
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-srg.jar"));
    }

    @Override
    public void afterEvaluate() {
        String depBase = "net.minecraftforge:forge:" + ((UserExtension)this.getExtension()).getApiVersion();
        project.getDependencies().add("userDevPackageDepConfig", (Object)(depBase + ":userdev"));
        project.getDependencies().add("apiJavaDocsConfig", (Object)(depBase + ":javadoc@zip"));
        super.afterEvaluate();
    }

    @Override
    protected void addATs(ProcessJarTask task) {
        task.addTransformer(this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources/fml_at.cfg"));
        task.addTransformer(this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources/forge_at.cfg"));
    }

    @Override
    protected DelayedFile getBinPatchOut() {
        return this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}.jar");
    }

    @Override
    protected DelayedFile getDecompOut() {
        return this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-decomp.jar");
    }
}

