/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.md_5.specialsource.AccessMap;
import net.md_5.specialsource.Jar;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.RemapperPreprocessor;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JarProvider;
import net.md_5.specialsource.provider.JointProvider;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.abstractutil.CachedTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaExecSpec;

public class ProcessJarTask
extends CachedTask {
    @InputFile
    private DelayedFile inJar;
    @InputFile
    private DelayedFile exceptorJar;
    @InputFile
    private DelayedFile srg;
    @InputFile
    private DelayedFile exceptorCfg;
    @OutputFile
    @CachedTask.Cached
    private DelayedFile outCleanJar;
    @OutputFile
    @CachedTask.Cached
    private DelayedFile outDirtyJar = new DelayedFile(this.getProject(), "{BUILD_DIR}/deobfuscated.jar");
    @InputFiles
    private ArrayList<DelayedFile> ats = new ArrayList();
    private boolean isClean = true;

    public void addTransformer(DelayedFile ... obj) {
        for (DelayedFile object : obj) {
            this.ats.add(object);
        }
    }

    public void addTransformer(Object ... obj) {
        for (Object object : obj) {
            if (object instanceof File) {
                this.ats.add(new DelayedFile(this.getProject(), ((File)object).getAbsolutePath()));
            } else if (object instanceof String) {
                this.ats.add(new DelayedFile(this.getProject(), (String)object));
            } else {
                this.ats.add(new DelayedFile(this.getProject(), object.toString()));
            }
            this.isClean = false;
        }
    }

    @TaskAction
    public void doTask() throws IOException {
        File tempObfJar = new File(this.getTemporaryDir(), "obfed.jar");
        HashSet<File> ats = new HashSet<File>();
        for (DelayedFile obj : this.ats) {
            ats.add(this.getProject().file((Object)obj).getCanonicalFile());
        }
        this.getLogger().lifecycle("Applying SpecialSource...");
        this.deobfJar(this.getInJar(), tempObfJar, this.getSrg(), ats);
        File out = this.isClean ? this.getOutCleanJar() : this.getOutDirtyJar();
        this.getLogger().lifecycle("Applying Exceptor...");
        this.applyExceptor(this.getExceptorJar(), tempObfJar, out, this.getExceptorCfg(), new File(this.getTemporaryDir(), "exceptorLog"));
    }

    private void deobfJar(File inJar, File outJar, File srg, Collection<File> ats) throws IOException {
        this.getLogger().debug("INPUT: " + inJar);
        this.getLogger().debug("OUTPUT: " + outJar);
        JarMapping mapping = new JarMapping();
        mapping.loadMappings(srg);
        AccessMap accessMap = new AccessMap();
        this.getLogger().info("Using AccessTransformers...");
        for (File at : ats) {
            this.getLogger().info("" + at);
            accessMap.loadAccessTransformer(at);
        }
        RemapperPreprocessor processor = new RemapperPreprocessor(null, mapping, accessMap);
        JarRemapper remapper = new JarRemapper(processor, mapping);
        Jar input = Jar.init((File)inJar);
        JointProvider inheritanceProviders = new JointProvider();
        inheritanceProviders.add((InheritanceProvider)new JarProvider(input));
        mapping.setFallbackInheritanceProvider((InheritanceProvider)inheritanceProviders);
        remapper.remapJar(input, outJar);
    }

    public void applyExceptor(final File injectorJar, final File inJar, final File outJar, final File config, final File log) {
        this.getLogger().debug("INPUT: " + inJar);
        this.getLogger().debug("OUTPUT: " + outJar);
        this.getLogger().debug("CONFIG: " + config);
        this.getProject().javaexec((Closure)new Closure<JavaExecSpec>((Object)this){
            private static final long serialVersionUID = -1201498060683667405L;

            public JavaExecSpec call() {
                JavaExecSpec exec = (JavaExecSpec)this.getDelegate();
                exec.args(new Object[]{injectorJar.getAbsolutePath(), inJar.getAbsolutePath(), outJar.getAbsolutePath(), config.getAbsolutePath(), log.getAbsolutePath()});
                exec.setMain("-jar");
                exec.setWorkingDir((Object)injectorJar.getParentFile());
                exec.classpath(new Object[]{Constants.getClassPath()});
                exec.setStandardOutput(Constants.getNullStream());
                return exec;
            }
        });
    }

    public File getExceptorCfg() {
        return this.exceptorCfg.call();
    }

    public void setExceptorCfg(DelayedFile exceptorCfg) {
        this.exceptorCfg = exceptorCfg;
    }

    public File getExceptorJar() {
        return this.exceptorJar.call();
    }

    public void setExceptorJar(DelayedFile exceptorJar) {
        this.exceptorJar = exceptorJar;
    }

    public File getInJar() {
        return this.inJar.call();
    }

    public void setInJar(DelayedFile inJar) {
        this.inJar = inJar;
    }

    public File getSrg() {
        return this.srg.call();
    }

    public void setSrg(DelayedFile srg) {
        this.srg = srg;
    }

    public File getOutCleanJar() {
        return this.outCleanJar.call();
    }

    public void setOutCleanJar(DelayedFile outJar) {
        this.outCleanJar = outJar;
    }

    public File getOutDirtyJar() {
        return this.outDirtyJar.call();
    }

    public void setOutDirtyJar(DelayedFile outDirtyJar) {
        this.outDirtyJar = outDirtyJar;
    }

    public boolean isClean() {
        return this.isClean;
    }

    public DelayedFile getDelayedOutput() {
        return this.isClean ? this.outCleanJar : this.outDirtyJar;
    }

    public File getOutJar() {
        return this.isClean ? this.outCleanJar.call() : this.outDirtyJar.call();
    }
}

