/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common;

import java.io.File;
import java.util.HashMap;
import net.minecraftforge.gradle.FileLogListenner;
import net.minecraftforge.gradle.common.BaseExtension;
import net.minecraftforge.gradle.common.JenkinsExtension;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.delayed.DelayedFileTree;
import net.minecraftforge.gradle.delayed.DelayedString;
import net.minecraftforge.gradle.tasks.DownloadAssetsTask;
import net.minecraftforge.gradle.tasks.DownloadTask;
import net.minecraftforge.gradle.tasks.ObtainMcpStuffTask;
import org.gradle.BuildListener;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.api.tasks.Delete;
import org.gradle.testfixtures.ProjectBuilder;

public abstract class BasePlugin<K extends BaseExtension>
implements Plugin<Project> {
    public static Project project;
    private static boolean displayBanner;

    public final void apply(Project arg) {
        project = arg;
        FileLogListenner listenner = new FileLogListenner(project.file((Object)".gradle/gradle.log"));
        project.getLogging().addStandardOutputListener((StandardOutputListener)listenner);
        project.getLogging().addStandardErrorListener((StandardOutputListener)listenner);
        project.getGradle().addBuildListener((BuildListener)listenner);
        project.getExtensions().create("minecraft", this.getExtensionClass(), new Object[]{project});
        project.getExtensions().create("jenkins", JenkinsExtension.class, new Object[]{project});
        this.addMavenRepo("forge", "http://files.minecraftforge.net/maven");
        project.getRepositories().mavenCentral();
        this.addMavenRepo("minecraft", "http://s3.amazonaws.com/Minecraft.Download/libraries");
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                BasePlugin.this.afterEvaluate();
            }
        });
        this.makeObtainTasks();
        this.applyPlugin();
    }

    public abstract void applyPlugin();

    protected abstract String getDevJson();

    public void afterEvaluate() {
        if (!displayBanner) {
            return;
        }
        project.getLogger().lifecycle("****************************");
        project.getLogger().lifecycle(" Powered By MCP:            ");
        project.getLogger().lifecycle(" http://mcp.ocean-labs.de/  ");
        project.getLogger().lifecycle(" Searge, ProfMobius, Fesh0r,");
        project.getLogger().lifecycle(" R4wk, ZeuX, IngisKahn      ");
        project.getLogger().lifecycle(this.delayedString(" MCP Data version : {MCP_VERSION}").call());
        project.getLogger().lifecycle("****************************");
        displayBanner = false;
    }

    private void makeObtainTasks() {
        DownloadTask task = this.makeTask("downloadClient", DownloadTask.class);
        task.setOutput(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft/{MC_VERSION}/minecraft-{MC_VERSION}.jar"));
        task.setUrl(this.delayedString("http://s3.amazonaws.com/Minecraft.Download/versions/{MC_VERSION}/{MC_VERSION}.jar"));
        task = this.makeTask("downloadServer", DownloadTask.class);
        task.setOutput(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_server/{MC_VERSION}/minecraft_server-{MC_VERSION}.jar"));
        task.setUrl(this.delayedString("http://s3.amazonaws.com/Minecraft.Download/versions/{MC_VERSION}/minecraft_server.{MC_VERSION}.jar"));
        ObtainMcpStuffTask mcpTask = this.makeTask("downloadMcpTools", ObtainMcpStuffTask.class);
        mcpTask.setMcpUrl(this.delayedString("http://mcp.ocean-labs.de/files/archive/mcp804.zip"));
        mcpTask.setFfJar(this.delayedFile("{CACHE_DIR}/minecraft/fernflower.jar"));
        mcpTask.setInjectorJar(this.delayedFile("{CACHE_DIR}/minecraft/exceptor.jar"));
        DownloadAssetsTask assets = this.makeTask("getAssets", DownloadAssetsTask.class);
        assets.setAssetsDir(this.delayedFile("{CACHE_DIR}/minecraft/assets"));
        Delete clearCache = this.makeTask("cleanCache", Delete.class);
        clearCache.delete(new Object[]{this.delayedFile("{CACHE_DIR}/minecraft")});
    }

    protected Class<K> getExtensionClass() {
        return BaseExtension.class;
    }

    public final K getExtension() {
        return (K)((BaseExtension)project.getExtensions().getByName("minecraft"));
    }

    public DefaultTask makeTask(String name) {
        return this.makeTask(name, DefaultTask.class);
    }

    public <T extends Task> T makeTask(String name, Class<T> type) {
        return BasePlugin.makeTask(project, name, type);
    }

    public static <T extends Task> T makeTask(Project proj, String name, Class<T> type) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", name);
        map.put("type", type);
        return (T)proj.task(map, name);
    }

    public static Project getProject(File buildFile, Project parent) {
        ProjectBuilder builder = ProjectBuilder.builder();
        builder = buildFile != null ? builder.withProjectDir(buildFile.getParentFile()).withName(buildFile.getParentFile().getName()) : builder.withProjectDir(new File("."));
        if (parent != null) {
            builder = builder.withParent(parent);
        }
        Project project = builder.build();
        if (buildFile != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("from", buildFile.getAbsolutePath());
            project.apply(map);
        }
        return project;
    }

    public void applyExternalPlugin(String plugin) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("plugin", plugin);
        project.apply(map);
    }

    public void addMavenRepo(final String name, final String url) {
        project.getRepositories().maven((Action)new Action<MavenArtifactRepository>(){

            public void execute(MavenArtifactRepository repo) {
                repo.setName(name);
                repo.setUrl((Object)url);
            }
        });
    }

    protected DelayedString delayedString(String path) {
        return new DelayedString(project, path);
    }

    protected DelayedFile delayedFile(String path) {
        return new DelayedFile(project, path);
    }

    protected DelayedFileTree delayedFileTree(String path) {
        return new DelayedFileTree(project, path);
    }

    protected DelayedFileTree delayedZipTree(String path) {
        return new DelayedFileTree(project, path, true);
    }

    static {
        displayBanner = true;
    }
}

