/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.dev;

import groovy.lang.Closure;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import net.minecraftforge.gradle.delayed.DelayedFile;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecSpec;

public class SubmoduleChangelogTask
extends DefaultTask {
    private DelayedFile submodule;
    private String moduleName;
    private String prefix;

    @TaskAction
    public void doTask() {
        this.getLogger().lifecycle("");
        String[] output = this.runGit(this.getProject().getProjectDir(), "--no-pager", "diff", "--no-color", "--", this.getSubmodule().getName());
        if (output.length == 0) {
            this.getLogger().lifecycle("Could not grab submodule changes");
            return;
        }
        String start = null;
        String end = null;
        for (String line : output) {
            if (line.startsWith("-Subproject commit")) {
                start = line.substring(19);
                continue;
            }
            if (!line.startsWith("+Subproject commit")) continue;
            end = line.substring(19);
            if (!line.endsWith("-dirty")) continue;
            end = end.substring(0, end.length() - 5);
        }
        if (start == null && end == null) {
            this.getLogger().lifecycle("Could not extract start and end range");
            return;
        }
        output = this.runGit(this.getSubmodule(), "--no-pager", "log", "--reverse", "--pretty=oneline", start + "..." + end);
        this.getLogger().lifecycle("Updated " + this.getModuleName() + ":");
        for (String line : output) {
            this.getLogger().lifecycle(this.getPrefix() + "@" + line);
        }
        this.getLogger().lifecycle("");
    }

    private String[] runGit(final File dir, final String ... args) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getProject().exec((Closure)new Closure<ExecSpec>((Object)this.getProject(), (Object)this.getProject()){

            public ExecSpec call() {
                ExecSpec exec = (ExecSpec)this.getDelegate();
                exec.setExecutable((Object)"git");
                exec.args((Object[])args);
                exec.setStandardOutput((OutputStream)out);
                exec.setWorkingDir((Object)dir);
                return exec;
            }
        });
        return out.toString().trim().split("\n");
    }

    public File getSubmodule() {
        return this.submodule.call();
    }

    public void setSubmodule(DelayedFile submodule) {
        this.submodule = submodule;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String name) {
        this.moduleName = name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

