/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.util.DeprecationLogger;

public class ZipFileTree
implements MinimalFileTree {
    private final File zipFile;

    public ZipFileTree(File zipFile) {
        this.zipFile = zipFile;
    }

    public String getDisplayName() {
        return String.format("ZIP '%s'", this.zipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(FileVisitor visitor) {
        if (!this.zipFile.exists()) {
            DeprecationLogger.nagUserOfDeprecatedBehaviour((String)String.format("The specified zip file %s does not exist and will be silently ignored", this.getDisplayName()));
            return;
        }
        if (!this.zipFile.isFile()) {
            throw new InvalidUserDataException(String.format("Cannot expand %s as it is not a file.", this.getDisplayName()));
        }
        AtomicBoolean stopFlag = new AtomicBoolean();
        try {
            ZipFile zip = new ZipFile(this.zipFile);
            try {
                TreeMap<String, ZipEntry> entriesByName = new TreeMap<String, ZipEntry>();
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    entriesByName.put(entry.getName(), entry);
                }
                Iterator sortedEntries = entriesByName.values().iterator();
                while (!stopFlag.get() && sortedEntries.hasNext()) {
                    ZipEntry entry = (ZipEntry)sortedEntries.next();
                    if (entry.isDirectory()) {
                        visitor.visitDir((FileVisitDetails)new DetailsImpl(entry, zip, stopFlag));
                        continue;
                    }
                    visitor.visitFile((FileVisitDetails)new DetailsImpl(entry, zip, stopFlag));
                }
            }
            finally {
                zip.close();
            }
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not expand %s.", this.getDisplayName()), (Throwable)e);
        }
    }

    private class DetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails {
        private final ZipEntry entry;
        private final ZipFile zip;
        private final AtomicBoolean stopFlag;
        private File file;

        public DetailsImpl(ZipEntry entry, ZipFile zip, AtomicBoolean stopFlag) {
            this.entry = entry;
            this.zip = zip;
            this.stopFlag = stopFlag;
        }

        public String getDisplayName() {
            return String.format("zip entry %s!%s", ZipFileTree.this.zipFile, this.entry.getName());
        }

        public void stopVisiting() {
            this.stopFlag.set(true);
        }

        public File getFile() {
            if (this.file == null) {
                this.file = new File(this.entry.getName());
            }
            return this.file;
        }

        public long getLastModified() {
            return this.entry.getTime();
        }

        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        public long getSize() {
            return this.entry.getSize();
        }

        public InputStream open() {
            try {
                return this.zip.getInputStream(this.entry);
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }

        public RelativePath getRelativePath() {
            return new RelativePath(!this.entry.isDirectory(), this.entry.getName().split("/"));
        }
    }
}

