/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.dev;

import com.google.common.base.Throwables;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.minecraftforge.gradle.CopyInto;
import net.minecraftforge.gradle.common.BasePlugin;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedBase;
import net.minecraftforge.gradle.dev.DevBasePlugin;
import net.minecraftforge.gradle.dev.DevExtension;
import net.minecraftforge.gradle.dev.FmlDevPlugin;
import net.minecraftforge.gradle.tasks.DecompileTask;
import net.minecraftforge.gradle.tasks.PatchJarTask;
import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.RemapSourcesTask;
import net.minecraftforge.gradle.tasks.abstractutil.DelayedJar;
import net.minecraftforge.gradle.tasks.abstractutil.ExtractTask;
import net.minecraftforge.gradle.tasks.abstractutil.FileFilterTask;
import net.minecraftforge.gradle.tasks.dev.ChangelogTask;
import net.minecraftforge.gradle.tasks.dev.FMLVersionPropTask;
import net.minecraftforge.gradle.tasks.dev.ForgeVersionReplaceTask;
import net.minecraftforge.gradle.tasks.dev.GenBinaryPatches;
import net.minecraftforge.gradle.tasks.dev.GenDevProjectsTask;
import net.minecraftforge.gradle.tasks.dev.GeneratePatches;
import net.minecraftforge.gradle.tasks.dev.ObfuscateTask;
import net.minecraftforge.gradle.tasks.dev.SubmoduleChangelogTask;
import net.minecraftforge.gradle.tasks.dev.SubprojectTask;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.javadoc.Javadoc;

public class ForgeDevPlugin
extends DevBasePlugin {
    @Override
    public void applyPlugin() {
        super.applyPlugin();
        ((DevExtension)this.getExtension()).setFmlDir("fml");
        this.createJarProcessTasks();
        this.createProjectTasks();
        this.createEclipseTasks();
        this.createMiscTasks();
        this.createSourceCopyTasks();
        this.createPackageTasks();
        DefaultTask task = this.makeTask("setupForge", DefaultTask.class);
        task.dependsOn(new Object[]{"extractForgeSources", "generateProjects", "eclipse", "copyAssets"});
        task.setGroup("Forge");
        task = this.makeTask("buildPackages");
        task.dependsOn(new Object[]{"launch4j", "createChangelog", "packageUniversal", "packageInstaller"});
        task.setGroup("Forge");
    }

    protected void createJarProcessTasks() {
        ProcessJarTask task2 = this.makeTask("deobfuscateJar", ProcessJarTask.class);
        task2.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        task2.setExceptorJar(this.delayedFile("{CACHE_DIR}/minecraft/exceptor.jar"));
        task2.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/minecraft_srg_forge-{MC_VERSION}.jar"));
        task2.setSrg(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/packaged-{MC_VERSION}.srg"));
        task2.setExceptorCfg(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/packaged-{MC_VERSION}.exc"));
        task2.addTransformer(this.delayedFile("{FML_DIR}/src/main/resources/fml_at.cfg"));
        task2.addTransformer(this.delayedFile("src/main/resources/forge_at.cfg"));
        task2.dependsOn(new Object[]{"downloadMcpTools", "fixMappings", "mergeJars"});
        DecompileTask task3 = this.makeTask("decompile", DecompileTask.class);
        task3.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/minecraft_srg_forge-{MC_VERSION}.jar"));
        task3.setOutJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_decomp/{MC_VERSION}/minecraft_decomp_forge-{MC_VERSION}.zip"));
        task3.setFernFlower(this.delayedFile("{CACHE_DIR}/minecraft/fernflower.jar"));
        task3.setPatch(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/packaged-{MC_VERSION}.patch"));
        task3.setAstyleConfig(this.delayedFile("{MAPPINGS_DIR}/astyle.cfg"));
        task3.dependsOn(new Object[]{"downloadMcpTools", "deobfuscateJar", "fixMappings"});
        PatchJarTask task4 = this.makeTask("fmlPatchJar", PatchJarTask.class);
        task4.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_decomp/{MC_VERSION}/minecraft_decomp_forge-{MC_VERSION}.zip"));
        task4.setOutJar(this.delayedFile("{BUILD_DIR}/forgeTmp/minecraft_fmlpatched.zip"));
        task4.setInPatches(this.delayedFile("{FML_DIR}/patches/minecraft"));
        task4.setDoesCache(false);
        task4.dependsOn(new Object[]{"decompile"});
        Zip task5 = this.makeTask("fmlInjectJar", Zip.class);
        task5.from(new Object[]{this.delayedFileTree("{FML_DIR}/src/main/java")});
        task5.from(new Object[]{this.delayedFileTree("{FML_DIR}/src/main/resources")});
        task5.from(new Object[]{this.delayedZipTree("{BUILD_DIR}/forgeTmp/minecraft_fmlpatched.zip")});
        task5.from((Object)this.delayedFile("{MAPPINGS_DIR}/patches"), (Closure)new CopyInto("", "Start.java"));
        task5.from(new Object[]{this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/deobfuscation_data-{MC_VERSION}.lzma")});
        task5.from(new Object[]{this.delayedFile("{FML_DIR}/build/tmp/fmlversion.properties")});
        task5.setArchiveName("minecraft_fmlinjected.zip");
        task5.setDestinationDir(this.delayedFile("{BUILD_DIR}/forgeTmp").call());
        task5.dependsOn(new Object[]{"fmlPatchJar", "compressDeobfData", "createVersionPropertiesFML"});
        RemapSourcesTask task6 = this.makeTask("remapSourcesJar", RemapSourcesTask.class);
        task6.setInJar(this.delayedFile("{BUILD_DIR}/forgeTmp/minecraft_fmlinjected.zip"));
        task6.setOutJar(this.delayedFile("{BUILD_DIR}/forgeTmp/minecraft_renamed.zip"));
        task6.setMethodsCsv(this.delayedFile("{MAPPINGS_DIR}/methods.csv"));
        task6.setFieldsCsv(this.delayedFile("{MAPPINGS_DIR}/fields.csv"));
        task6.setParamsCsv(this.delayedFile("{MAPPINGS_DIR}/params.csv"));
        task6.setDoesCache(false);
        task6.dependsOn(new Object[]{"fmlInjectJar"});
        task4 = this.makeTask("forgePatchJar", PatchJarTask.class);
        task4.setInJar(this.delayedFile("{BUILD_DIR}/forgeTmp/minecraft_renamed.zip"));
        task4.setOutJar(this.delayedFile("{BUILD_DIR}/forgeTmp/minecraft_patches.zip"));
        task4.setInPatches(this.delayedFile("patches/minecraft"));
        task4.setDoesCache(false);
        task4.dependsOn(new Object[]{"remapSourcesJar"});
    }

    private void createSourceCopyTasks() {
        ExtractTask task = this.makeTask("extractMcResources", ExtractTask.class);
        task.exclude(JAVA_FILES);
        task.setIncludeEmptyDirs(false);
        task.from(this.delayedFile("{BUILD_DIR}/forgeTmp/minecraft_renamed.zip"));
        task.into(this.delayedFile("eclipse/Clean/src/main/resources"));
        task.dependsOn(new Object[]{"extractWorkspace", "remapSourcesJar"});
        task = this.makeTask("extractMcSource", ExtractTask.class);
        task.include(JAVA_FILES);
        task.setIncludeEmptyDirs(false);
        task.from(this.delayedFile("{BUILD_DIR}/forgeTmp/minecraft_renamed.zip"));
        task.into(this.delayedFile("eclipse/Clean/src/main/java"));
        task.dependsOn(new Object[]{"extractMcResources"});
        task = this.makeTask("extractForgeResources", ExtractTask.class);
        task.exclude(JAVA_FILES);
        task.from(this.delayedFile("{BUILD_DIR}/forgeTmp/minecraft_patches.zip"));
        task.into(this.delayedFile("eclipse/Forge/src/resources"));
        task.dependsOn(new Object[]{"forgePatchJar", "extractWorkspace"});
        task = this.makeTask("extractForgeSources", ExtractTask.class);
        task.include(JAVA_FILES);
        task.from(this.delayedFile("{BUILD_DIR}/forgeTmp/minecraft_patches.zip"));
        task.into(this.delayedFile("eclipse/Forge/src/minecraft"));
        task.dependsOn(new Object[]{"extractForgeResources"});
    }

    private void createProjectTasks() {
        FMLVersionPropTask sub = this.makeTask("createVersionPropertiesFML", FMLVersionPropTask.class);
        sub.setVersion(new Closure<String>((Object)project){

            public String call(Object ... args) {
                return FmlDevPlugin.getVersionFromGit(BasePlugin.project, new File(ForgeDevPlugin.this.delayedString("{FML_DIR}").call()));
            }
        });
        sub.setOutputFile(this.delayedFile("{FML_DIR}/build/tmp/fmlversion.properties"));
        GenDevProjectsTask task = this.makeTask("generateProjectClean", GenDevProjectsTask.class);
        task.setTargetDir(this.delayedFile("eclipse/Clean"));
        task.setJson(this.delayedFile("{FML_DIR}/jsons/{MC_VERSION}-dev.json"));
        task.dependsOn(new Object[]{"extractNatives"});
        task = this.makeTask("generateProjectForge", GenDevProjectsTask.class);
        task.setJson(this.delayedFile("{FML_DIR}/jsons/{MC_VERSION}-dev.json"));
        task.setTargetDir(this.delayedFile("eclipse/Forge"));
        task.addSource(this.delayedFile("eclipse/Forge/src/minecraft"));
        task.addSource(this.delayedFile("src/main/java"));
        task.addResource(this.delayedFile("eclipse/Forge/src/resources"));
        task.addResource(this.delayedFile("src/main/resources"));
        task.dependsOn(new Object[]{"extractNatives", "createVersionPropertiesFML"});
        this.makeTask("generateProjects").dependsOn(new Object[]{"generateProjectClean", "generateProjectForge"});
    }

    private void createEclipseTasks() {
        SubprojectTask task = this.makeTask("eclipseClean", SubprojectTask.class);
        task.setBuildFile(this.delayedFile("eclipse/Clean/build.gradle"));
        task.setTasks("eclipse");
        task.dependsOn(new Object[]{"extractMcSource", "generateProjects"});
        task = this.makeTask("eclipseForge", SubprojectTask.class);
        task.setBuildFile(this.delayedFile("eclipse/Forge/build.gradle"));
        task.setTasks("eclipse");
        task.dependsOn(new Object[]{"extractForgeSources", "generateProjects"});
        this.makeTask("eclipse").dependsOn(new Object[]{"eclipseClean", "eclipseForge"});
    }

    private void createMiscTasks() {
        GeneratePatches task2 = this.makeTask("genPatches", GeneratePatches.class);
        task2.setPatchDir(this.delayedFile("patches/minecraft"));
        task2.setOriginalDir(this.delayedFile("eclipse/Clean/src/main/java"));
        task2.setChangedDir(this.delayedFile("eclipse/Forge/src/minecraft"));
        task2.setOriginalPrefix("../src-base/minecraft");
        task2.setChangedPrefix("../src-work/minecraft");
        task2.setGroup("Forge");
        Delete clean = this.makeTask("cleanForge", Delete.class);
        clean.delete(new Object[]{"eclipse"});
        clean.setGroup("Clean");
        project.getTasksByName("clean", false).toArray(new Task[0])[0].dependsOn(new Object[]{"cleanForge"});
        ObfuscateTask obf = this.makeTask("obfuscateJar", ObfuscateTask.class);
        obf.setSrg(this.delayedFile("{BUILD_DIR}/tmp/mcp2notch.srg"));
        obf.setReverse(false);
        obf.setOutJar(this.delayedFile("{BUILD_DIR}/tmp/recomp_obfed.jar"));
        obf.setBuildFile(this.delayedFile("eclipse/Forge/build.gradle"));
        obf.dependsOn(new Object[]{"generateProjects", "extractForgeSources", "genSrgs"});
        GenBinaryPatches task3 = this.makeTask("genBinPatches", GenBinaryPatches.class);
        task3.setCleanClient(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft/{MC_VERSION}/minecraft-{MC_VERSION}.jar"));
        task3.setCleanServer(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_server/{MC_VERSION}/minecraft_server-{MC_VERSION}.jar"));
        task3.setCleanMerged(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        task3.setDirtyJar(this.delayedFile("{BUILD_DIR}/tmp/recomp_obfed.jar"));
        task3.setDeobfDataLzma(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/deobfuscation_data-{MC_VERSION}.lzma"));
        task3.setOutJar(this.delayedFile("{BUILD_DIR}/tmp/bin_patches.jar"));
        task3.setSrg(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/packaged-{MC_VERSION}.srg"));
        task3.addPatchList(this.delayedFileTree("patches/minecraft"));
        task3.addPatchList(this.delayedFileTree("{FML_DIR}/patches/minecraft"));
        task3.dependsOn(new Object[]{"obfuscateJar", "compressDeobfData", "fixMappings"});
        ForgeVersionReplaceTask task4 = this.makeTask("ciWriteBuildNumber", ForgeVersionReplaceTask.class);
        task4.getOutputs().upToDateWhen(Constants.CALL_FALSE);
        task4.setOutputFile(this.delayedFile("src/main/java/net/minecraftforge/common/ForgeVersion.java"));
        task4.setReplacement(this.delayedString("{BUILD_NUM}"));
        SubmoduleChangelogTask task5 = this.makeTask("fmlChangelog", SubmoduleChangelogTask.class);
        task5.setSubmodule(this.delayedFile("fml"));
        task5.setModuleName("FML");
        task5.setPrefix("MinecraftForge/FML");
    }

    private void createPackageTasks() {
        ChangelogTask log = this.makeTask("createChangelog", ChangelogTask.class);
        log.getOutputs().upToDateWhen(Constants.CALL_FALSE);
        log.setServerRoot(this.delayedString("{JENKINS_SERVER}"));
        log.setJobName(this.delayedString("{JENKINS_JOB}"));
        log.setAuthName(this.delayedString("{JENKINS_AUTH_NAME}"));
        log.setAuthPassword(this.delayedString("{JENKINS_AUTH_PASSWORD}"));
        log.setTargetBuild(this.delayedString("{BUILD_NUM}"));
        log.setOutput(this.delayedFile("{BUILD_DIR}/distributions/{PROJECT}-{MC_VERSION}-{VERSION}-changelog.txt"));
        final DelayedJar uni = this.makeTask("packageUniversal", DelayedJar.class);
        uni.setClassifier("universal");
        uni.getInputs().file((Object)this.delayedFile("{FML_DIR}/jsons/{MC_VERSION}-rel.json"));
        uni.getOutputs().upToDateWhen(Constants.CALL_FALSE);
        uni.from(new Object[]{this.delayedZipTree("{BUILD_DIR}/tmp/bin_patches.jar")});
        uni.from(new Object[]{this.delayedFileTree("{FML_DIR}/src/main/resources")});
        uni.from(new Object[]{this.delayedFileTree("src/main/resources")});
        uni.from(new Object[]{this.delayedFile("{FML_DIR}/build/tmp/fmlversion.properties")});
        uni.from(new Object[]{this.delayedFile("{FML_DIR}/LICENSE-fml.txt")});
        uni.from(new Object[]{this.delayedFile("{FML_DIR}/CREDITS-fml.txt")});
        uni.from(new Object[]{this.delayedFile("MinecraftForge-License.txt")});
        uni.from(new Object[]{this.delayedFile("MinecraftForge-Credits.txt")});
        uni.from(new Object[]{this.delayedFile("Paulscode IBXM Library License.txt")});
        uni.from(new Object[]{this.delayedFile("Paulscode SoundSystem CodecIBXM License.txt")});
        uni.from(new Object[]{this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/deobfuscation_data-{MC_VERSION}.lzma")});
        uni.from(new Object[]{this.delayedFile("{BUILD_DIR}/distributions/{PROJECT}-{MC_VERSION}-{VERSION}-changelog.txt")});
        uni.exclude(new String[]{"devbinpatches.pack.lzma"});
        uni.setIncludeEmptyDirs(false);
        uni.setManifest((Closure)new Closure<Object>((Object)project){

            public Object call() {
                Manifest mani = (Manifest)this.getDelegate();
                mani.getAttributes().put((Object)"Main-Class", (Object)ForgeDevPlugin.this.delayedString("{MAIN_CLASS}").call());
                mani.getAttributes().put((Object)"Class-Path", (Object)ForgeDevPlugin.this.getServerClassPath(ForgeDevPlugin.this.delayedFile("{FML_DIR}/jsons/{MC_VERSION}-rel.json").call()));
                return null;
            }
        });
        uni.doLast((Action)new Action<Task>(){

            public void execute(Task arg0) {
                try {
                    ForgeDevPlugin.this.signJar(((DelayedJar)arg0).getArchivePath(), "forge", "*/*/**", "!paulscode/**");
                }
                catch (Exception e) {
                    Throwables.propagate((Throwable)e);
                }
            }
        });
        uni.setDestinationDir(this.delayedFile("{BUILD_DIR}/distributions").call());
        uni.dependsOn(new Object[]{"genBinPatches", "createChangelog", "createVersionPropertiesFML"});
        project.getArtifacts().add("archives", (Object)uni);
        FileFilterTask task = this.makeTask("generateInstallJson", FileFilterTask.class);
        task.setInputFile(this.delayedFile("{FML_DIR}/jsons/{MC_VERSION}-rel.json"));
        task.setOutputFile(this.delayedFile("{BUILD_DIR}/tmp/install_profile.json"));
        task.addReplacement("@minecraft_version@", (Object)this.delayedString("{MC_VERSION}"));
        task.addReplacement("@version@", (Object)this.delayedString("{VERSION}"));
        task.addReplacement("@project@", (Object)this.delayedString("Forge"));
        task.addReplacement("@artifact@", (Object)this.delayedString("net.minecraftforge:forge:{MC_VERSION}-{VERSION}"));
        task.addReplacement("@universal_jar@", new Closure<String>((Object)project){

            public String call() {
                return uni.getArchiveName();
            }
        });
        task.addReplacement("@timestamp@", new Closure<String>((Object)project){

            public String call() {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(new Date());
            }
        });
        Zip inst = this.makeTask("packageInstaller", Zip.class);
        inst.setClassifier("installer");
        inst.from(new Object[]{new Closure<File>((Object)project){

            public File call() {
                return uni.getArchivePath();
            }
        }});
        inst.from(new Object[]{this.delayedFile("{BUILD_DIR}/tmp/install_profile.json")});
        inst.from(new Object[]{this.delayedFile("{BUILD_DIR}/distributions/{PROJECT}-{MC_VERSION}-{VERSION}-changelog.txt")});
        inst.from(new Object[]{this.delayedFile("{FML_DIR}/LICENSE-fml.txt")});
        inst.from(new Object[]{this.delayedFile("{FML_DIR}/CREDITS-fml.txt")});
        inst.from(new Object[]{this.delayedFile("MinecraftForge-License.txt")});
        inst.from(new Object[]{this.delayedFile("MinecraftForge-Credits.txt")});
        inst.from(new Object[]{this.delayedFile("Paulscode IBXM Library License.txt")});
        inst.from(new Object[]{this.delayedFile("Paulscode SoundSystem CodecIBXM License.txt")});
        inst.from(new Object[]{this.delayedFile("src/main/resources/forge_logo.png")});
        inst.from((Object)this.delayedZipTree("{BUILD_DIR}/tmp/installer_base.{INSTALLER_VERSION}.jar"), (Closure)new CopyInto("", "!*.json", "!*.png"));
        inst.dependsOn(new Object[]{"packageUniversal", "downloadBaseInstaller", "generateInstallJson"});
        inst.rename("forge_logo\\.png", "big_logo.png");
        inst.setExtension("jar");
        project.getArtifacts().add("archives", (Object)inst);
        final Zip patchZipFML = this.makeTask("zipFmlPatches", Zip.class);
        patchZipFML.from(new Object[]{this.delayedFile("{FML_DIR}/patches/minecraft")});
        patchZipFML.setArchiveName("fmlpatches.zip");
        patchZipFML.setDestinationDir(this.delayedFile("{BUILD_DIR}/tmp/").call());
        final Zip patchZipForge = this.makeTask("zipForgePatches", Zip.class);
        patchZipForge.from(new Object[]{this.delayedFile("patches/minecraft")});
        patchZipForge.setArchiveName("forgepatches.zip");
        patchZipForge.setDestinationDir(this.delayedFile("{BUILD_DIR}/tmp/").call());
        final Zip classZip = this.makeTask("jarClasses", Zip.class);
        classZip.from((Object)this.delayedZipTree("{BUILD_DIR}/tmp/bin_patches.jar"), (Closure)new CopyInto("", "**/*.class"));
        classZip.setArchiveName("binaries.jar");
        classZip.setDestinationDir(this.delayedFile("{BUILD_DIR}/tmp/").call());
        final File javadoc_temp = project.file((Object)"build/tmp/javadoc");
        SubprojectTask javadocJar = this.makeTask("genJavadocs", SubprojectTask.class);
        javadocJar.setBuildFile(this.delayedFile("eclipse/Forge/build.gradle"));
        javadocJar.setTasks("javadoc");
        javadocJar.setConfigureTask(new Closure<Object>((Object)this, null){

            public Object call(Object obj) {
                Javadoc task = (Javadoc)obj;
                task.setDestinationDir(javadoc_temp);
                return null;
            }
        });
        Zip javadoc = this.makeTask("packageJavadoc", Zip.class);
        javadoc.from(new Object[]{javadoc_temp});
        javadoc.setClassifier("javadoc");
        javadoc.dependsOn(new Object[]{"genJavadocs"});
        project.getArtifacts().add("archives", (Object)javadoc);
        Zip userDev = this.makeTask("packageUserDev", Zip.class);
        userDev.setClassifier("userdev");
        userDev.from(new Object[]{this.delayedFile("{FML_DIR}/jsons/{MC_VERSION}-dev.json")});
        userDev.from(new Object[]{new Closure<File>((Object)project){

            public File call() {
                return patchZipFML.getArchivePath();
            }
        }});
        userDev.from(new Object[]{new Closure<File>((Object)project){

            public File call() {
                return patchZipForge.getArchivePath();
            }
        }});
        userDev.from(new Object[]{new Closure<File>((Object)project){

            public File call() {
                return classZip.getArchivePath();
            }
        }});
        userDev.from(new Object[]{this.delayedFile("{BUILD_DIR}/distributions/{PROJECT}-{MC_VERSION}-{VERSION}-changelog.txt")});
        userDev.from((Object)this.delayedZipTree("{BUILD_DIR}/tmp/bin_patches.jar"), (Closure)new CopyInto("", "devbinpatches.pack.lzma"));
        userDev.from((Object)this.delayedFileTree("{FML_DIR}/src"), (Closure)new CopyInto("src"));
        userDev.from((Object)this.delayedFileTree("src"), (Closure)new CopyInto("src"));
        userDev.from((Object)this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/deobfuscation_data-{MC_VERSION}.lzma"), (Closure)new CopyInto("src/main/resources/"));
        userDev.from((Object)this.delayedFileTree("{FML_DIR}/mcp_merge.cfg"), (Closure)new CopyInto("conf"));
        userDev.from((Object)this.delayedFileTree("{MAPPINGS_DIR}"), (Closure)new CopyInto("conf", "astyle.cfg"));
        userDev.from((Object)this.delayedFileTree("{MAPPINGS_DIR}"), (Closure)new CopyInto("mappings", "*.csv", "!packages.csv"));
        userDev.from((Object)this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/packaged-{MC_VERSION}.srg"), (Closure)new CopyInto("conf"));
        userDev.from((Object)this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/packaged-{MC_VERSION}.exc"), (Closure)new CopyInto("conf"));
        userDev.from((Object)this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/packaged-{MC_VERSION}.patch"), (Closure)new CopyInto("conf"));
        userDev.from((Object)this.delayedFile("{FML_DIR}/build/tmp/fmlversion.properties"), (Closure)new CopyInto("src/main/resources"));
        userDev.rename(".+?\\.json", "dev.json");
        userDev.rename(".+?\\.srg", "packaged.srg");
        userDev.rename(".+?\\.exc", "packaged.exc");
        userDev.rename(".+?\\.patch", "packaged.patch");
        userDev.setIncludeEmptyDirs(false);
        userDev.dependsOn(new Object[]{"packageUniversal", "zipFmlPatches", "zipForgePatches", "jarClasses", "createVersionPropertiesFML"});
        userDev.setExtension("jar");
        project.getArtifacts().add("archives", (Object)userDev);
        Zip src = this.makeTask("packageSrc", Zip.class);
        src.setClassifier("src");
        src.from(new Object[]{this.delayedFile("{BUILD_DIR}/distributions/{PROJECT}-{MC_VERSION}-{VERSION}-changelog.txt")});
        src.from(new Object[]{this.delayedFile("{FML_DIR}/LICENSE-fml.txt")});
        src.from(new Object[]{this.delayedFile("{FML_DIR}/CREDITS-fml.txt")});
        src.from(new Object[]{this.delayedFile("MinecraftForge-License.txt")});
        src.from(new Object[]{this.delayedFile("MinecraftForge-Credits.txt")});
        src.from((Object)this.delayedFile("{FML_DIR}/install"), (Closure)new CopyInto(null, "!*.gradle"));
        src.from((Object)this.delayedFile("{FML_DIR}/install"), (Closure)new CopyInto(null, "*.gradle").addExpand("version", this.delayedString("{MC_VERSION}-{VERSION}")).addExpand("name", "forge"));
        src.from(new Object[]{this.delayedFile("{FML_DIR}/gradlew")});
        src.from(new Object[]{this.delayedFile("{FML_DIR}/gradlew.bat")});
        src.from((Object)this.delayedFile("{FML_DIR}/gradle/wrapper"), (Closure)new CopyInto("gradle/wrapper"));
        src.rename(".+?\\.gradle", "build.gradle");
        src.dependsOn(new Object[]{"createChangelog"});
        src.setExtension("zip");
        project.getArtifacts().add("archives", (Object)src);
    }

    public static String getVersionFromJava(Project project, String file) throws IOException {
        String major = "0";
        String minor = "0";
        String revision = "0";
        String build = "0";
        String prefix = "public static final int";
        List lines = FileUtils.readLines((File)project.file((Object)file));
        for (String s : lines) {
            if (!(s = s.trim()).startsWith(prefix)) continue;
            s = s.substring(prefix.length(), s.length() - 1);
            String[] pts = (s = s.replace('=', ' ').replace("Version", "").replaceAll(" +", " ").trim()).split(" ");
            if (pts[0].equals("major")) {
                major = pts[pts.length - 1];
                continue;
            }
            if (pts[0].equals("minor")) {
                minor = pts[pts.length - 1];
                continue;
            }
            if (!pts[0].equals("revision")) continue;
            revision = pts[pts.length - 1];
        }
        if (System.getenv().containsKey("BUILD_NUMBER")) {
            build = System.getenv("BUILD_NUMBER");
        }
        String branch = null;
        if (!System.getenv().containsKey("GIT_BRANCH")) {
            branch = ForgeDevPlugin.runGit(project, project.getProjectDir(), "rev-parse", "--abbrev-ref", "HEAD");
        } else {
            branch = System.getenv("GIT_BRANCH");
            branch = branch.substring(branch.lastIndexOf(47) + 1);
        }
        if (branch != null && (branch.equals("master") || branch.equals("HEAD"))) {
            branch = null;
        }
        DelayedBase.IDelayedResolver resolver = (DelayedBase.IDelayedResolver)project.getPlugins().findPlugin("forgedev");
        StringBuilder out = new StringBuilder();
        out.append(DelayedBase.resolve("{MC_VERSION}", project, resolver)).append('-');
        out.append(major).append('.').append(minor).append('.').append(revision).append('.').append(build);
        if (branch != null) {
            out.append('-').append(branch);
        }
        return out.toString();
    }
}

