/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.dev;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import groovy.lang.Closure;
import groovy.util.MapEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.delayed.DelayedString;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class ChangelogTask
extends DefaultTask {
    @Input
    DelayedString serverRoot;
    @Input
    DelayedString jobName;
    @Input
    DelayedString authName;
    @Input
    DelayedString authPassword;
    @Input
    Closure<String> targetBuild;
    private int targetBuildResolved = -1;
    @OutputFile
    DelayedFile output;
    private String auth = null;
    private static final Gson GSON_FORMATTER = new GsonBuilder().setPrettyPrinting().create();

    @TaskAction
    public void doTask() throws IOException {
        if (this.getAuthName() != null && this.getAuthPassword() != null) {
            String raw = this.getAuthName() + ":" + this.getAuthPassword();
            this.auth = "Basic " + DatatypeConverter.printBase64Binary((byte[])raw.getBytes());
        }
        List<Map<String, Object>> builds = this.getBuildInfo();
        this.getLatestBuild(builds);
        StringBuilder out = new StringBuilder();
        out.append("Changelog:\r\n");
        for (Map<String, Object> build : builds) {
            int number = ((Double)build.get("number")).intValue();
            List items = (List)build.get("items");
            if (this.getTargetBuild() > 0 && number > this.getTargetBuild()) continue;
            out.append("Build ");
            out.append(build.get("version") == null ? Integer.valueOf(number) : build.get("version"));
            out.append(':').append('\n');
            for (MapEntry entry : items) {
                String[] lines = ((String)entry.getValue()).trim().split("\n");
                if (lines.length == 1) {
                    out.append('\t').append(entry.getKey()).append(": ").append(lines[0]).append('\n');
                    continue;
                }
                out.append('\t').append(entry.getKey()).append(':').append('\n');
                for (String line : lines) {
                    out.append('\t').append('\t').append(line).append('\n');
                }
            }
            out.append('\n');
        }
        Files.write((byte[])out.toString().getBytes(), (File)this.getOutput());
        this.getProject().getArtifacts().add("archives", (Object)this.getOutput());
    }

    private String read(String url) throws MalformedURLException, IOException {
        return this.read(new URL(this.getServerRoot() + "job/" + this.getJobName() + url));
    }

    private String read(URL url) throws IOException {
        URLConnection con = null;
        con = url.openConnection();
        if (this.auth != null) {
            this.getProject().getLogger().debug(this.auth);
            con.addRequestProperty("Authorization", this.auth);
        }
        return new String(ByteStreams.toByteArray((InputStream)con.getInputStream()));
    }

    private String cleanJson(String data, String part) {
        data = data.replace("," + part + ",", ",");
        data = data.replace(part + ",", "");
        data = data.replace("," + part, "");
        data = data.replace("{" + part + "}", "{}");
        data = data.replace("[" + part + "]", "[]");
        return data;
    }

    private void prettyPrint(Object json) {
        this.getLogger().lifecycle(GSON_FORMATTER.toJson(json));
    }

    private List<Map<String, Object>> getBuildInfo() {
        try {
            boolean versioned = false;
            String data = this.read("/api/python?tree=allBuilds[result,number,actions[text],changeSet[items[author[fullName],comment]]]");
            data = this.cleanJson(data, "None");
            data = this.cleanJson(data, "{}");
            List json = (List)((Map)new Gson().fromJson(data, Map.class)).get("allBuilds");
            Collections.sort(json, new Comparator<Map<String, Object>>(){

                @Override
                public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                    return (int)((Double)o1.get("number") - (Double)o2.get("number"));
                }
            });
            ArrayList<MapEntry> items = new ArrayList<MapEntry>();
            Iterator bitr = json.iterator();
            while (bitr.hasNext()) {
                Map build = (Map)bitr.next();
                List actions = (List)build.get("actions");
                Iterator itr = actions.iterator();
                while (itr.hasNext()) {
                    Map map = (Map)itr.next();
                    if (map.containsKey("text") && !((String)map.get("text")).contains("http:")) continue;
                    itr.remove();
                }
                if (actions.size() == 0) {
                    build.put("version", versioned ? Integer.valueOf(((Double)build.get("number")).intValue()) : this.getProject().getVersion());
                    versioned = true;
                } else {
                    build.put("version", ((Map)actions.get(0)).get("text"));
                }
                for (Map e : (List)((Map)build.get("changeSet")).get("items")) {
                    items.add(new MapEntry(((Map)e.get("author")).get("fullName"), e.get("comment")));
                }
                build.put("items", items);
                if (build.get("result").equals("SUCCESS")) {
                    if (items.size() == 0) {
                        bitr.remove();
                    }
                    items = new ArrayList();
                } else {
                    bitr.remove();
                }
                build.remove("result");
                build.remove("changeSet");
                build.remove("actions");
            }
            Collections.sort(json, new Comparator<Map<String, Object>>(){

                @Override
                public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                    return (int)((Double)o2.get("number") - (Double)o1.get("number"));
                }
            });
            return json;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<Map<String, Object>>();
        }
    }

    private void getLatestBuild(List<Map<String, Object>> builds) {
        try {
            boolean versioned = false;
            String data = this.read("/lastBuild/api/python?pretty=true&tree=number,changeSet[items[author[fullName],comment]]");
            data = this.cleanJson(data, "None");
            data = this.cleanJson(data, "{}");
            Map build = (Map)new Gson().fromJson(data, Map.class);
            if (build.get("number").equals(builds.get(0).get("number"))) {
                return;
            }
            build.put("version", versioned ? "Build " + ((Double)build.get("number")).intValue() : this.getProject().getVersion());
            ArrayList<MapEntry> items = new ArrayList<MapEntry>();
            for (Map e : (List)((Map)build.get("changeSet")).get("items")) {
                items.add(new MapEntry(((Map)e.get("author")).get("fullName"), e.get("comment")));
            }
            build.put("items", items);
            build.remove("result");
            build.remove("changeSet");
            build.remove("actions");
            builds.add(0, build);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getServerRoot() {
        return this.serverRoot.call();
    }

    public void setServerRoot(DelayedString serverRoot) {
        this.serverRoot = serverRoot;
    }

    public String getJobName() {
        return this.jobName.call();
    }

    public void setJobName(DelayedString jobName) {
        this.jobName = jobName;
    }

    public String getAuthName() {
        return this.authName.call();
    }

    public void setAuthName(DelayedString authName) {
        this.authName = authName;
    }

    public String getAuthPassword() {
        return this.authPassword.call();
    }

    public void setAuthPassword(DelayedString authPassword) {
        this.authPassword = authPassword;
    }

    public int getTargetBuild() {
        if (this.targetBuildResolved != -1) {
            return this.targetBuildResolved;
        }
        this.targetBuildResolved = Integer.MAX_VALUE;
        if (this.targetBuild != null) {
            try {
                this.targetBuildResolved = Integer.parseInt((String)this.targetBuild.call());
                if (this.targetBuildResolved <= 0) {
                    this.targetBuildResolved = Integer.MAX_VALUE;
                }
            }
            catch (NumberFormatException e) {
                this.getProject().getLogger().debug("Error reading target build: " + e.getMessage());
            }
        }
        return this.targetBuildResolved;
    }

    public void setTargetBuild(Closure<String> targetBuild) {
        this.targetBuild = targetBuild;
    }

    public File getOutput() {
        return this.output.call();
    }

    public void setOutput(DelayedFile output) {
        this.output = output;
    }
}

