/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user;

import java.io.File;
import net.minecraftforge.gradle.common.BasePlugin;
import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.user.ApplyBinPatchesTask;
import net.minecraftforge.gradle.user.UserBasePlugin;
import net.minecraftforge.gradle.user.UserExtension;
import org.gradle.api.Action;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.Library;
import org.gradle.plugins.ide.eclipse.model.internal.FileReferenceFactory;

public class ForgeUserPlugin
extends UserBasePlugin {
    @Override
    public void applyPlugin() {
        super.applyPlugin();
        ApplyBinPatchesTask binTask = this.makeTask("applyBinPatches", ApplyBinPatchesTask.class);
        binTask.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        binTask.setOutJar(this.delayedFile("{CACHE_DIR}/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}.jar"));
        binTask.setPatches(this.delayedFile("{BUILD_DIR}/unpacked/devbinpatches.pack.lzma"));
        binTask.setClassesJar(this.delayedFile("{BUILD_DIR}/unpacked/binaries.jar"));
        binTask.setResources(this.delayedFileTree("{BUILD_DIR}/unpacked/src/main/resources"));
        binTask.dependsOn(new Object[]{"mergeJars"});
        ProcessJarTask procTask = (ProcessJarTask)project.getTasks().getByName("deobfuscateJar");
        procTask.dependsOn(new Object[]{binTask});
        procTask.setInJar(this.delayedFile("{CACHE_DIR}/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}.jar"));
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-mcp.jar"));
    }

    @Override
    public void afterEvaluate() {
        String depBase = "net.minecraftforge:forge:" + ((UserExtension)this.getExtension()).getApiVersion();
        project.getDependencies().add("userDevPackageDepConfig", (Object)(depBase + ":userdev"));
        project.getDependencies().add("apiJavaDocsConfig", (Object)(depBase + ":javadoc@zip"));
        super.afterEvaluate();
        final File deobf = this.delayedFile("{CACHE_DIR}/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-mcp.jar").call();
        project.getDependencies().add("minecraft", (Object)project.files(new Object[]{deobf}));
        EclipseModel eclipseConv = (EclipseModel)project.getExtensions().getByName("eclipse");
        eclipseConv.getClasspath().getFile().getWhenMerged().add((Action)new Action<Classpath>(){
            FileReferenceFactory factory = new FileReferenceFactory();

            public void execute(Classpath classpath) {
                for (ClasspathEntry e : classpath.getEntries()) {
                    Library lib;
                    if (!(e instanceof Library) || !(lib = (Library)e).getLibrary().getFile().equals(deobf)) continue;
                    lib.setJavadocPath(this.factory.fromFile(BasePlugin.project.getConfigurations().getByName("apiJavaDocsConfig").getSingleFile()));
                }
            }
        });
        this.fixEclipseProject("eclipse/.metadata/.plugins/org.eclipse.core.resources/.projects/Minecraft/.location");
    }

    @Override
    protected void addATs(ProcessJarTask task) {
        task.addTransformer(this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources/fml_at.cfg"));
        task.addTransformer(this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources/forge_at.cfg"));
    }
}

