/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user;

import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.user.ApplyBinPatchesTask;
import net.minecraftforge.gradle.user.UserBasePlugin;
import net.minecraftforge.gradle.user.UserExtension;

public class FmlUserPlugin
extends UserBasePlugin {
    @Override
    public void applyPlugin() {
        super.applyPlugin();
        ApplyBinPatchesTask binTask = this.makeTask("applyBinPatches", ApplyBinPatchesTask.class);
        binTask.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        binTask.setOutJar(this.delayedFile("{CACHE_DIR}/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}.jar"));
        binTask.setPatches(this.delayedFile("{BUILD_DIR}/unpacked/devbinpatches.pack.lzma"));
        binTask.setClassesJar(this.delayedFile("{BUILD_DIR}/unpacked/binaries.jar"));
        binTask.dependsOn(new Object[]{"mergeJars"});
        ProcessJarTask procTask = (ProcessJarTask)project.getTasks().getByName("deobfuscateJar");
        procTask.dependsOn(new Object[]{binTask});
        procTask.setInJar(this.delayedFile("{CACHE_DIR}/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}.jar"));
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}-mcp.jar"));
    }

    @Override
    public void afterEvaluate() {
        project.getDependencies().add("userDevPackageDepConfig", (Object)("cpw.mods:fml:" + ((UserExtension)this.getExtension()).getApiVersion() + ":userdev"));
        super.afterEvaluate();
        project.getDependencies().add("minecraft", (Object)project.files(new Object[]{this.delayedFile("{CACHE_DIR}/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}-mcp.jar").call()}));
        this.fixEclipseProject("eclipse/.metadata/.plugins/org.eclipse.core.resources/.projects/Minecraft/.location");
    }

    @Override
    protected void addATs(ProcessJarTask task) {
        task.addTransformer(this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources/fml_at.cfg"));
    }
}

