/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.user;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.nothome.delta.GDiffPatcher;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import lzma.sdk.lzma.Decoder;
import lzma.streams.LzmaInputStream;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.abstractutil.CachedTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class ApplyBinPatchesTask
extends CachedTask {
    @InputFile
    DelayedFile inJar;
    @InputFile
    DelayedFile classesJar;
    @OutputFile
    @CachedTask.Cached
    DelayedFile outJar;
    @InputFile
    DelayedFile patches;
    private HashMap<String, ClassPatch> patchlist = Maps.newHashMap();
    private GDiffPatcher patcher = new GDiffPatcher();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void doTask() throws IOException {
        this.setup();
        if (this.getOutJar().exists()) {
            this.getOutJar().delete();
        }
        ZipFile in = new ZipFile(this.getInJar());
        ZipInputStream classesIn = new ZipInputStream(new FileInputStream(this.getClassesJar()));
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.getOutJar())));
        HashSet<String> entries = new HashSet<String>();
        try {
            this.log("Patching Class:", new Object[0]);
            for (ZipEntry zipEntry : Collections.list(in.entries())) {
                if (zipEntry.isDirectory()) {
                    out.putNextEntry(zipEntry);
                } else {
                    ZipEntry n = new ZipEntry(zipEntry.getName());
                    n.setTime(zipEntry.getTime());
                    out.putNextEntry(n);
                    byte[] data = ByteStreams.toByteArray((InputStream)in.getInputStream(zipEntry));
                    ClassPatch patch = this.patchlist.get(zipEntry.getName().replace('\\', '/'));
                    if (patch != null) {
                        this.log("\t%s (%s) (input size %d)", patch.targetClassName, patch.sourceClassName, data.length);
                        int inputChecksum = this.adlerHash(data);
                        if (patch.inputChecksum != inputChecksum) {
                            throw new RuntimeException(String.format("There is a binary discrepency between the expected input class %s (%s) and the actual class. Checksum on disk is %x, in patch %x. Things are probably about to go very wrong. Did you put something into the jar file?", patch.targetClassName, patch.sourceClassName, inputChecksum, patch.inputChecksum));
                        }
                        GDiffPatcher gDiffPatcher = this.patcher;
                        synchronized (gDiffPatcher) {
                            data = this.patcher.patch(data, patch.patch);
                        }
                    }
                    out.write(data);
                }
                entries.add(zipEntry.getName());
            }
            ZipEntry entry = null;
            while ((entry = classesIn.getNextEntry()) != null) {
                if (entries.contains(entry.getName())) continue;
                out.putNextEntry(entry);
                out.write(ByteStreams.toByteArray((InputStream)classesIn));
                entries.add(entry.getName());
            }
        }
        finally {
            classesIn.close();
            in.close();
            out.close();
        }
    }

    private int adlerHash(byte[] input) {
        Adler32 hasher = new Adler32();
        hasher.update(input);
        return (int)hasher.getValue();
    }

    public void setup() {
        JarInputStream jis;
        Pattern matcher = Pattern.compile(String.format("binpatch/merged/.*.binpatch", new Object[0]));
        try {
            LzmaInputStream binpatchesDecompressed = new LzmaInputStream((InputStream)new FileInputStream(this.getPatches()), new Decoder());
            ByteArrayOutputStream jarBytes = new ByteArrayOutputStream();
            JarOutputStream jos = new JarOutputStream(jarBytes);
            Pack200.newUnpacker().unpack((InputStream)binpatchesDecompressed, jos);
            jis = new JarInputStream(new ByteArrayInputStream(jarBytes.toByteArray()));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.log("Reading Patches:", new Object[0]);
        while (true) {
            try {
                JarEntry entry;
                while ((entry = jis.getNextJarEntry()) != null) {
                    if (matcher.matcher(entry.getName()).matches()) {
                        ClassPatch cp = this.readPatch(entry, jis);
                        this.patchlist.put(cp.sourceClassName + ".class", cp);
                        continue;
                    }
                    jis.closeEntry();
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        this.log("Read %d binary patches", this.patchlist.size());
        this.log("Patch list :\n\t%s", Joiner.on((String)"\n\t").join(this.patchlist.entrySet()));
    }

    private ClassPatch readPatch(JarEntry patchEntry, JarInputStream jis) throws IOException {
        this.log("\t%s", patchEntry.getName());
        ByteArrayDataInput input = ByteStreams.newDataInput((byte[])ByteStreams.toByteArray((InputStream)jis));
        String name = input.readUTF();
        String sourceClassName = input.readUTF();
        String targetClassName = input.readUTF();
        boolean exists = input.readBoolean();
        int inputChecksum = 0;
        if (exists) {
            inputChecksum = input.readInt();
        }
        int patchLength = input.readInt();
        byte[] patchBytes = new byte[patchLength];
        input.readFully(patchBytes);
        return new ClassPatch(name, sourceClassName, targetClassName, exists, inputChecksum, patchBytes);
    }

    private void log(String format, Object ... args) {
        this.getLogger().debug(String.format(format, args));
    }

    public File getInJar() {
        return this.inJar.call();
    }

    public void setInJar(DelayedFile inJar) {
        this.inJar = inJar;
    }

    public File getOutJar() {
        return this.outJar.call();
    }

    public void setOutJar(DelayedFile outJar) {
        this.outJar = outJar;
    }

    public File getPatches() {
        return this.patches.call();
    }

    public void setPatches(DelayedFile patchesJar) {
        this.patches = patchesJar;
    }

    public File getClassesJar() {
        return this.classesJar.call();
    }

    public void setClassesJar(DelayedFile extraJar) {
        this.classesJar = extraJar;
    }

    public static class ClassPatch {
        public final String name;
        public final String sourceClassName;
        public final String targetClassName;
        public final boolean existsAtTarget;
        public final byte[] patch;
        public final int inputChecksum;

        public ClassPatch(String name, String sourceClassName, String targetClassName, boolean existsAtTarget, int inputChecksum, byte[] patch) {
            this.name = name;
            this.sourceClassName = sourceClassName;
            this.targetClassName = targetClassName;
            this.existsAtTarget = existsAtTarget;
            this.inputChecksum = inputChecksum;
            this.patch = patch;
        }

        public String toString() {
            return String.format("%s : %s => %s (%b) size %d", this.name, this.sourceClassName, this.targetClassName, this.existsAtTarget, this.patch.length);
        }
    }
}

