/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.dev;

import com.cloudbees.diff.Diff;
import com.cloudbees.diff.PatchException;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import net.minecraftforge.gradle.delayed.DelayedFile;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.TaskAction;

public class GeneratePatches
extends DefaultTask {
    @InputDirectory
    DelayedFile patchDir;
    @InputDirectory
    DelayedFile changedDir;
    @InputDirectory
    DelayedFile originalDir;
    @Input
    String originalPrefix = "";
    @Input
    String changedPrefix = "";

    @TaskAction
    public void doTask() throws IOException, PatchException {
        this.getPatchDir().mkdirs();
        this.processDir(this.getOriginalDir());
    }

    public void processDir(File dir) throws IOException {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.processDir(file);
                continue;
            }
            if (!file.getPath().endsWith(".java")) continue;
            this.processFile(file);
        }
    }

    public void processFile(File file) throws IOException {
        this.getLogger().debug("Original File: " + file);
        String relative = file.getAbsolutePath().substring(this.getOriginalDir().getAbsolutePath().length()).replace('\\', '/');
        File patchFile = new File(this.getPatchDir(), relative + ".patch");
        File changedFile = new File(this.getChangedDir(), relative);
        this.getLogger().debug("Changed File: " + changedFile);
        if (!changedFile.exists()) {
            this.getLogger().debug("Changed File does not exist");
            return;
        }
        Diff diff = Diff.diff((File)file, (File)changedFile, (boolean)false);
        if (!diff.isEmpty()) {
            String unidiff = diff.toUnifiedDiff(this.originalPrefix + relative, this.changedPrefix + relative, (Reader)Files.newReader((File)file, (Charset)Charset.defaultCharset()), (Reader)Files.newReader((File)changedFile, (Charset)Charset.defaultCharset()), 3);
            unidiff = unidiff.replace("\r\n", "\n");
            unidiff = unidiff.replace("\n\\ No newline at end of file\n", "\n");
            String olddiff = "";
            if (patchFile.exists()) {
                olddiff = Files.toString((File)patchFile, (Charset)Charset.defaultCharset());
            }
            if (!olddiff.equals(unidiff)) {
                this.getLogger().debug("Writing patch: " + patchFile);
                patchFile.getParentFile().mkdirs();
                Files.touch((File)patchFile);
                Files.write((CharSequence)unidiff, (File)patchFile, (Charset)Charset.defaultCharset());
            } else {
                this.getLogger().debug("Patch did not change");
            }
        }
    }

    public File getChangedDir() {
        return this.changedDir.call();
    }

    public void setChangedDir(DelayedFile changedDir) {
        this.changedDir = changedDir;
    }

    public File getOriginalDir() {
        return this.originalDir.call();
    }

    public void setOriginalDir(DelayedFile originalDir) {
        this.originalDir = originalDir;
    }

    public File getPatchDir() {
        return this.patchDir.call();
    }

    public void setPatchDir(DelayedFile patchDir) {
        this.patchDir = patchDir;
    }

    public String getOriginalPrefix() {
        return this.originalPrefix;
    }

    public void setOriginalPrefix(String originalPrefix) {
        this.originalPrefix = originalPrefix;
    }

    public String getChangedPrefix() {
        return this.changedPrefix;
    }

    public void setChangedPrefix(String changedPrefix) {
        this.changedPrefix = changedPrefix;
    }
}

