/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import groovy.util.Node;
import groovy.util.NodeList;
import groovy.util.XmlParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedFile;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.xml.sax.SAXException;

public class DownloadAssetsTask
extends DefaultTask {
    DelayedFile assetsDir;
    private final ConcurrentLinkedQueue<Asset> filesLeft = new ConcurrentLinkedQueue();
    private final ArrayList<AssetsThread> threads = new ArrayList();
    private static final int MAX_THREADS = Runtime.getRuntime().availableProcessors();

    @TaskAction
    public void doTask() throws ParserConfigurationException, SAXException, IOException, InterruptedException {
        File out = this.getAssetsDir();
        out.mkdirs();
        Node root = new XmlParser().parse((InputStream)new BufferedInputStream(new URL("http://s3.amazonaws.com/Minecraft.Resources").openStream()));
        this.getLogger().info("Parsing assets XML");
        for (Object childNode : (NodeList)root.get("Contents")) {
            Node child = (Node)childNode;
            if (((NodeList)child.get("Size")).text().equals("0")) continue;
            String key = ((NodeList)child.get("Key")).text();
            String hash = ((NodeList)child.get("ETag")).text().replace('\"', ' ').trim();
            this.filesLeft.offer(new Asset(key, hash));
        }
        this.getLogger().info("Finished parsing XML");
        this.getLogger().info("Files found: " + this.filesLeft.size());
        int threadNum = this.filesLeft.size() / 100;
        for (int i = 0; i < threadNum; ++i) {
            this.spawnThread();
        }
        this.getLogger().info("Threads initially spawned: " + threadNum);
        while (this.stillRunning()) {
            this.spawnThread();
            Thread.sleep(1000L);
        }
    }

    private void spawnThread() {
        if (this.threads.size() < MAX_THREADS) {
            this.getLogger().debug("Spawning thread #" + (this.threads.size() + 1));
            AssetsThread thread = new AssetsThread();
            thread.start();
            this.threads.add(thread);
        }
    }

    private boolean stillRunning() {
        for (Thread thread : this.threads) {
            if (!thread.isAlive()) continue;
            return true;
        }
        this.getLogger().info("All " + this.threads.size() + " threads Complete");
        return false;
    }

    public File getAssetsDir() {
        return this.assetsDir.call();
    }

    public void setAssetsDir(DelayedFile assetsDir) {
        this.assetsDir = assetsDir;
    }

    private class AssetsThread
    extends Thread {
        public AssetsThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            Asset asset;
            while ((asset = (Asset)DownloadAssetsTask.this.filesLeft.poll()) != null) {
                try {
                    boolean download = false;
                    File file = new File(DownloadAssetsTask.this.getAssetsDir(), asset.path);
                    if (!file.exists()) {
                        download = true;
                        file.getParentFile().mkdirs();
                        file.createNewFile();
                    } else if (!Constants.hash(file).toLowerCase().equals(asset.hash)) {
                        download = true;
                        file.delete();
                        file.createNewFile();
                    }
                    if (!download) continue;
                    URL url = new URL("http://s3.amazonaws.com/Minecraft.Resources/" + asset.path);
                    BufferedInputStream stream = new BufferedInputStream(url.openStream());
                    Files.write((byte[])ByteStreams.toByteArray((InputStream)stream), (File)file);
                    stream.close();
                }
                catch (Exception e) {
                    DownloadAssetsTask.this.getLogger().error("Error downloading asset: " + asset.path);
                    e.printStackTrace();
                }
            }
        }
    }

    private class Asset {
        public final String path;
        public final String hash;

        Asset(String path, String hash) {
            this.path = path;
            this.hash = hash.toLowerCase();
        }
    }
}

