/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patching;

import com.cloudbees.diff.Hunk;
import com.cloudbees.diff.PatchException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.gradle.patching.Base64;
import org.apache.commons.io.IOUtils;

public final class ContextualPatch {
    public static final String MAGIC = "# This patch file was generated by NetBeans IDE";
    private final Pattern unifiedRangePattern = Pattern.compile("@@ -(\\d+)(,\\d+)? \\+(\\d+)(,\\d+)? @@(\\s.*)?");
    private final Pattern baseRangePattern = Pattern.compile("\\*\\*\\* (\\d+)(,\\d+)? \\*\\*\\*\\*");
    private final Pattern modifiedRangePattern = Pattern.compile("--- (\\d+)(,\\d+)? ----");
    private final Pattern normalChangeRangePattern = Pattern.compile("(\\d+),(\\d+)c(\\d+),(\\d+)");
    private final Pattern normalAddRangePattern = Pattern.compile("(\\d+)a(\\d+),(\\d+)");
    private final Pattern normalDeleteRangePattern = Pattern.compile("(\\d+),(\\d+)d(\\d+)");
    private final Pattern binaryHeaderPattern = Pattern.compile("MIME: (.*?); encoding: (.*?); length: (-?\\d+?)");
    private final File patchFile;
    private final File suggestedContext;
    private String patchString;
    private IContextProvider contextProvider;
    private int maxFuzz = 0;
    private boolean c14nWhitespace = false;
    private boolean c14nAccess = false;
    private File context;
    private BufferedReader patchReader;
    private String patchLine;
    private boolean patchLineRead;
    private int lastPatchedLine;

    public static ContextualPatch create(File patchFile, File context) {
        return new ContextualPatch(patchFile, context);
    }

    public static ContextualPatch create(String patchString, IContextProvider context) {
        return new ContextualPatch(patchString, context);
    }

    private ContextualPatch(String patchString, IContextProvider context) {
        this.patchString = patchString;
        this.contextProvider = context;
        this.patchFile = null;
        this.suggestedContext = null;
    }

    private ContextualPatch(File patchFile, File context) {
        this.patchFile = patchFile;
        this.suggestedContext = context;
    }

    public ContextualPatch setMaxFuzz(int maxFuzz) {
        this.maxFuzz = maxFuzz;
        return this;
    }

    public ContextualPatch setWhitespaceC14N(boolean canonicalize) {
        this.c14nWhitespace = canonicalize;
        return this;
    }

    public ContextualPatch setAccessC14N(boolean canonicalize) {
        this.c14nAccess = canonicalize;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PatchReport> patch(boolean dryRun) throws PatchException, IOException {
        ArrayList<PatchReport> report = new ArrayList<PatchReport>();
        this.init();
        try {
            SinglePatch patch;
            this.patchLine = this.patchReader.readLine();
            ArrayList<SinglePatch> patches = new ArrayList<SinglePatch>();
            while ((patch = this.getNextPatch()) != null) {
                patches.add(patch);
            }
            this.computeContext(patches);
            for (SinglePatch patch2 : patches) {
                try {
                    report.add(this.applyPatch(patch2, dryRun));
                }
                catch (Exception e) {
                    report.add(new PatchReport(patch2.targetPath, patch2.binary, PatchStatus.Failure, e, new ArrayList<HunkReport>()));
                }
            }
            ArrayList<PatchReport> arrayList = report;
            return arrayList;
        }
        finally {
            if (this.patchReader != null) {
                try {
                    this.patchReader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void init() throws IOException {
        if (this.patchString != null) {
            this.patchReader = new BufferedReader(new StringReader(this.patchString));
            return;
        }
        this.patchReader = new BufferedReader(new FileReader(this.patchFile));
        String encoding = "ISO-8859-1";
        String line = this.patchReader.readLine();
        if (MAGIC.equals(line)) {
            encoding = "utf8";
            line = this.patchReader.readLine();
        }
        this.patchReader.close();
        byte[] buffer = new byte[MAGIC.length()];
        FileInputStream in = new FileInputStream(this.patchFile);
        int read = ((InputStream)in).read(buffer);
        ((InputStream)in).close();
        if (read != -1 && MAGIC.equals(new String(buffer, "utf8"))) {
            encoding = "utf8";
        }
        this.patchReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.patchFile), encoding));
    }

    private PatchReport applyPatch(SinglePatch patch, boolean dryRun) throws IOException, PatchException {
        int x;
        List<String> target;
        this.lastPatchedLine = 1;
        ArrayList<HunkReport> ret = new ArrayList<HunkReport>();
        if (this.contextProvider != null) {
            target = this.contextProvider.getData(patch.targetPath);
            if (target != null && !patch.binary) {
                if (this.patchCreatesNewFileThatAlreadyExists(patch, target)) {
                    for (int x2 = 0; x2 < patch.hunks.length; ++x2) {
                        ret.add(new HunkReport(PatchStatus.Skipped, null, 0, 0, x2));
                    }
                    return new PatchReport(patch.targetPath, patch.binary, PatchStatus.Skipped, null, ret);
                }
            } else if (target == null) {
                target = new ArrayList<String>();
            }
            if (patch.mode == Mode.DELETE) {
                target = new ArrayList<String>();
            } else if (!patch.binary) {
                x = 0;
                for (Hunk hunk : patch.hunks) {
                    ++x;
                    try {
                        ret.add(this.applyHunk(target, hunk, x));
                    }
                    catch (Exception e) {
                        ret.add(new HunkReport(PatchStatus.Failure, e, 0, 0, x));
                    }
                }
            }
            if (!dryRun) {
                this.contextProvider.setData(patch.targetPath, target);
            }
        } else {
            patch.targetFile = this.computeTargetFile(patch);
            if (patch.targetFile.exists() && !patch.binary) {
                target = this.readFile(patch.targetFile);
                if (this.patchCreatesNewFileThatAlreadyExists(patch, target)) {
                    for (int x3 = 0; x3 < patch.hunks.length; ++x3) {
                        ret.add(new HunkReport(PatchStatus.Skipped, null, 0, 0, x3));
                    }
                    return new PatchReport(patch.targetPath, patch.binary, PatchStatus.Skipped, null, ret);
                }
            } else {
                target = new ArrayList<String>();
            }
            if (patch.mode == Mode.DELETE) {
                target = new ArrayList<String>();
            } else if (!patch.binary) {
                x = 0;
                for (Hunk hunk : patch.hunks) {
                    ++x;
                    try {
                        ret.add(this.applyHunk(target, hunk, x));
                    }
                    catch (Exception e) {
                        ret.add(new HunkReport(PatchStatus.Failure, e, 0, 0, x));
                    }
                }
            }
            if (!dryRun) {
                this.backup(patch.targetFile);
                this.writeFile(patch, target);
            }
        }
        for (HunkReport hunk : ret) {
            if (hunk.getStatus() != PatchStatus.Failure) continue;
            return new PatchReport(patch.targetPath, patch.binary, PatchStatus.Failure, hunk.getFailure(), ret);
        }
        return new PatchReport(patch.targetPath, patch.binary, PatchStatus.Patched, null, ret);
    }

    private boolean patchCreatesNewFileThatAlreadyExists(SinglePatch patch, List<String> originalFile) throws PatchException {
        if (patch.hunks.length != 1) {
            return false;
        }
        Hunk hunk = patch.hunks[0];
        if (hunk.baseStart != 0 || hunk.baseCount != 0 || hunk.modifiedStart != 1 || hunk.modifiedCount != originalFile.size()) {
            return false;
        }
        ArrayList<String> target = new ArrayList<String>(hunk.modifiedCount);
        this.applyHunk(target, hunk, 0);
        return target.equals(originalFile);
    }

    private void backup(File target) throws IOException {
        if (target.exists()) {
            this.copyStreamsCloseAll(new FileOutputStream(this.computeBackup(target)), new FileInputStream(target));
        }
    }

    private File computeBackup(File target) {
        return new File(target.getParentFile(), target.getName() + ".original~");
    }

    private void copyStreamsCloseAll(OutputStream writer, InputStream reader) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while ((n = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, n);
        }
        writer.close();
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(SinglePatch patch, List<String> lines) throws IOException {
        if (patch.mode == Mode.DELETE) {
            patch.targetFile.delete();
            return;
        }
        patch.targetFile.getParentFile().mkdirs();
        if (patch.binary) {
            if (patch.hunks.length == 0) {
                patch.targetFile.delete();
            } else {
                byte[] content = Base64.decode(patch.hunks[0].lines);
                this.copyStreamsCloseAll(new FileOutputStream(patch.targetFile), new ByteArrayInputStream(content));
            }
        } else {
            try (PrintWriter w = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(patch.targetFile), this.getEncoding(patch.targetFile)));){
                if (lines.size() == 0) {
                    return;
                }
                for (String line : lines.subList(0, lines.size() - 1)) {
                    w.println(line);
                }
                w.print(lines.get(lines.size() - 1));
                if (!patch.noEndingNewline) {
                    w.println();
                }
            }
        }
    }

    private HunkReport applyHunk(List<String> target, Hunk hunk, int hunkID) throws PatchException {
        int fuzz;
        int idx = -1;
        for (fuzz = 0; idx == -1 && fuzz <= this.maxFuzz && (idx = this.findHunkIndex(target, hunk, fuzz, hunkID)) == -1; ++fuzz) {
        }
        if (idx == -1) {
            throw new PatchException("Cannot find hunk target");
        }
        return this.applyHunk(target, hunk, idx, false, fuzz, hunkID);
    }

    private int findHunkIndex(List<String> target, Hunk hunk, int fuzz, int hunkID) throws PatchException {
        int i;
        int idx = hunk.modifiedStart;
        if (idx >= this.lastPatchedLine && this.applyHunk(target, hunk, idx, true, fuzz, hunkID).getStatus().isSuccess()) {
            return idx;
        }
        for (i = idx - 1; i >= this.lastPatchedLine; --i) {
            if (!this.applyHunk(target, hunk, i, true, fuzz, hunkID).getStatus().isSuccess()) continue;
            return i;
        }
        for (i = idx + 1; i < target.size(); ++i) {
            if (!this.applyHunk(target, hunk, i, true, fuzz, hunkID).getStatus().isSuccess()) continue;
            return i;
        }
        return -1;
    }

    private HunkReport applyHunk(List<String> target, Hunk hunk, int idx, boolean dryRun, int fuzz, int hunkID) throws PatchException {
        int startIdx = idx--;
        int hunkIdx = -1;
        for (String hunkLine : hunk.lines) {
            ++hunkIdx;
            boolean isAddition = this.isAdditionLine(hunkLine);
            if (!isAddition) {
                if (idx >= target.size()) {
                    if (dryRun) {
                        return new HunkReport(PatchStatus.Failure, null, idx, fuzz, hunkID);
                    }
                    throw new PatchException("Unapplicable hunk #" + hunkID + " @@ " + startIdx);
                }
                boolean match = this.similar(target.get(idx), hunkLine.substring(1), hunkLine.charAt(0));
                if (!match && fuzz != 0 && !this.isRemovalLine(hunkLine)) {
                    boolean bl = match = hunkIdx < fuzz || hunkIdx >= hunk.lines.size() - fuzz ? true : match;
                }
                if (!match) {
                    if (dryRun) {
                        return new HunkReport(PatchStatus.Failure, null, idx, fuzz, hunkID);
                    }
                    throw new PatchException("Unapplicable hunk #" + hunkID + " @@ " + startIdx);
                }
            }
            if (dryRun) {
                if (isAddition) {
                    --idx;
                }
            } else if (isAddition) {
                target.add(idx, hunkLine.substring(1));
            } else if (this.isRemovalLine(hunkLine)) {
                target.remove(idx);
                --idx;
            }
            ++idx;
        }
        this.lastPatchedLine = ++idx;
        return new HunkReport(fuzz != 0 ? PatchStatus.Fuzzed : PatchStatus.Patched, null, startIdx, fuzz, hunkID);
    }

    private boolean isAdditionLine(String hunkLine) {
        return hunkLine.charAt(0) == '+';
    }

    private boolean isRemovalLine(String hunkLine) {
        return hunkLine.charAt(0) == '-';
    }

    private Charset getEncoding(File file) {
        return Charset.defaultCharset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readFile(File target) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(target), this.getEncoding(target)));
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = r.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        finally {
            IOUtils.closeQuietly((Reader)r);
        }
    }

    private SinglePatch getNextPatch() throws IOException, PatchException {
        SinglePatch patch;
        block6: {
            patch = new SinglePatch();
            while (true) {
                String line;
                if ((line = this.readPatchLine()) == null) {
                    return null;
                }
                if (line.startsWith("Index:")) {
                    patch.targetPath = line.substring(6).trim();
                    continue;
                }
                if (line.startsWith("MIME: application/octet-stream;")) {
                    this.unreadPatchLine();
                    this.readBinaryPatchContent(patch);
                    break block6;
                }
                if (line.startsWith("--- ")) {
                    this.unreadPatchLine();
                    this.readPatchContent(patch);
                    break block6;
                }
                if (line.startsWith("*** ")) {
                    this.unreadPatchLine();
                    this.readContextPatchContent(patch);
                    break block6;
                }
                if (this.isNormalDiffRange(line)) break;
            }
            this.unreadPatchLine();
            this.readNormalPatchContent(patch);
        }
        return patch;
    }

    private boolean isNormalDiffRange(String line) {
        return this.normalAddRangePattern.matcher(line).matches() || this.normalChangeRangePattern.matcher(line).matches() || this.normalDeleteRangePattern.matcher(line).matches();
    }

    private void readBinaryPatchContent(SinglePatch patch) throws PatchException, IOException {
        ArrayList<Hunk> hunks = new ArrayList<Hunk>();
        Hunk hunk = new Hunk();
        while (true) {
            String line;
            if ((line = this.readPatchLine()) == null || line.startsWith("Index:") || line.length() == 0) {
                this.unreadPatchLine();
                break;
            }
            if (patch.binary) {
                hunk.lines.add(line);
                continue;
            }
            Matcher m = this.binaryHeaderPattern.matcher(line);
            if (!m.matches()) continue;
            patch.binary = true;
            int length = Integer.parseInt(m.group(3));
            if (length == -1) break;
            hunks.add(hunk);
        }
        patch.hunks = hunks.toArray(new Hunk[hunks.size()]);
    }

    private void readNormalPatchContent(SinglePatch patch) throws IOException, PatchException {
        ArrayList<Hunk> hunks;
        block6: {
            String line;
            hunks = new ArrayList<Hunk>();
            Hunk hunk = null;
            while (true) {
                if ((line = this.readPatchLine()) == null || line.startsWith("Index:")) break block6;
                Matcher m = this.normalAddRangePattern.matcher(line);
                if (m.matches()) {
                    hunk = new Hunk();
                    hunks.add(hunk);
                    this.parseNormalRange(hunk, m);
                    continue;
                }
                m = this.normalChangeRangePattern.matcher(line);
                if (m.matches()) {
                    hunk = new Hunk();
                    hunks.add(hunk);
                    this.parseNormalRange(hunk, m);
                    continue;
                }
                m = this.normalDeleteRangePattern.matcher(line);
                if (m.matches()) {
                    hunk = new Hunk();
                    hunks.add(hunk);
                    this.parseNormalRange(hunk, m);
                    continue;
                }
                if (line.startsWith("> ")) {
                    hunk.lines.add("+" + line.substring(2));
                    continue;
                }
                if (line.startsWith("< ")) {
                    hunk.lines.add("-" + line.substring(2));
                    continue;
                }
                if (!line.startsWith("---")) break;
            }
            throw new PatchException("Invalid hunk line: " + line);
        }
        this.unreadPatchLine();
        patch.hunks = hunks.toArray(new Hunk[hunks.size()]);
    }

    private void parseNormalRange(Hunk hunk, Matcher m) {
        if (m.pattern() == this.normalAddRangePattern) {
            hunk.baseStart = Integer.parseInt(m.group(1));
            hunk.baseCount = 0;
            hunk.modifiedStart = Integer.parseInt(m.group(2));
            hunk.modifiedCount = Integer.parseInt(m.group(3)) - hunk.modifiedStart + 1;
        } else if (m.pattern() == this.normalDeleteRangePattern) {
            hunk.baseStart = Integer.parseInt(m.group(1));
            hunk.baseCount = Integer.parseInt(m.group(2)) - hunk.baseStart + 1;
            hunk.modifiedStart = Integer.parseInt(m.group(3));
            hunk.modifiedCount = 0;
        } else {
            hunk.baseStart = Integer.parseInt(m.group(1));
            hunk.baseCount = Integer.parseInt(m.group(2)) - hunk.baseStart + 1;
            hunk.modifiedStart = Integer.parseInt(m.group(3));
            hunk.modifiedCount = Integer.parseInt(m.group(4)) - hunk.modifiedStart + 1;
        }
    }

    private void readContextPatchContent(SinglePatch patch) throws IOException, PatchException {
        ArrayList<Hunk> hunks;
        block6: {
            String line;
            String base = this.readPatchLine();
            if (base == null || !base.startsWith("*** ")) {
                throw new PatchException("Invalid context diff header: " + base);
            }
            String modified = this.readPatchLine();
            if (modified == null || !modified.startsWith("--- ")) {
                throw new PatchException("Invalid context diff header: " + modified);
            }
            if (patch.targetPath == null) {
                this.computeTargetPath(base, modified, patch);
            }
            hunks = new ArrayList<Hunk>();
            Hunk hunk = null;
            int lineCount = -1;
            while (true) {
                if ((line = this.readPatchLine()) == null || line.length() == 0 || line.startsWith("Index:")) break block6;
                if (line.startsWith("***************")) {
                    hunk = new Hunk();
                    this.parseContextRange(hunk, this.readPatchLine());
                    hunks.add(hunk);
                    continue;
                }
                if (line.startsWith("--- ")) {
                    lineCount = 0;
                    this.parseContextRange(hunk, line);
                    hunk.lines.add(line);
                    continue;
                }
                char c = line.charAt(0);
                if (c != ' ' && c != '+' && c != '-' && c != '!') break;
                if (lineCount >= hunk.modifiedCount) continue;
                hunk.lines.add(line);
                if (lineCount == -1) continue;
                ++lineCount;
            }
            throw new PatchException("Invalid hunk line: " + line);
        }
        this.unreadPatchLine();
        patch.hunks = hunks.toArray(new Hunk[hunks.size()]);
        this.convertContextToUnified(patch);
    }

    private void convertContextToUnified(SinglePatch patch) throws PatchException {
        Hunk[] unifiedHunks = new Hunk[patch.hunks.length];
        int idx = 0;
        for (Hunk hunk : patch.hunks) {
            unifiedHunks[idx++] = this.convertContextToUnified(hunk);
        }
        patch.hunks = unifiedHunks;
    }

    private Hunk convertContextToUnified(Hunk hunk) throws PatchException {
        Hunk unifiedHunk = new Hunk();
        unifiedHunk.baseStart = hunk.baseStart;
        unifiedHunk.modifiedStart = hunk.modifiedStart;
        int split = -1;
        for (int i = 0; i < hunk.lines.size(); ++i) {
            if (!((String)hunk.lines.get(i)).startsWith("--- ")) continue;
            split = i;
            break;
        }
        if (split == -1) {
            throw new PatchException("Missing split divider in context patch");
        }
        int baseIdx = 0;
        int modifiedIdx = split + 1;
        ArrayList<String> unifiedLines = new ArrayList<String>(hunk.lines.size());
        while (baseIdx < split || modifiedIdx < hunk.lines.size()) {
            String modifiedLine;
            String baseLine = baseIdx < split ? (String)hunk.lines.get(baseIdx) : "~";
            String string = modifiedLine = modifiedIdx < hunk.lines.size() ? (String)hunk.lines.get(modifiedIdx) : "~";
            if (baseLine.startsWith("- ")) {
                unifiedLines.add("-" + baseLine.substring(2));
                ++unifiedHunk.baseCount;
                ++baseIdx;
                continue;
            }
            if (modifiedLine.startsWith("+ ")) {
                unifiedLines.add("+" + modifiedLine.substring(2));
                ++unifiedHunk.modifiedCount;
                ++modifiedIdx;
                continue;
            }
            if (baseLine.startsWith("! ")) {
                unifiedLines.add("-" + baseLine.substring(2));
                ++unifiedHunk.baseCount;
                ++baseIdx;
                continue;
            }
            if (modifiedLine.startsWith("! ")) {
                unifiedLines.add("+" + modifiedLine.substring(2));
                ++unifiedHunk.modifiedCount;
                ++modifiedIdx;
                continue;
            }
            if (baseLine.startsWith("  ") && modifiedLine.startsWith("  ")) {
                unifiedLines.add(baseLine.substring(1));
                ++unifiedHunk.baseCount;
                ++unifiedHunk.modifiedCount;
                ++baseIdx;
                ++modifiedIdx;
                continue;
            }
            if (baseLine.startsWith("  ")) {
                unifiedLines.add(baseLine.substring(1));
                ++unifiedHunk.baseCount;
                ++unifiedHunk.modifiedCount;
                ++baseIdx;
                continue;
            }
            if (modifiedLine.startsWith("  ")) {
                unifiedLines.add(modifiedLine.substring(1));
                ++unifiedHunk.baseCount;
                ++unifiedHunk.modifiedCount;
                ++modifiedIdx;
                continue;
            }
            throw new PatchException("Invalid context patch: " + baseLine);
        }
        unifiedHunk.lines = unifiedLines;
        return unifiedHunk;
    }

    private void readPatchContent(SinglePatch patch) throws IOException, PatchException {
        ArrayList<Hunk> hunks;
        block7: {
            String base = this.readPatchLine();
            if (base == null || !base.startsWith("--- ")) {
                throw new PatchException("Invalid unified diff header: " + base);
            }
            String modified = this.readPatchLine();
            if (modified == null || !modified.startsWith("+++ ")) {
                throw new PatchException("Invalid unified diff header: " + modified);
            }
            if (patch.targetPath == null) {
                this.computeTargetPath(base, modified, patch);
            }
            hunks = new ArrayList<Hunk>();
            Hunk hunk = null;
            while (true) {
                String line;
                if ((line = this.readPatchLine()) == null || line.length() == 0 || line.startsWith("Index:")) {
                    this.unreadPatchLine();
                    break block7;
                }
                char c = line.charAt(0);
                if (c == '@') {
                    hunk = new Hunk();
                    this.parseRange(hunk, line);
                    hunks.add(hunk);
                    continue;
                }
                if (c == ' ' || c == '+' || c == '-') {
                    hunk.lines.add(line);
                    continue;
                }
                if (!line.equals("\\ No newline at end of file")) break;
                patch.noEndingNewline = true;
            }
            this.unreadPatchLine();
        }
        patch.hunks = hunks.toArray(new Hunk[hunks.size()]);
    }

    private void computeTargetPath(String base, String modified, SinglePatch patch) {
        base = base.substring("+++ ".length());
        modified = modified.substring("--- ".length());
        if ((base.equals("/dev/null") || base.startsWith("a/")) && (modified.equals("/dev/null") || modified.startsWith("b/"))) {
            if (base.startsWith("a/")) {
                base = base.substring(2);
            }
            if (modified.startsWith("b/")) {
                modified = modified.substring(2);
            }
        }
        if ((base = this.untilTab(base).trim()).equals("/dev/null")) {
            patch.targetPath = this.untilTab(modified).trim();
            patch.mode = Mode.ADD;
        } else {
            patch.targetPath = base;
            patch.mode = modified.equals("/dev/null") ? Mode.DELETE : Mode.CHANGE;
        }
    }

    private String untilTab(String base) {
        int pathEndIdx = base.indexOf(9);
        if (pathEndIdx > 0) {
            base = base.substring(0, pathEndIdx);
        }
        return base;
    }

    private void parseRange(Hunk hunk, String range) throws PatchException {
        Matcher m = this.unifiedRangePattern.matcher(range);
        if (!m.matches()) {
            throw new PatchException("Invalid unified diff range: " + range);
        }
        hunk.baseStart = Integer.parseInt(m.group(1));
        hunk.baseCount = m.group(2) != null ? Integer.parseInt(m.group(2).substring(1)) : 1;
        hunk.modifiedStart = Integer.parseInt(m.group(3));
        hunk.modifiedCount = m.group(4) != null ? Integer.parseInt(m.group(4).substring(1)) : 1;
    }

    private void parseContextRange(Hunk hunk, String range) throws PatchException {
        if (range.charAt(0) == '*') {
            Matcher m = this.baseRangePattern.matcher(range);
            if (!m.matches()) {
                throw new PatchException("Invalid context diff range: " + range);
            }
            hunk.baseStart = Integer.parseInt(m.group(1));
            hunk.baseCount = m.group(2) != null ? Integer.parseInt(m.group(2).substring(1)) : 1;
            hunk.baseCount -= hunk.baseStart - 1;
        } else {
            Matcher m = this.modifiedRangePattern.matcher(range);
            if (!m.matches()) {
                throw new PatchException("Invalid context diff range: " + range);
            }
            hunk.modifiedStart = Integer.parseInt(m.group(1));
            hunk.modifiedCount = m.group(2) != null ? Integer.parseInt(m.group(2).substring(1)) : 1;
            hunk.modifiedCount -= hunk.modifiedStart - 1;
        }
    }

    private String readPatchLine() throws IOException {
        if (this.patchLineRead) {
            this.patchLine = this.patchReader.readLine();
        } else {
            this.patchLineRead = true;
        }
        return this.patchLine;
    }

    private void unreadPatchLine() {
        this.patchLineRead = false;
    }

    private void computeContext(List<SinglePatch> patches) {
        File bestContext = this.suggestedContext;
        int bestContextMatched = 0;
        this.context = this.suggestedContext;
        while (this.context != null) {
            int patchedFiles = 0;
            for (SinglePatch patch : patches) {
                try {
                    this.applyPatch(patch, true);
                    ++patchedFiles;
                }
                catch (Exception e) {}
            }
            if (patchedFiles > bestContextMatched) {
                bestContextMatched = patchedFiles;
                bestContext = this.context;
                if (patchedFiles == patches.size()) break;
            }
            this.context = this.context.getParentFile();
        }
        this.context = bestContext;
    }

    private File computeTargetFile(SinglePatch patch) {
        if (patch.targetPath == null) {
            patch.targetPath = this.context.getAbsolutePath();
        }
        if (this.context.isFile()) {
            return this.context;
        }
        return new File(this.context, patch.targetPath);
    }

    private boolean similar(String target, String hunk, char lineType) {
        if (this.c14nAccess) {
            String[] h;
            String[] t;
            if (this.c14nWhitespace) {
                target = target.replaceAll("[\t| ]+", " ");
                hunk = hunk.replaceAll("[\t| ]+", " ");
            }
            if ((t = target.split(" ")).length != (h = hunk.split(" ")).length) {
                return false;
            }
            for (int x = 0; x < t.length; ++x) {
                if (this.isAccess(t[x]) && this.isAccess(h[x]) || t[x].equals(h[x])) continue;
                return false;
            }
            return true;
        }
        if (this.c14nWhitespace) {
            return target.replaceAll("[\t| ]+", " ").equals(hunk.replaceAll("[\t| ]+", " "));
        }
        return target.equals(hunk);
    }

    private boolean isAccess(String data) {
        return data.equalsIgnoreCase("public") || data.equalsIgnoreCase("private") || data.equalsIgnoreCase("protected");
    }

    public static class HunkReport {
        private PatchStatus status;
        private Throwable failure;
        private int index;
        private int fuzz;
        private int hunkID;

        public HunkReport(PatchStatus status, Throwable failure, int index, int fuzz, int hunkID) {
            this.status = status;
            this.failure = failure;
            this.index = index;
            this.fuzz = fuzz;
            this.hunkID = hunkID;
        }

        public PatchStatus getStatus() {
            return this.status;
        }

        public Throwable getFailure() {
            return this.failure;
        }

        public int getIndex() {
            return this.index;
        }

        public int getFuzz() {
            return this.fuzz;
        }

        public int getHunkID() {
            return this.hunkID;
        }
    }

    public static interface IContextProvider {
        public List<String> getData(String var1);

        public void setData(String var1, List<String> var2);
    }

    public static final class PatchReport {
        private String target;
        private boolean binary;
        private PatchStatus status;
        private Throwable failure;
        private List<HunkReport> hunks;

        PatchReport(String target, boolean binary, PatchStatus status, Throwable failure, List<HunkReport> hunks) {
            this.target = target;
            this.binary = binary;
            this.status = status;
            this.failure = failure;
            this.hunks = hunks;
        }

        public String getTarget() {
            return this.target;
        }

        public boolean isBinary() {
            return this.binary;
        }

        public PatchStatus getStatus() {
            return this.status;
        }

        public Throwable getFailure() {
            return this.failure;
        }

        public List<HunkReport> getHunks() {
            return this.hunks;
        }
    }

    public static enum PatchStatus {
        Patched(true),
        Missing(false),
        Failure(false),
        Skipped(true),
        Fuzzed(true);

        private boolean success;

        private PatchStatus(boolean success) {
            this.success = success;
        }

        public boolean isSuccess() {
            return this.success;
        }
    }

    static enum Mode {
        CHANGE,
        ADD,
        DELETE;

    }

    private static class SinglePatch {
        String targetPath;
        Hunk[] hunks;
        File targetFile;
        boolean noEndingNewline;
        boolean binary;
        Mode mode;

        private SinglePatch() {
        }
    }
}

