/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user;

import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import groovy.lang.Closure;
import groovy.util.Node;
import groovy.util.XmlParser;
import groovy.xml.XmlUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.gradle.common.BasePlugin;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedBase;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.delayed.DelayedFileTree;
import net.minecraftforge.gradle.delayed.DelayedString;
import net.minecraftforge.gradle.tasks.MergeJarsTask;
import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.abstractutil.ExtractTask;
import net.minecraftforge.gradle.tasks.user.GenSrgTask;
import net.minecraftforge.gradle.tasks.user.reobf.ArtifactSpec;
import net.minecraftforge.gradle.tasks.user.reobf.ReobfTask;
import net.minecraftforge.gradle.user.UserExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.model.IdeaModel;

public abstract class UserBasePlugin
extends BasePlugin<UserExtension>
implements DelayedBase.IDelayedResolver<UserExtension> {
    private boolean hasApplied = false;
    private static final byte[] LOCATION_BEFORE = new byte[]{64, -79, -117, -127, 35, -68, 0, 20, 26, 37, -106, -25, -93, -109, -66, 30};
    private static final byte[] LOCATION_AFTER = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -64, 88, -5, -13, 35, -68, 0, 20, 26, 81, -13, -116, 123, -69, 119, -58};

    @Override
    public void applyPlugin() {
        this.applyExternalPlugin("java");
        this.applyExternalPlugin("maven");
        this.applyExternalPlugin("eclipse");
        this.applyExternalPlugin("idea");
        this.configureDeps();
        this.configureCompilation();
        this.configureEclipse();
        this.configureIntellij();
        this.tasks();
        DefaultTask task = this.makeTask("setupCIWorkspace", DefaultTask.class);
        task.setGroup("ForgeGradle");
        task = this.makeTask("setupDevWorkspace", DefaultTask.class);
        task.setGroup("ForgeGradle");
        task.dependsOn(new Object[]{"genSrgs", "deobfuscateJar"});
        task = this.makeTask("setupDecompWorkspace", DefaultTask.class);
        task.setGroup("ForgeGradle");
    }

    @Override
    protected Class<UserExtension> getExtensionClass() {
        return UserExtension.class;
    }

    @Override
    protected String getDevJson() {
        return DelayedBase.resolve("{BUILD_DIR}/unpacked/dev.json", project, new DelayedBase.IDelayedResolver[0]);
    }

    private void tasks() {
        MergeJarsTask task = this.makeTask("mergeJars", MergeJarsTask.class);
        task.setClient(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft/{MC_VERSION}/minecraft-{MC_VERSION}.jar"));
        task.setServer(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_server/{MC_VERSION}/minecraft_server-{MC_VERSION}.jar"));
        task.setOutJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        task.setMergeCfg(this.delayedFile("{BUILD_DIR}/unpacked/conf/mcp_merge.cfg"));
        task.dependsOn(new Object[]{"extractUserDev", "downloadClient", "downloadServer"});
        GenSrgTask task2 = this.makeTask("genSrgs", GenSrgTask.class);
        task2.setInSrg(this.delayedFile("{BUILD_DIR}/unpacked/conf/packaged.srg"));
        task2.setDeobfSrg(this.delayedFile("{BUILD_DIR}/unpacked/conf/notch-mcp.srg"));
        task2.setReobfSrg(this.delayedFile("{BUILD_DIR}/unpacked/conf/mcp-srg.srg"));
        task2.setMethodsCsv(this.delayedFile("{BUILD_DIR}/unpacked/mappings/methods.csv"));
        task2.setFieldsCsv(this.delayedFile("{BUILD_DIR}/unpacked/mappings/fields.csv"));
        task2.dependsOn(new Object[]{"extractUserDev"});
        ProcessJarTask task3 = this.makeTask("deobfuscateJar", ProcessJarTask.class);
        task3.setExceptorJar(this.delayedFile("{CACHE_DIR}/minecraft/exceptor.jar"));
        task3.setSrg(this.delayedFile("{BUILD_DIR}/unpacked/conf/notch-mcp.srg"));
        this.addATs(task3);
        task3.setExceptorCfg(this.delayedFile("{BUILD_DIR}/unpacked/conf/packaged.exc"));
        task3.dependsOn(new Object[]{"downloadMcpTools", "mergeJars", "genSrgs"});
        ReobfTask task4 = this.makeTask("reobf", ReobfTask.class);
        task4.reobf(project.getTasks().getByName("jar"), new Action<ArtifactSpec>(){

            public void execute(ArtifactSpec arg0) {
                JavaPluginConvention javaConv = (JavaPluginConvention)BasePlugin.project.getConvention().getPlugins().get("java");
                arg0.setClasspath(((SourceSet)javaConv.getSourceSets().getByName("main")).getCompileClasspath());
            }
        });
        project.getTasks().getByName("assemble").dependsOn(new Object[]{task4});
    }

    protected abstract void addATs(ProcessJarTask var1);

    private void configureDeps() {
        project.getConfigurations().create("userDevPackageDepConfig");
        project.getConfigurations().create("minecraftNatives");
        project.getConfigurations().create("minecraft");
        ExtractTask extractUserDev = this.makeTask("extractUserDev", ExtractTask.class);
        extractUserDev.into(this.delayedFile("{BUILD_DIR}/unpacked"));
        extractUserDev.doLast((Action)new Action<Task>(){

            public void execute(Task arg0) {
                UserBasePlugin.this.readAndApplyJson(UserBasePlugin.this.delayedFile("{BUILD_DIR}/unpacked/dev.json").call(), "minecraft", "minecraftNatives");
            }
        });
        ExtractTask extractNatives = this.makeTask("extractNatives", ExtractTask.class);
        extractNatives.into(this.delayedFile("{BUILD_DIR}/natives"));
    }

    protected void configureCompilation() {
        Configuration config = project.getConfigurations().getByName("minecraft");
        Javadoc javadoc = (Javadoc)project.getTasks().getByName("javadoc");
        javadoc.getClasspath().add((FileCollection)config);
        JavaPluginConvention javaConv = (JavaPluginConvention)project.getConvention().getPlugins().get("java");
        IdeaModel ideaConv = (IdeaModel)project.getExtensions().getByName("idea");
        EclipseModel eclipseConv = (EclipseModel)project.getExtensions().getByName("eclipse");
        SourceSet main = (SourceSet)javaConv.getSourceSets().getByName("main");
        SourceSet api = (SourceSet)javaConv.getSourceSets().create("api");
        javaConv.setSourceCompatibility((Object)"1.6");
        javaConv.setTargetCompatibility((Object)"1.6");
        api.setCompileClasspath(api.getCompileClasspath().plus((FileCollection)config));
        main.setCompileClasspath(main.getCompileClasspath().plus((FileCollection)config).plus((FileCollection)api.getOutput()));
        ((Collection)((Map)ideaConv.getModule().getScopes().get("COMPILE")).get("plus")).add(config);
        eclipseConv.getClasspath().getPlusConfigurations().add(config);
        ideaConv.getModule().getSourceDirs().addAll(main.getAllSource().getFiles());
        ideaConv.getModule().getSourceDirs().addAll(api.getAllSource().getFiles());
    }

    protected void configureEclipse() {
        EclipseModel eclipseConv = (EclipseModel)project.getExtensions().getByName("eclipse");
        eclipseConv.getClasspath().setDownloadJavadoc(true);
        eclipseConv.getClasspath().setDownloadSources(true);
        eclipseConv.getClasspath().getFile().withXml((Closure)new Closure<Object>((Object)project){

            public Object call(Object ... obj) {
                Node root = ((XmlProvider)this.getDelegate()).asNode();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", "org.eclipse.jdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY");
                map.put("value", UserBasePlugin.this.delayedString("{BUILD_DIR}/natives").call());
                block0: for (Node child : root.children()) {
                    String path = (String)child.attribute((Object)"path");
                    if (path == null || !path.contains("lwjg") && !path.contains("jinput")) continue;
                    if (child.children().isEmpty()) {
                        child.appendNode((Object)"attributes").appendNode((Object)"attribute", map);
                        continue;
                    }
                    for (Node attrib : child.children()) {
                        if (!attrib.name().toString().equals("attributes")) continue;
                        attrib.appendNode((Object)"attribute", map);
                        continue block0;
                    }
                }
                return null;
            }
        });
        DefaultTask task = this.makeTask("afterEclipseImport", DefaultTask.class);
        task.doLast((Action)new Action<Object>(){

            public void execute(Object obj) {
                try {
                    Node root = new XmlParser().parseText(Files.toString((File)BasePlugin.project.file((Object)".classpath"), (Charset)Charset.defaultCharset()));
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("name", "org.eclipse.jdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY");
                    map.put("value", UserBasePlugin.this.delayedString("{BUILD_DIR}/natives").call());
                    for (Node child : root.children()) {
                        if (!child.attribute((Object)"path").equals("org.springsource.ide.eclipse.gradle.classpathcontainer")) continue;
                        child.appendNode((Object)"attributes").appendNode((Object)"attribute", map);
                        break;
                    }
                    String result = XmlUtil.serialize((Node)root);
                    BasePlugin.project.getLogger().lifecycle(result);
                    Files.write((CharSequence)result, (File)BasePlugin.project.file((Object)".classpath"), (Charset)Charset.defaultCharset());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
    }

    protected void configureIntellij() {
        IdeaModel ideaConv = (IdeaModel)project.getExtensions().getByName("idea");
        ideaConv.getModule().getExcludeDirs().addAll(project.files(new Object[]{".gradle", "build"}).getFiles());
        ideaConv.getModule().setDownloadJavadoc(true);
        ideaConv.getModule().setDownloadSources(true);
    }

    @Override
    public void afterEvaluate() {
        super.afterEvaluate();
        if (this.delayedFile("{BUILD_DIR}/unpacked/dev.json").call().exists()) {
            this.readAndApplyJson(this.delayedFile("{BUILD_DIR}/unpacked/dev.json").call(), "minecraft", "minecraftNatives");
        }
        ((ExtractTask)((Object)project.getTasks().findByName("extractUserDev"))).from(this.delayedFile(project.getConfigurations().getByName("userDevPackageDepConfig").getSingleFile().getAbsolutePath()));
        ExtractTask natives = (ExtractTask)((Object)project.getTasks().findByName("extractNatives"));
        for (File file : project.getConfigurations().getByName("minecraftNatives").getFiles()) {
            natives.from(this.delayedFile(file.getAbsolutePath()));
        }
    }

    protected void fixEclipseProject(String path) {
        File f = new File(path);
        if (f.exists() && f.length() == 0L) {
            String projectDir = "URI//file:/" + project.getProjectDir().getAbsolutePath();
            try {
                FileOutputStream fos = new FileOutputStream(f);
                fos.write(LOCATION_BEFORE);
                fos.write((byte)((projectDir.length() & 0xFF) >> 8));
                fos.write((byte)((projectDir.length() & 0xFF) >> 0));
                fos.write(projectDir.getBytes());
                fos.write(LOCATION_AFTER);
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void readAndApplyJson(File file, String depConfig, String nativeConfig) {
        if (this.hasApplied) {
            return;
        }
        ArrayList<String> libs = new ArrayList<String>();
        ArrayList<String> natives = new ArrayList<String>();
        try {
            JsonRootNode root = Constants.PARSER.parse(Files.newReader((File)file, (Charset)Charset.defaultCharset()));
            for (JsonNode node : root.getArrayNode("libraries")) {
                String dep = node.getStringValue("name");
                if (dep.contains("_fixed")) continue;
                if (node.isNode("extract")) {
                    natives.add(dep);
                    continue;
                }
                libs.add(dep);
            }
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        DependencyHandler handler = project.getDependencies();
        for (String dep : libs) {
            handler.add(depConfig, (Object)dep);
        }
        for (String dep : natives) {
            handler.add(nativeConfig, (Object)dep);
        }
        this.hasApplied = true;
    }

    @Override
    public String resolve(String pattern, Project project, UserExtension exten) {
        pattern = pattern.replace("{API_VERSION}", exten.getApiVersion());
        return pattern;
    }

    @Override
    protected DelayedString delayedString(String path) {
        return new DelayedString(project, path, new DelayedBase.IDelayedResolver[]{this});
    }

    @Override
    protected DelayedFile delayedFile(String path) {
        return new DelayedFile(project, path, new DelayedBase.IDelayedResolver[]{this});
    }

    @Override
    protected DelayedFileTree delayedFileTree(String path) {
        return new DelayedFileTree(project, path, new DelayedBase.IDelayedResolver[]{this});
    }

    @Override
    protected DelayedFileTree delayedZipTree(String path) {
        return new DelayedFileTree(project, path, true, this);
    }
}

