/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.user;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.RemapSourcesTask;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class GenSrgTask
extends DefaultTask {
    @InputFile
    private DelayedFile inSrg;
    @InputFile
    private DelayedFile methodsCsv;
    @InputFile
    private DelayedFile fieldsCsv;
    @OutputFile
    private DelayedFile deobfSrg;
    @OutputFile
    private DelayedFile reobfSrg;

    @TaskAction
    public void doTask() throws IOException {
        String line;
        HashMap<String, String> methods = new HashMap<String, String>();
        HashMap<String, String> fields = new HashMap<String, String>();
        CSVReader csvReader = RemapSourcesTask.getReader(this.getMethodsCsv());
        for (String[] s : csvReader.readAll()) {
            methods.put(s[0], s[1]);
        }
        csvReader = RemapSourcesTask.getReader(this.getFieldsCsv());
        for (String[] s : csvReader.readAll()) {
            fields.put(s[0], s[1]);
        }
        File deobfFile = this.getDeobfSrg();
        File reobfFile = this.getReobfSrg();
        if (!deobfFile.exists()) {
            deobfFile.getParentFile().mkdirs();
            deobfFile.createNewFile();
        }
        if (!reobfFile.exists()) {
            reobfFile.getParentFile().mkdirs();
            reobfFile.createNewFile();
        }
        BufferedReader srgIn = Files.newReader((File)this.getInSrg(), (Charset)Charset.defaultCharset());
        BufferedWriter deobf = Files.newWriter((File)this.getDeobfSrg(), (Charset)Charset.defaultCharset());
        BufferedWriter reobf = Files.newWriter((File)this.getReobfSrg(), (Charset)Charset.defaultCharset());
        while ((line = srgIn.readLine()) != null) {
            String out;
            String temp;
            String[] split;
            if (line.startsWith("PK:")) {
                deobf.write(line);
                deobf.newLine();
                reobf.write(line);
                reobf.newLine();
                continue;
            }
            if (line.startsWith("CL:")) {
                deobf.write(line);
                deobf.newLine();
                split = line.split(" ");
                reobf.write("CL: " + split[2] + " " + split[2]);
                reobf.newLine();
                continue;
            }
            if (line.startsWith("FD:")) {
                split = line.split(" ");
                temp = split[2].substring(split[2].lastIndexOf(47) + 1);
                out = split[2];
                if (fields.containsKey(temp)) {
                    out = split[2].replace(temp, (CharSequence)fields.get(temp));
                }
                deobf.write("FD: " + split[1] + " " + out);
                deobf.newLine();
                reobf.write("FD: " + out + " " + split[2]);
                reobf.newLine();
                continue;
            }
            if (!line.startsWith("MD:")) continue;
            split = line.split(" ");
            temp = split[3].substring(split[3].lastIndexOf(47) + 1);
            String in = split[1] + " " + split[2];
            out = split[3] + " " + split[4];
            if (methods.containsKey(temp)) {
                out = out.replace(temp, (CharSequence)methods.get(temp));
            }
            deobf.write("MD: " + in + " " + out);
            deobf.newLine();
            reobf.write("MD: " + out + " " + split[3] + " " + split[4]);
            reobf.newLine();
        }
        srgIn.close();
        deobf.flush();
        deobf.close();
        reobf.flush();
        reobf.close();
    }

    public File getInSrg() {
        return this.inSrg.call();
    }

    public void setInSrg(DelayedFile inSrg) {
        this.inSrg = inSrg;
    }

    public File getMethodsCsv() {
        return this.methodsCsv.call();
    }

    public void setMethodsCsv(DelayedFile methodsCsv) {
        this.methodsCsv = methodsCsv;
    }

    public File getFieldsCsv() {
        return this.fieldsCsv.call();
    }

    public void setFieldsCsv(DelayedFile fieldsCsv) {
        this.fieldsCsv = fieldsCsv;
    }

    public File getDeobfSrg() {
        return this.deobfSrg.call();
    }

    public void setDeobfSrg(DelayedFile deobfSrg) {
        this.deobfSrg = deobfSrg;
    }

    public File getReobfSrg() {
        return this.reobfSrg.call();
    }

    public void setReobfSrg(DelayedFile reobfSrg) {
        this.reobfSrg = reobfSrg;
    }
}

