/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.dev;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ObjectArrays;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.abstractutil.CachedTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class MergeMappingsTask
extends CachedTask {
    public static final Pattern SIG_PATTERN = Pattern.compile("([\\[ZBCSIJFDV]|L([\\w\\\\/]+);)");
    public static final Pattern PACK_PATTERN = Pattern.compile("net\\\\minecraft\\\\src\\\\\\w+");
    public static final Pattern METHOD_SIG_PATTERN = Pattern.compile("^(?<className>[^\\.]+)\\.(?<methodName>[^\\(]+)(?<signature>.*)$");
    private HashMap<String, String> packages = new HashMap();
    @InputFile
    DelayedFile packageCSV;
    @InputFile
    DelayedFile inSRG;
    @InputFile
    DelayedFile inEXC;
    @InputFile
    DelayedFile inPatch;
    @OutputFile
    @CachedTask.Cached
    DelayedFile outPatch;
    @CachedTask.Cached
    @OutputFile
    DelayedFile outSRG;
    @CachedTask.Cached
    @OutputFile
    DelayedFile outEXC;

    @TaskAction
    public void doTask() throws IOException {
        CSVReader reader = new CSVReader((Reader)new FileReader(this.getPackageCSV()), ',', '\"', '\\', 1, false);
        for (String[] line : reader.readAll()) {
            this.packages.put(line[0], line[1]);
        }
        reader.close();
        this.getLogger().info("Fixing the SRG");
        this.fixSRG(this.getInSRG(), this.getOutSRG());
        this.getLogger().info("Fixing the EXC");
        this.fixExceptor(this.getInEXC(), this.getOutEXC());
        this.getLogger().info("Fixing MCP patches");
        this.fixPatch(this.getInPatch(), this.getOutPatch());
    }

    private void fixSRG(File inSRG, File outSRG) throws IOException {
        String line;
        Files.touch((File)inSRG);
        StringBuilder outText = new StringBuilder();
        BufferedReader reader = Files.newReader((File)inSRG, (Charset)Charset.defaultCharset());
        while ((line = reader.readLine()) != null) {
            Object[] split;
            Object[] sections = line.split(" ");
            if (sections[0].equals("CL:")) {
                sections[2] = this.repackageClass(sections[2]);
            } else if (sections[0].equals("FD:")) {
                split = this.rsplit(sections[2], "/");
                split[0] = this.repackageClass(split[0]);
                sections[2] = Joiner.on((String)"/").join(split);
            } else if (sections[0].equals("MD:")) {
                split = this.rsplit((String)sections[3], "/");
                split[0] = this.repackageClass(split[0]);
                sections[3] = Joiner.on((String)"/").join(split);
                sections[4] = this.repackageSig((String)sections[4]);
            }
            line = Joiner.on((String)" ").join(sections);
            outText.append(line).append('\n');
        }
        this.getLogger().info("READ SRG");
        reader.close();
        Files.write((CharSequence)outText.toString(), (File)outSRG, (Charset)Charset.defaultCharset());
        this.getLogger().info("WROTE SRG");
    }

    private void fixExceptor(File inExc, File outExc) throws IOException {
        Files.touch((File)outExc);
        Properties mappings = new Properties();
        Properties mappingsOut = new Properties();
        mappings.load((InputStream)Files.newInputStreamSupplier((File)inExc).getInput());
        for (Map.Entry<Object, Object> entry : mappings.entrySet()) {
            String exceptions;
            Matcher matcher = METHOD_SIG_PATTERN.matcher((String)entry.getKey());
            if (!matcher.matches()) {
                mappingsOut.put(entry.getKey(), entry.getValue());
                continue;
            }
            String className = matcher.group("className");
            String methodName = matcher.group("methodName");
            String signature = matcher.group("signature");
            Object[] exceptionsAndParams = ((String)entry.getValue()).split("\\|");
            if (exceptionsAndParams.length > 0 && !Strings.isNullOrEmpty((String)(exceptions = exceptionsAndParams[0]))) {
                Object[] excs = exceptions.split(",");
                for (int i = 0; i < excs.length; ++i) {
                    excs[i] = this.repackageClass(excs[i]);
                }
                exceptionsAndParams[0] = Joiner.on((char)',').join(excs);
            }
            while (exceptionsAndParams.length < 2) {
                exceptionsAndParams = (String[])ObjectArrays.concat((Object[])exceptionsAndParams, (Object)"");
            }
            signature = this.repackageSig(signature);
            className = this.repackageClass(className);
            String newKey = className + "." + methodName + signature;
            mappingsOut.setProperty(newKey, Joiner.on((char)'|').join(exceptionsAndParams));
        }
        mappingsOut.store((OutputStream)Files.newOutputStreamSupplier((File)outExc).getOutput(), "");
    }

    private void fixPatch(File patch, File outPatch) throws IOException {
        String text = (String)Files.readLines((File)patch, (Charset)Charset.defaultCharset(), (LineProcessor)new PatchLineProcessor());
        Files.touch((File)outPatch);
        Files.write((CharSequence)text, (File)outPatch, (Charset)Charset.defaultCharset());
    }

    private String repackageClass(String input) {
        String className;
        String pack;
        if (input.startsWith("net/minecraft/src") && !Strings.isNullOrEmpty((String)(pack = this.packages.get(className = input.substring(18))))) {
            return pack + "/" + className;
        }
        return input;
    }

    private String repackageSig(String sig) {
        String[] split = this.rsplit(sig, ")");
        String params = split[0];
        String ret = split[1];
        StringBuilder out = new StringBuilder("(");
        Matcher match = SIG_PATTERN.matcher(params);
        while (match.find()) {
            if (match.group().length() > 1) {
                out.append('L').append(this.repackageClass(match.group(2))).append(';');
                continue;
            }
            out.append(match.group());
        }
        out.append(')');
        match = SIG_PATTERN.matcher(ret);
        while (match.find()) {
            if (match.group().length() > 1) {
                out.append('L').append(this.repackageClass(match.group(2))).append(';');
                continue;
            }
            out.append(match.group());
        }
        return out.toString();
    }

    private String[] rsplit(String input, String splitter) {
        int index = input.lastIndexOf(splitter);
        if (index == -1) {
            return new String[]{input};
        }
        String pieceOne = input.substring(0, index);
        String pieceTwo = input.substring(index + 1);
        return new String[]{pieceOne, pieceTwo};
    }

    public File getInEXC() {
        return this.inEXC.call();
    }

    public void setInEXC(DelayedFile inEXC) {
        this.inEXC = inEXC;
    }

    public File getInPatch() {
        return this.inPatch.call();
    }

    public void setInPatch(DelayedFile inPatch) {
        this.inPatch = inPatch;
    }

    public File getInSRG() {
        return this.inSRG.call();
    }

    public void setInSRG(DelayedFile inSRG) {
        this.inSRG = inSRG;
    }

    public File getOutEXC() {
        return this.outEXC.call();
    }

    public void setOutEXC(DelayedFile outEXC) {
        this.outEXC = outEXC;
    }

    public File getOutPatch() {
        return this.outPatch.call();
    }

    public void setOutPatch(DelayedFile outPatch) {
        this.outPatch = outPatch;
    }

    public File getOutSRG() {
        return this.outSRG.call();
    }

    public void setOutSRG(DelayedFile outSRG) {
        this.outSRG = outSRG;
    }

    public File getPackageCSV() {
        return this.packageCSV.call();
    }

    public void setPackageCSV(DelayedFile packageCSV) {
        this.packageCSV = packageCSV;
    }

    private class PatchLineProcessor
    implements LineProcessor<String> {
        StringBuilder builder = new StringBuilder();

        private PatchLineProcessor() {
        }

        public boolean processLine(String s) throws IOException {
            Matcher match = PACK_PATTERN.matcher(s);
            if (match.find()) {
                String clazz = MergeMappingsTask.this.repackageClass(match.group().replace("\\", "/")).replace("/", "\\");
                s = s.replace(match.group(), clazz);
            }
            this.builder.append(s).append(Constants.NEWLINE);
            return true;
        }

        public String getResult() {
            return this.builder.substring(0, this.builder.length() - Constants.NEWLINE.length()).toString();
        }
    }
}

