/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.dev;

import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import groovy.lang.Closure;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import net.minecraftforge.gradle.common.BasePlugin;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedBase;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.delayed.DelayedFileTree;
import net.minecraftforge.gradle.delayed.DelayedString;
import net.minecraftforge.gradle.dev.DevExtension;
import net.minecraftforge.gradle.tasks.DownloadTask;
import net.minecraftforge.gradle.tasks.MergeJarsTask;
import net.minecraftforge.gradle.tasks.abstractutil.ExtractTask;
import net.minecraftforge.gradle.tasks.dev.CompressLZMA;
import net.minecraftforge.gradle.tasks.dev.MergeMappingsTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Sync;
import org.gradle.process.ExecSpec;

public abstract class DevBasePlugin
extends BasePlugin<DevExtension>
implements DelayedBase.IDelayedResolver<DevExtension> {
    protected static final String[] JAVA_FILES = new String[]{"**.java", "*.java", "**/*.java"};

    @Override
    public void applyPlugin() {
        ExtractTask task = this.makeTask("extractWorkspace", ExtractTask.class);
        task.getOutputs().upToDateWhen((Closure)new Closure<Boolean>(null){

            public Boolean call(Object ... obj) {
                File file = new File(BasePlugin.project.getProjectDir(), "eclipse");
                return file.exists() && file.isDirectory();
            }
        });
        task.from(this.delayedFile("eclipse-workspace-dev.zip"));
        task.into(this.delayedFile("eclipse"));
        DownloadTask task1 = this.makeTask("downloadBaseInstaller", DownloadTask.class);
        task1.setOutput(this.delayedFile("{BUILD_DIR}/tmp/installer_base.{INSTALLER_VERSION}.jar"));
        task1.setUrl(this.delayedString("http://files.minecraftforge.net/installer/forge-installer-{INSTALLER_VERSION}-shrunk.jar"));
        MergeMappingsTask task2 = this.makeTask("fixMappings", MergeMappingsTask.class);
        task2.setPackageCSV(this.delayedFile("{MAPPINGS_DIR}/packages.csv"));
        task2.setInSRG(this.delayedFile("{MAPPINGS_DIR}/joined.srg"));
        task2.setInEXC(this.delayedFile("{MAPPINGS_DIR}/joined.exc"));
        task2.setOutSRG(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/packaged-{MC_VERSION}.srg"));
        task2.setOutEXC(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/packaged-{MC_VERSION}.exc"));
        task2.setInPatch(this.delayedFile("{MAPPINGS_DIR}/patches/minecraft_ff.patch"));
        task2.setOutPatch(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/packaged-{MC_VERSION}.patch"));
        CompressLZMA task3 = this.makeTask("compressDeobfData", CompressLZMA.class);
        task3.setInputFile(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/packaged-{MC_VERSION}.srg"));
        task3.setOutputFile(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/deobfuscation_data-{MC_VERSION}.lzma"));
        task3.dependsOn(new Object[]{"fixMappings"});
        MergeJarsTask task4 = this.makeTask("mergeJars", MergeJarsTask.class);
        task4.setClient(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft/{MC_VERSION}/minecraft-{MC_VERSION}.jar"));
        task4.setServer(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_server/{MC_VERSION}/minecraft_server-{MC_VERSION}.jar"));
        task4.setOutJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        task4.setMergeCfg(this.delayedFile("{FML_DIR}/mcp_merge.cfg"));
        task4.dependsOn(new Object[]{"downloadClient", "downloadServer"});
        Sync task5 = this.makeTask("copyAssets", Sync.class);
        task5.from(new Object[]{this.delayedFile("{CACHE_DIR}/minecraft/assets")});
        task5.setDestinationDir(new File("eclipse/run/bin/assets"));
        task5.dependsOn(new Object[]{"getAssets", "extractWorkspace"});
    }

    @Override
    protected final String getDevJson() {
        return DelayedBase.resolve("{FML_DIR}/jsons/{MC_VERSION}-dev.json", project, this);
    }

    @Override
    public void afterEvaluate() {
        super.afterEvaluate();
        try {
            Copy copyTask = this.makeTask("extractNatives", Copy.class);
            copyTask.exclude(new String[]{"META-INF", "META-INF/**", "META-INF/*"});
            copyTask.into((Object)this.delayedString("eclipse/run/bin/natives").call());
            copyTask.dependsOn(new Object[]{"extractWorkspace"});
            String devJson = this.getDevJson();
            if (devJson == null) {
                project.getLogger().info("Dev json not set, could not create native downloads tasks");
                return;
            }
            JsonRootNode node = null;
            File jsonFile = this.delayedFile(devJson).call().getAbsoluteFile();
            node = Constants.PARSER.parse(Files.newReader((File)jsonFile, (Charset)Charset.defaultCharset()));
            for (JsonNode lib : node.getArrayNode("libraries")) {
                if (!lib.isNode("natives") || !lib.isNode("extract")) continue;
                String notation = lib.getStringValue("name");
                String[] s = notation.split(":");
                String path = String.format("%s/%s/%s/%s-%s-natives-%s.jar", new Object[]{s[0].replace('.', '/'), s[1], s[2], s[1], s[2], Constants.OPERATING_SYSTEM});
                DownloadTask task = this.makeTask("downloadNatives-" + s[1], DownloadTask.class);
                task.setOutput(this.delayedFile("{CACHE_DIR}/" + path));
                task.setUrl(this.delayedString("http://repo1.maven.org/maven2/" + path));
                copyTask.from(new Object[]{this.delayedZipTree("{CACHE_DIR}/" + path)});
                copyTask.dependsOn(new Object[]{"downloadNatives-" + s[1]});
            }
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    @Override
    protected Class<DevExtension> getExtensionClass() {
        return DevExtension.class;
    }

    protected String getServerClassPath(File json) {
        try {
            JsonRootNode node = Constants.PARSER.parse(Files.newReader((File)json, (Charset)Charset.defaultCharset()));
            StringBuilder buf = new StringBuilder();
            for (JsonNode lib : node.getArrayNode("versionInfo", "libraries")) {
                if (!lib.isNode("serverreq") || !lib.getBooleanValue("serverreq").booleanValue()) continue;
                String[] pts = lib.getStringValue("name").split(":");
                buf.append(String.format("libraries/%s/%s/%s/%s-%s.jar ", pts[0], pts[1], pts[2], pts[1], pts[2]));
            }
            buf.append(this.delayedString("minecraft_server.{MC_VERSION}").call());
            return buf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String resolve(String pattern, Project project, DevExtension exten) {
        pattern = pattern.replace("{MAIN_CLASS}", exten.getMainClass());
        pattern = pattern.replace("{INSTALLER_VERSION}", exten.getInstallerVersion());
        pattern = pattern.replace("{FML_DIR}", exten.getFmlDir());
        pattern = pattern.replace("{MAPPINGS_DIR}", exten.getFmlDir() + "/conf");
        return pattern;
    }

    protected static String runGit(final Project project, final String ... args) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        project.exec((Closure)new Closure<ExecSpec>((Object)project, (Object)project){

            public ExecSpec call() {
                ExecSpec exec = (ExecSpec)this.getDelegate();
                exec.setExecutable((Object)"git");
                exec.args((Object[])args);
                exec.setStandardOutput((OutputStream)out);
                exec.setWorkingDir((Object)project.getProjectDir());
                return exec;
            }
        });
        return out.toString().trim();
    }

    @Override
    protected DelayedString delayedString(String path) {
        return new DelayedString(project, path, new DelayedBase.IDelayedResolver[]{this});
    }

    @Override
    protected DelayedFile delayedFile(String path) {
        return new DelayedFile(project, path, new DelayedBase.IDelayedResolver[]{this});
    }

    @Override
    protected DelayedFileTree delayedFileTree(String path) {
        return new DelayedFileTree(project, path, new DelayedBase.IDelayedResolver[]{this});
    }

    @Override
    protected DelayedFileTree delayedZipTree(String path) {
        return new DelayedFileTree(project, path, true, this);
    }
}

