/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collection;
import java.util.Locale;

public final class StringUtils {
    private StringUtils() {
    }

    public static String lower(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    public static String fromUTF8Stream(InputStream stream) throws IOException {
        return new String(ByteStreams.toByteArray((InputStream)stream), Charsets.UTF_8);
    }

    public static ImmutableList<String> lines(final String text) {
        try {
            return ImmutableList.copyOf((Collection)CharStreams.readLines((InputSupplier)new InputSupplier<StringReader>(){

                public StringReader getInput() throws IOException {
                    return new StringReader(text);
                }
            }));
        }
        catch (IOException e) {
            return ImmutableList.of();
        }
    }
}

