/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.gradle.common.BaseExtension;
import org.gradle.api.Project;

public class UserExtension
extends BaseExtension {
    private static final Pattern VERSION_CHECK = Pattern.compile("([\\d.]+)-([\\d.]+)-(?:[\\w\\d.]+)");
    private String apiVersion;

    public UserExtension(Project project) {
        super(project);
    }

    @Override
    public void setVersion(String str) {
        Matcher matcher = VERSION_CHECK.matcher(str);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(str + " is not in the form 'MCVersion-apiVersion-branch'!");
        }
        this.version = matcher.group(1);
        this.apiVersion = matcher.group(0);
    }

    public String getApiVersion() {
        return this.apiVersion;
    }
}

