/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.dev;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import net.md_5.specialsource.Jar;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.provider.ClassLoaderProvider;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JarProvider;
import net.md_5.specialsource.provider.JointProvider;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.dev.FmlDevPlugin;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.tasks.TaskAction;

public class ObfuscateTask
extends DefaultTask {
    private DelayedFile outJar;
    private DelayedFile srg;
    private boolean reverse;
    private DelayedFile buildFile;

    @TaskAction
    public void doTask() throws IOException {
        this.getLogger().debug("Building child project model...");
        Project childProj = FmlDevPlugin.getProject(this.getBuildFile(), this.getProject());
        AbstractTask compileTask = (AbstractTask)childProj.getTasks().getByName("compileJava");
        AbstractTask jarTask = (AbstractTask)childProj.getTasks().getByName("jar");
        this.getLogger().debug("Executing child Jar task...");
        this.executeTask(jarTask);
        this.getLogger().debug("Obfuscating jar...");
        this.obfuscate((File)jarTask.property("archivePath"), (FileCollection)compileTask.property("classpath"));
    }

    private void executeTask(AbstractTask task) {
        for (Object dep : task.getTaskDependencies().getDependencies((Task)task)) {
            this.executeTask((AbstractTask)dep);
        }
        if (!task.getState().getExecuted()) {
            this.getLogger().lifecycle(task.getPath());
            task.execute();
        }
    }

    private void obfuscate(File inJar, FileCollection classpath) throws FileNotFoundException, IOException {
        JarMapping mapping = new JarMapping();
        mapping.loadMappings(Files.newReader((File)this.getSrg(), (Charset)Charset.defaultCharset()), null, null, this.reverse);
        JarRemapper remapper = new JarRemapper(null, mapping);
        Jar input = Jar.init((File)inJar);
        JointProvider inheritanceProviders = new JointProvider();
        inheritanceProviders.add((InheritanceProvider)new JarProvider(input));
        if (classpath != null) {
            inheritanceProviders.add((InheritanceProvider)new ClassLoaderProvider((ClassLoader)new URLClassLoader(this.toUrls(classpath))));
        }
        mapping.setFallbackInheritanceProvider((InheritanceProvider)inheritanceProviders);
        File out = this.getOutJar();
        if (!out.getParentFile().exists()) {
            out.getParentFile().mkdirs();
        }
        remapper.remapJar(input, this.getOutJar());
    }

    public URL[] toUrls(FileCollection collection) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : collection.getFiles()) {
            urls.add(file.toURI().toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public File getOutJar() {
        return this.outJar.call();
    }

    public void setOutJar(DelayedFile outJar) {
        this.outJar = outJar;
    }

    public File getSrg() {
        return this.srg.call();
    }

    public void setSrg(DelayedFile srg) {
        this.srg = srg;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public File getBuildFile() {
        return this.buildFile.call();
    }

    public void setBuildFile(DelayedFile buildFile) {
        this.buildFile = buildFile;
    }
}

