/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.dev;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import com.nothome.delta.Delta;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.Adler32;
import java.util.zip.ZipEntry;
import lzma.streams.LzmaOutputStream;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.delayed.DelayedFileTree;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class GenBinaryPatches
extends DefaultTask {
    @InputFile
    private DelayedFile cleanClient;
    @InputFile
    private DelayedFile cleanServer;
    @InputFile
    private DelayedFile cleanMerged;
    @InputFile
    private DelayedFile dirtyJar;
    @InputFiles
    private DelayedFileTree patchList;
    @InputFile
    private DelayedFile deobfDataLzma;
    @InputFile
    private DelayedFile srg;
    @OutputFile
    private DelayedFile outJar;
    private HashMap<String, String> obfMapping = new HashMap();
    private HashMap<String, String> srgMapping = new HashMap();
    private List<String> patchedFiles = new ArrayList<String>();
    private Delta delta = new Delta();

    @TaskAction
    public void doTask() throws Exception {
        this.loadMappings();
        for (File patch : this.getPatchList().getFiles()) {
            String name = patch.getName().replace(".java.patch", "");
            this.patchedFiles.add(this.srgMapping.get(name));
        }
        HashMap<String, byte[]> runtime = new HashMap<String, byte[]>();
        HashMap<String, byte[]> devtime = new HashMap<String, byte[]>();
        this.createBinPatches(runtime, "client/", this.getCleanClient(), this.getDirtyJar());
        this.createBinPatches(runtime, "server/", this.getCleanServer(), this.getDirtyJar());
        this.createBinPatches(devtime, "merged/", this.getCleanMerged(), this.getDirtyJar());
        byte[] runtimedata = this.createPatchJar(runtime);
        runtimedata = this.pack200(runtimedata);
        runtimedata = this.compress(runtimedata);
        byte[] devtimedata = this.createPatchJar(devtime);
        devtimedata = this.pack200(devtimedata);
        devtimedata = this.compress(devtimedata);
        this.buildOutput(runtimedata, devtimedata);
    }

    private void loadMappings() throws Exception {
        Files.readLines((File)this.getSrg(), (Charset)Charset.defaultCharset(), (LineProcessor)new LineProcessor<String>(){
            Splitter splitter = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)": ")).omitEmptyStrings().trimResults();

            public boolean processLine(String line) throws IOException {
                if (!line.startsWith("CL")) {
                    return true;
                }
                String[] parts = (String[])Iterables.toArray((Iterable)this.splitter.split((CharSequence)line), String.class);
                GenBinaryPatches.this.obfMapping.put(parts[1], parts[2]);
                GenBinaryPatches.this.srgMapping.put(parts[2].substring(parts[2].lastIndexOf(47) + 1), parts[1]);
                return true;
            }

            public String getResult() {
                return null;
            }
        });
    }

    private void createBinPatches(HashMap<String, byte[]> patches, String root, File base, File target) throws Exception {
        JarFile cleanJ = new JarFile(base);
        JarFile dirtyJ = new JarFile(target);
        for (Map.Entry<String, String> entry : this.obfMapping.entrySet()) {
            String obf = entry.getKey();
            String srg = entry.getValue();
            if (!this.patchedFiles.contains(obf)) continue;
            JarEntry cleanE = cleanJ.getJarEntry(obf + ".class");
            JarEntry dirtyE = dirtyJ.getJarEntry(obf + ".class");
            if (dirtyE == null) continue;
            byte[] clean = cleanE != null ? ByteStreams.toByteArray((InputStream)cleanJ.getInputStream(cleanE)) : new byte[]{};
            byte[] dirty = ByteStreams.toByteArray((InputStream)dirtyJ.getInputStream(dirtyE));
            byte[] diff = this.delta.compute(clean, dirty);
            ByteArrayDataOutput out = ByteStreams.newDataOutput((int)(diff.length + 50));
            out.writeUTF(obf);
            out.writeUTF(obf.replace('/', '.'));
            out.writeUTF(srg.replace('/', '.'));
            out.writeBoolean(cleanE != null);
            if (cleanE != null) {
                out.writeInt(this.adlerHash(clean));
            }
            out.writeInt(diff.length);
            out.write(diff);
            patches.put(root + srg.replace('/', '.') + ".binpatch", out.toByteArray());
        }
        cleanJ.close();
        dirtyJ.close();
    }

    private int adlerHash(byte[] input) {
        Adler32 hasher = new Adler32();
        hasher.update(input);
        return (int)hasher.getValue();
    }

    private byte[] createPatchJar(HashMap<String, byte[]> patches) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JarOutputStream jar = new JarOutputStream(out);
        for (Map.Entry<String, byte[]> entry : patches.entrySet()) {
            jar.putNextEntry(new JarEntry("binpatch/" + entry.getKey()));
            jar.write(entry.getValue());
        }
        jar.close();
        return out.toByteArray();
    }

    private byte[] pack200(byte[] data) throws Exception {
        JarInputStream in = new JarInputStream(new ByteArrayInputStream(data));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Pack200.Packer packer = Pack200.newPacker();
        SortedMap props = packer.properties();
        props.put("pack.effort", "9");
        props.put("pack.keep.file.order", "true");
        props.put("pack.unknown.attribute", "pass");
        PrintStream err = new PrintStream(System.err);
        System.setErr(new PrintStream(Constants.getNullStream()));
        packer.pack(in, (OutputStream)out);
        System.setErr(err);
        in.close();
        out.close();
        return out.toByteArray();
    }

    private byte[] compress(byte[] data) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LzmaOutputStream lzma = new LzmaOutputStream.Builder((OutputStream)out).useEndMarkerMode(true).build();
        lzma.write(data);
        lzma.close();
        return out.toByteArray();
    }

    private void buildOutput(byte[] runtime, byte[] devtime) throws Exception {
        JarOutputStream out = new JarOutputStream(new FileOutputStream(this.getOutJar()));
        JarFile in = new JarFile(this.getDirtyJar());
        if (runtime != null) {
            out.putNextEntry(new JarEntry("binpatches.pack.lzma"));
            out.write(runtime);
        }
        if (devtime != null) {
            out.putNextEntry(new JarEntry("devbinpatches.pack.lzma"));
            out.write(devtime);
        }
        for (JarEntry e : Collections.list(in.entries())) {
            if (e.isDirectory() || !e.getName().endsWith(".class") || this.obfMapping.containsKey(e.getName().replace(".class", ""))) continue;
            ZipEntry n = new ZipEntry(e.getName());
            n.setTime(e.getTime());
            out.putNextEntry(n);
            out.write(ByteStreams.toByteArray((InputStream)in.getInputStream(e)));
        }
        out.close();
        in.close();
    }

    public File getCleanClient() {
        return this.cleanClient.call();
    }

    public void setCleanClient(DelayedFile cleanClient) {
        this.cleanClient = cleanClient;
    }

    public File getCleanServer() {
        return this.cleanServer.call();
    }

    public void setCleanServer(DelayedFile cleanServer) {
        this.cleanServer = cleanServer;
    }

    public File getCleanMerged() {
        return this.cleanMerged.call();
    }

    public void setCleanMerged(DelayedFile cleanMerged) {
        this.cleanMerged = cleanMerged;
    }

    public File getDirtyJar() {
        return this.dirtyJar.call();
    }

    public void setDirtyJar(DelayedFile dirtyJar) {
        this.dirtyJar = dirtyJar;
    }

    public FileCollection getPatchList() {
        return this.patchList.call();
    }

    public void setPatchList(DelayedFileTree patchList) {
        this.patchList = patchList;
    }

    public File getDeobfDataLzma() {
        return this.deobfDataLzma.call();
    }

    public void setDeobfDataLzma(DelayedFile deobfDataLzma) {
        this.deobfDataLzma = deobfDataLzma;
    }

    public File getOutJar() {
        return this.outJar.call();
    }

    public void setOutJar(DelayedFile outJar) {
        this.outJar = outJar;
    }

    public File getSrg() {
        return this.srg.call();
    }

    public void setSrg(DelayedFile srg) {
        this.srg = srg;
    }
}

