/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.abstractutil;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import groovy.lang.Closure;
import groovy.util.MapEntry;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedFile;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class FileFilterTask
extends DefaultTask {
    @InputFile
    DelayedFile inputFile;
    @OutputFile
    DelayedFile outputFile;
    ArrayList<MapEntry> replacements = new ArrayList();

    public FileFilterTask() {
        this.getOutputs().upToDateWhen(Constants.CALL_FALSE);
    }

    @TaskAction
    public void doTask() throws IOException {
        String input = Files.toString((File)this.getInputFile(), (Charset)Charsets.UTF_8);
        for (MapEntry e : this.replacements) {
            input = input.replaceAll(this.toString(e.getKey()), this.toString(e.getValue()));
        }
        Files.write((byte[])input.getBytes(Charsets.UTF_8), (File)this.getOutputFile());
    }

    private String toString(Object obj) {
        if (obj instanceof Closure) {
            return (String)((Closure)obj).call();
        }
        return (String)obj;
    }

    public void addReplacement(Object search, Object replace) {
        this.replacements.add(new MapEntry(search, replace));
    }

    public void setInputFile(DelayedFile file) {
        this.inputFile = file;
    }

    public void setOutputFile(DelayedFile file) {
        this.outputFile = file;
    }

    public File getInputFile() {
        return this.inputFile.call();
    }

    public File getOutputFile() {
        return this.outputFile == null ? this.getInputFile() : this.outputFile.call();
    }
}

