/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.sourcemanip;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.gradle.common.Constants;

public class SourceRemapper {
    Map<String, Map<String, String>> methods = new HashMap<String, Map<String, String>>();
    Map<String, Map<String, String>> fields = new HashMap<String, Map<String, String>>();
    Map<String, String> params = new HashMap<String, String>();
    private static final Pattern METHOD_SMALL = Pattern.compile("func_[0-9]+_[a-zA-Z_]+");
    private static final Pattern FIELD_SMALL = Pattern.compile("field_[0-9]+_[a-zA-Z_]+");
    private static final Pattern PARAM = Pattern.compile("p_[\\w]+_\\d+_");
    private static final Pattern METHOD = Pattern.compile("^( {4}|\\t)(?:[\\w$.\\[\\]]+ )*(func_[0-9]+_[a-zA-Z_]+)\\(");
    private static final Pattern FIELD = Pattern.compile("^( {4}|\\t)(?:[\\w$.\\[\\]]+ )*(field_[0-9]+_[a-zA-Z_]+) *(?:=|;)");

    SourceRemapper(Map<String, File> files) throws IOException {
        HashMap<String, String> temp;
        CSVReader reader = SourceRemapper.getReader(files.get("methods"));
        for (String[] s : reader.readAll()) {
            temp = new HashMap<String, String>();
            temp.put("name", s[1]);
            temp.put("javadoc", s[3]);
            this.methods.put(s[0], temp);
        }
        reader = SourceRemapper.getReader(files.get("fields"));
        for (String[] s : reader.readAll()) {
            temp = new HashMap();
            temp.put("name", s[1]);
            temp.put("javadoc", s[3]);
            this.fields.put(s[0], temp);
        }
        reader = SourceRemapper.getReader(files.get("params"));
        for (String[] s : reader.readAll()) {
            this.params.put(s[0], s[1]);
        }
    }

    public static CSVReader getReader(File file) throws IOException {
        return new CSVReader((Reader)Files.newReader((File)file, (Charset)Charset.defaultCharset()), ',', '\"', '\\', 1, false);
    }

    private String buildJavadoc(String indent, String javadoc, boolean isMethod) {
        StringBuilder builder = new StringBuilder();
        if (javadoc.length() >= 70 || isMethod) {
            List<String> list = SourceRemapper.wrapText(javadoc, 120 - (indent.length() + 3));
            builder.append(indent);
            builder.append("/**");
            builder.append(Constants.NEWLINE);
            for (String line : list) {
                builder.append(indent);
                builder.append(" * ");
                builder.append(line);
                builder.append(Constants.NEWLINE);
            }
            builder.append(indent);
            builder.append(" */");
            builder.append(Constants.NEWLINE);
        } else {
            builder.append(indent);
            builder.append("/** ");
            builder.append(javadoc);
            builder.append(" */");
            builder.append(Constants.NEWLINE);
        }
        return builder.toString().replace(indent, indent);
    }

    static List<String> wrapText(String text, int len) {
        if (text == null) {
            return new ArrayList<String>();
        }
        if (len <= 0) {
            return new ArrayList<String>(Arrays.asList(text));
        }
        if (text.length() <= len) {
            return new ArrayList<String>(Arrays.asList(text));
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (c == ' ' || c == ',' || c == '-') {
                int tempNum;
                word.append(c);
                int n = tempNum = Character.isWhitespace(c) ? 1 : 0;
                if (line.length() + word.length() - tempNum > len) {
                    lines.add(line.toString());
                    line.delete(0, line.length());
                }
                line.append((CharSequence)word);
                word.delete(0, word.length());
                continue;
            }
            word.append(c);
        }
        if (word.length() > 0) {
            if (line.length() + word.length() > len) {
                lines.add(line.toString());
                line.delete(0, line.length());
            }
            line.append((CharSequence)word);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        ArrayList<String> temp = new ArrayList<String>(lines.size());
        for (String s : lines) {
            temp.add(s.trim());
        }
        return temp;
    }

    public void remapFile(File file) throws IOException {
        Matcher matcher;
        String text = Files.toString((File)file, (Charset)Charset.defaultCharset());
        String prevLine = null;
        ArrayList<String> newLines = new ArrayList<String>();
        for (String line : Files.readLines((File)file, (Charset)Charset.defaultCharset())) {
            String name;
            matcher = METHOD.matcher(line);
            if (matcher.find()) {
                name = matcher.group(2);
                if (!this.methods.containsKey(name) || this.methods.get(name).containsKey("name")) {
                    // empty if block
                }
                line = line.replace(name, this.methods.get(name).get("name"));
                if (this.methods.get(name).containsKey("javadoc")) {
                    line = this.buildJavadoc(matcher.group(1), this.methods.get(name).get("javadoc"), true) + line;
                    if (!Strings.isNullOrEmpty((String)prevLine) && !prevLine.endsWith("{")) {
                        line = Constants.NEWLINE + line;
                    }
                }
            }
            if ((matcher = FIELD.matcher(line)).find() && this.fields.containsKey(name = matcher.group(2))) {
                line = line.replace(name, this.fields.get(name).get("name"));
                if (this.fields.get(name).get("javadoc") != null) {
                    line = this.buildJavadoc(matcher.group(1), this.fields.get(name).get("javadoc"), false) + line;
                    if (!Strings.isNullOrEmpty((String)prevLine) && !prevLine.endsWith("{")) {
                        line = Constants.NEWLINE + line;
                    }
                }
            }
            prevLine = line;
            newLines.add(line);
        }
        text = Joiner.on((String)Constants.NEWLINE).join(newLines) + Constants.NEWLINE;
        matcher = PARAM.matcher(text);
        while (matcher.find()) {
            if (!this.params.containsKey(matcher.group())) continue;
            matcher.replaceFirst(this.params.get(matcher.group()));
        }
        matcher = METHOD_SMALL.matcher(text);
        while (matcher.find()) {
            if (!this.methods.containsKey(matcher.group())) continue;
            matcher.replaceFirst(this.methods.get(matcher.group()).get("name"));
        }
        matcher = FIELD_SMALL.matcher(text);
        while (matcher.find()) {
            if (!this.fields.containsKey(matcher.group())) continue;
            matcher.replaceFirst(this.fields.get(matcher.group()).get("name"));
        }
        Files.write((CharSequence)text, (File)file, (Charset)Charset.defaultCharset());
    }
}

