/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.sourcemanip;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.gradle.common.Constants;

public class FmlCleanup {
    private static final Pattern METHOD_REG = Pattern.compile("^ {4}(\\w+\\s+\\S.*\\(.*|static)$");
    private static final Pattern CATCH_REG = Pattern.compile("catch \\((.*)\\)$");
    private static final Pattern NESTED_PERINTH = Pattern.compile("\\(.*\\(");
    private static final Pattern METHOD_PARAMS = Pattern.compile("\\((.+)\\)");
    private static final Pattern METHOD_DEC_END = Pattern.compile("(}|\\);|throws .+?;)$");
    private static final Pattern METHOD_END = Pattern.compile("^ {4}\\}$");
    private static final Pattern CAPS_START = Pattern.compile("^[A-Z]");
    private static final Pattern ARRAY = Pattern.compile("(\\[|\\.\\.\\.)");
    private static final Pattern VAR_CALL = Pattern.compile("(?i)[a-z_$][a-z0-9_\\[\\]]+ var\\d+");
    private static final Pattern VAR = Pattern.compile("var\\d+");
    private static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String str1, String str2) {
            return str2.length() - str1.length();
        }
    };
    HashMap<String, Holder> last = new HashMap();
    HashMap<String, String> remap;

    public static String renameClass(String text) {
        String[] lines = text.split("(\r\n|\r|\n)");
        String output = "";
        boolean insideMethod = false;
        String method = "";
        ArrayList<String> methodVars = new ArrayList<String>();
        boolean skip = false;
        for (String line : lines) {
            if (METHOD_REG.matcher(line).find() && !line.contains("=") && !NESTED_PERINTH.matcher(line).find()) {
                Matcher match = METHOD_PARAMS.matcher(line);
                if (match.find()) {
                    for (String str : Splitter.on((char)',').trimResults().split((CharSequence)match.group(1))) {
                        methodVars.add(str);
                    }
                }
                method = method + line + Constants.NEWLINE;
                skip = true;
                if (!METHOD_DEC_END.matcher(line).find()) {
                    insideMethod = true;
                }
            } else if (METHOD_END.matcher(line).find()) {
                insideMethod = false;
            }
            if (insideMethod) {
                if (skip) {
                    skip = false;
                    continue;
                }
                method = method + line + Constants.NEWLINE;
                Matcher matcher = CATCH_REG.matcher(line);
                if (matcher.find()) {
                    methodVars.add(matcher.group(1));
                    continue;
                }
                Matcher match = VAR_CALL.matcher(line);
                while (match.find()) {
                    if (match.group().startsWith("return") || match.group().startsWith("throw")) continue;
                    methodVars.add(match.group());
                }
                continue;
            }
            if (!Strings.isNullOrEmpty((String)method)) {
                FmlCleanup namer = new FmlCleanup();
                HashMap<String, String> todo = new HashMap<String, String>();
                for (String var : methodVars) {
                    todo.put(var.split(" ")[1], namer.getName(var.split(" ")[0], var.split(" ")[1]));
                }
                ArrayList sortedKeys = new ArrayList(todo.keySet());
                Collections.sort(sortedKeys, COMPARATOR);
                for (String key : sortedKeys) {
                    if (!VAR.matcher(key).matches()) continue;
                    method = method.replace(key, (CharSequence)todo.get(key));
                }
                output = output + method;
                methodVars.clear();
                method = "";
            }
            if (skip) {
                skip = false;
                continue;
            }
            output = output + line + Constants.NEWLINE;
        }
        return output;
    }

    private FmlCleanup() {
        this.last.put("byte", new Holder(0, false, "b"));
        this.last.put("char", new Holder(0, false, "c"));
        this.last.put("short", new Holder(1, false, "short"));
        this.last.put("int", new Holder(0, true, "i", "j", "k", "l"));
        this.last.put("boolean", new Holder(0, true, "flag"));
        this.last.put("double", new Holder(0, false, "d"));
        this.last.put("float", new Holder(0, true, "f"));
        this.last.put("File", new Holder(1, true, "file"));
        this.last.put("String", new Holder(0, true, "s"));
        this.last.put("Class", new Holder(0, true, "oclass"));
        this.last.put("Long", new Holder(0, true, "olong"));
        this.last.put("Byte", new Holder(0, true, "obyte"));
        this.last.put("Short", new Holder(0, true, "oshort"));
        this.last.put("Boolean", new Holder(0, true, "obool"));
        this.last.put("Package", new Holder(0, true, "opackage"));
        this.remap = new HashMap();
        this.remap.put("long", "int");
    }

    private String getName(String type, String var) {
        String name;
        String index = null;
        if (this.last.containsKey(type)) {
            index = type;
        } else if (this.remap.containsKey(type)) {
            index = this.remap.get(type);
        }
        if (Strings.isNullOrEmpty((String)index) && (CAPS_START.matcher(type).find() || ARRAY.matcher(type).find())) {
            type = type.replace("...", "[]");
            while (type.contains("[][]")) {
                type = type.replaceAll("\\[\\]\\[\\]", "[]");
            }
            String name2 = type.toLowerCase();
            boolean skip_zero = true;
            if (Pattern.compile("\\[").matcher(type).find()) {
                skip_zero = true;
                name2 = "a" + name2;
                name2 = name2.replace("[]", "").replace("...", "");
            }
            this.last.put(type, new Holder(0, skip_zero, name2));
            index = type;
        }
        if (Strings.isNullOrEmpty((String)index)) {
            return type.toLowerCase();
        }
        Holder holder = this.last.get(index);
        int id = holder.id;
        ArrayList<String> data = holder.data;
        int ammount = data.size();
        if (ammount == 1) {
            name = (String)data.get(0) + (id == 0 && holder.skip_zero ? "" : Integer.valueOf(id));
        } else {
            int num = id / ammount;
            name = (String)data.get(id % ammount) + (id < ammount && holder.skip_zero ? "" : Integer.valueOf(num));
        }
        ++holder.id;
        return name;
    }

    private class Holder {
        public int id;
        public boolean skip_zero;
        public final ArrayList<String> data;

        public Holder(int t1, boolean skip_zero, String ... stuff) {
            this.id = t1;
            this.skip_zero = skip_zero;
            this.data = new ArrayList();
            Collections.addAll(this.data, stuff);
        }
    }
}

