/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.dev;

import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import groovy.lang.Closure;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import net.minecraftforge.gradle.common.BasePlugin;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedBase;
import net.minecraftforge.gradle.dev.DevExtension;
import net.minecraftforge.gradle.tasks.DownloadTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Copy;
import org.gradle.process.ExecSpec;

public abstract class DevBasePlugin
extends BasePlugin<DevExtension>
implements DelayedBase.IDelayedResolver<DevExtension> {
    protected static String runGit(final Project project, final String ... args) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        project.exec((Closure)new Closure<ExecSpec>((Object)project, (Object)project){

            public ExecSpec call() {
                ExecSpec exec = (ExecSpec)this.getDelegate();
                exec.setExecutable((Object)"git");
                exec.args((Object[])args);
                exec.setStandardOutput((OutputStream)out);
                exec.setWorkingDir((Object)project.getProjectDir());
                return exec;
            }
        });
        return out.toString().trim();
    }

    @Override
    public void afterEvaluate() {
        try {
            Copy copyTask = this.makeTask("extractNatives", Copy.class);
            copyTask.exclude(new String[]{"META-INF", "META-INF/**", "META-INF/*"});
            copyTask.into((Object)this.delayedString("eclipse/run/bin/natives").call());
            copyTask.dependsOn(new Object[]{"extractWorkspace"});
            String devJson = this.getDevJson();
            if (devJson == null) {
                this.project.getLogger().info("Dev json not set, could not create native downloads tasks");
                return;
            }
            JsonRootNode node = null;
            File jsonFile = this.delayedFile(devJson).call().getAbsoluteFile();
            node = Constants.PARSER.parse(Files.newReader((File)jsonFile, (Charset)Charset.defaultCharset()));
            for (JsonNode lib : node.getArrayNode("libraries")) {
                if (!lib.isNode("natives") || !lib.isNode("extract")) continue;
                String notation = lib.getStringValue("name");
                String[] s = notation.split(":");
                String path = String.format("%s/%s/%s/%s-%s-natives-%s.jar", new Object[]{s[0].replace('.', '/'), s[1], s[2], s[1], s[2], Constants.OPERATING_SYSTEM});
                DownloadTask task = this.makeTask("downloadNatives-" + s[1], DownloadTask.class);
                task.setOutput(this.delayedFile("{CACHE_DIR}/" + path));
                task.setUrl(this.delayedString("http://repo1.maven.org/maven2/" + path));
                copyTask.from(new Object[]{this.delayedZipTree("{CACHE_DIR}/" + path)});
                copyTask.dependsOn(new Object[]{"downloadNatives-" + s[1]});
            }
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    @Override
    protected Class<DevExtension> getExtensionClass() {
        return DevExtension.class;
    }

    @Override
    public String resolve(String pattern, Project project, DevExtension exten) {
        pattern = pattern.replace("{MAIN_CLASS}", exten.getMainClass());
        pattern = pattern.replace("{INSTALLER_VERSION}", exten.getInstallerVersion());
        pattern = pattern.replace("{FML_DIR}", exten.getFmlDir());
        pattern = pattern.replace("{MAPPINGS_DIR}", exten.getFmlDir() + "/conf");
        return pattern;
    }
}

