/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.delayed;

import groovy.lang.Closure;
import net.minecraftforge.gradle.common.BaseExtension;
import net.minecraftforge.gradle.common.JenkinsExtension;
import org.gradle.api.Project;

public abstract class DelayedBase<V>
extends Closure<V> {
    protected Project project;
    protected V resolved;
    protected String pattern;
    protected IDelayedResolver[] resolvers;
    public static final IDelayedResolver<BaseExtension> RESOLVER = new IDelayedResolver<BaseExtension>(){

        @Override
        public String resolve(String pattern, Project project, BaseExtension extension) {
            return pattern;
        }
    };

    public DelayedBase(Project owner, String pattern) {
        this(owner, pattern, RESOLVER);
    }

    public DelayedBase(Project owner, String pattern, IDelayedResolver<? extends BaseExtension> ... resolvers) {
        super((Object)owner);
        this.project = owner;
        this.pattern = pattern;
        this.resolvers = resolvers;
    }

    public abstract V call();

    public static String resolve(String patern, Project project, IDelayedResolver ... resolvers) {
        String version;
        project.getLogger().info("Resolving: " + patern);
        BaseExtension exten = (BaseExtension)project.getExtensions().getByName("minecraft");
        JenkinsExtension jenk = (JenkinsExtension)project.getExtensions().getByName("jenkins");
        String build = "0";
        if (System.getenv().containsKey("BUILD_NUMBER")) {
            build = System.getenv("BUILD_NUMBER");
        }
        if ((version = project.getVersion().toString()).startsWith(exten.getVersion() + "-")) {
            version = version.substring(exten.getVersion().length() + 1);
        }
        patern = patern.replace("{MC_VERSION}", exten.getVersion());
        patern = patern.replace("{CACHE_DIR}", project.getGradle().getGradleUserHomeDir().getAbsolutePath() + "/caches/minecraft");
        patern = patern.replace("{BUILD_DIR}", project.getBuildDir().getAbsolutePath());
        patern = patern.replace("{VERSION}", version);
        patern = patern.replace("{BUILD_NUM}", build);
        patern = patern.replace("{PROJECT}", project.getName());
        patern = patern.replace("{JENKINS_SERVER}", jenk.getServer());
        patern = patern.replace("{JENKINS_JOB}", jenk.getJob());
        patern = patern.replace("{JENKINS_AUTH_NAME}", jenk.getAuthName());
        patern = patern.replace("{JENKINS_AUTH_PASSWORD}", jenk.getAuthPassword());
        for (IDelayedResolver r : resolvers) {
            patern = r.resolve(patern, project, exten);
        }
        project.getLogger().info("Resolved:  " + patern);
        return patern;
    }

    public static interface IDelayedResolver<K extends BaseExtension> {
        public String resolve(String var1, Project var2, K var3);
    }
}

