/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common;

import java.io.File;
import java.util.HashMap;
import net.minecraftforge.gradle.common.BaseExtension;
import net.minecraftforge.gradle.common.JenkinsExtension;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.delayed.DelayedFileTree;
import net.minecraftforge.gradle.delayed.DelayedString;
import net.minecraftforge.gradle.tasks.DownloadTask;
import net.minecraftforge.gradle.tasks.ObtainMcpStuffTask;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.testfixtures.ProjectBuilder;

public abstract class BasePlugin<K extends BaseExtension>
implements Plugin<Project> {
    protected Project project;

    public final void apply(Project arg) {
        this.project = arg;
        this.project.getLogger().lifecycle("**************************");
        this.project.getLogger().lifecycle("Powered By MCP Data:      ");
        this.project.getLogger().lifecycle(" http://mcp.ocean-labs.de/ ");
        this.project.getLogger().lifecycle(" Searge, ProfMobius, Fesh0r, ");
        this.project.getLogger().lifecycle(" R4wk, ZeuX, IngisKahn ");
        this.project.getLogger().lifecycle("**************************");
        this.project.getExtensions().create("minecraft", this.getExtensionClass(), new Object[]{this.project});
        this.project.getExtensions().create("jenkins", JenkinsExtension.class, new Object[]{this.project});
        this.addMavenRepo("forge", "http://files.minecraftforge.net/maven");
        this.project.getRepositories().mavenCentral();
        this.addMavenRepo("minecraft", "http://s3.amazonaws.com/Minecraft.Download/libraries");
        this.project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                BasePlugin.this.afterEvaluate();
            }
        });
        this.makeObtainTasks();
        this.applyPlugin();
    }

    public abstract void applyPlugin();

    protected abstract String getDevJson();

    public void afterEvaluate() {
    }

    private void makeObtainTasks() {
        DownloadTask task = this.makeTask("downloadClient", DownloadTask.class);
        task.setOutput(this.delayedFile("{CACHE_DIR}/net/minecraft/minecraft/{MC_VERSION}/minecraft-{MC_VERSION}.jar"));
        task.setUrl(this.delayedString("http://s3.amazonaws.com/Minecraft.Download/versions/{MC_VERSION}/{MC_VERSION}.jar"));
        task = this.makeTask("downloadServer", DownloadTask.class);
        task.setOutput(this.delayedFile("{CACHE_DIR}/net/minecraft/minecraft_server/{MC_VERSION}/minecraft_server-{MC_VERSION}.jar"));
        task.setUrl(this.delayedString("http://s3.amazonaws.com/Minecraft.Download/versions/{MC_VERSION}/minecraft_server.{MC_VERSION}.jar"));
        ObtainMcpStuffTask mcpTask = this.makeTask("downloadMcpTools", ObtainMcpStuffTask.class);
        mcpTask.setMcpUrl(this.delayedString("http://mcp.ocean-labs.de/files/archive/mcp804.zip"));
        mcpTask.setFfJar(this.delayedFile("{CACHE_DIR}/fernflower.jar"));
        mcpTask.setInjectorJar(this.delayedFile("{CACHE_DIR}/exceptor.jar"));
    }

    protected Class<K> getExtensionClass() {
        return BaseExtension.class;
    }

    public final K getExtension() {
        return (K)((BaseExtension)this.project.getExtensions().getByName("minecraft"));
    }

    public DefaultTask makeTask(String name) {
        return this.makeTask(name, DefaultTask.class);
    }

    public <T extends Task> T makeTask(String name, Class<T> type) {
        return BasePlugin.makeTask(this.project, name, type);
    }

    public static <T extends Task> T makeTask(Project proj, String name, Class<T> type) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", name);
        map.put("type", type);
        return (T)proj.task(map, name);
    }

    public static Project getProject(File buildFile, Project parent) {
        Project project = ProjectBuilder.builder().withProjectDir(buildFile.getParentFile()).withName(buildFile.getParentFile().getName()).withParent(parent).build();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("from", buildFile.getName());
        project.apply(map);
        return project;
    }

    public void applyExternalPlugin(String plugin) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("plugin", plugin);
        this.project.apply(map);
    }

    public void addMavenRepo(final String name, final String url) {
        this.project.getRepositories().maven((Action)new Action<MavenArtifactRepository>(){

            public void execute(MavenArtifactRepository repo) {
                repo.setName(name);
                repo.setUrl((Object)url);
            }
        });
    }

    protected DelayedString delayedString(String path) {
        return new DelayedString(this.project, path);
    }

    protected DelayedFile delayedFile(String path) {
        return new DelayedFile(this.project, path);
    }

    protected DelayedFileTree delayedFileTree(String path) {
        return new DelayedFileTree(this.project, path);
    }

    protected DelayedFileTree delayedZipTree(String path) {
        return new DelayedFileTree(this.project, path, true);
    }
}

