/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user;

import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.user.ApplyBinPatchesTask;
import net.minecraftforge.gradle.user.UserBasePlugin;

public class FmlUserPlugin
extends UserBasePlugin {
    @Override
    public void applyPlugin() {
        super.applyPlugin();
        ApplyBinPatchesTask binTask = this.makeTask("applyBinPatches", ApplyBinPatchesTask.class);
        binTask.setInJar(this.delayedFile("{CACHE_DIR}/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        binTask.setOutJar(this.delayedFile("{CACHE_DIR}/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}.jar"));
        binTask.setPatches(this.delayedFile("{BUILD_DIR}/unpacked/devbinpatches.pack.lzma"));
        binTask.setClassesJar(this.delayedFile("{BUILD_DIR}/unpacked/binaries.jar"));
        binTask.dependsOn(new Object[]{"mergeJars"});
        ProcessJarTask procTask = (ProcessJarTask)this.project.getTasks().getByName("deobfuscateJar");
        procTask.dependsOn(new Object[]{binTask});
        procTask.setInJar(this.delayedFile("{CACHE_DIR}/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}.jar"));
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}-srg.jar"));
    }

    @Override
    public void afterEvaluate() {
        super.afterEvaluate();
        this.project.getDependencies().add("minecraft", (Object)this.project.files(new Object[]{this.delayedFile("{CACHE_DIR}/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}-srg.jar").call()}));
    }

    @Override
    protected void addATs(ProcessJarTask task) {
        task.addTransformer(this.delayedFile("{BUILD_DIR}/unpacked/src/fml_at.cfg"));
    }
}

