/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.abstractutil;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.gradle.delayed.DelayedFile;
import org.apache.shiro.util.AntPathMatcher;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;

public class ExtractTask
extends DefaultTask {
    private AntPathMatcher antMatcher = new AntPathMatcher();
    private LinkedHashSet<DelayedFile> sourcePaths = new LinkedHashSet();
    private List<String> excludes = new ArrayList<String>();
    private List<String> includes = new ArrayList<String>();
    private boolean includeEmptyDirs = true;
    private DelayedFile destDir = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void doTask() throws IOException {
        if (!this.destDir.call().exists()) {
            this.destDir.call().mkdirs();
        }
        for (DelayedFile source : this.sourcePaths) {
            this.getLogger().debug("Extracting: " + (Object)((Object)source));
            try (ZipFile input = new ZipFile(source.call());){
                Enumeration<? extends ZipEntry> itr = input.entries();
                while (itr.hasMoreElements()) {
                    ZipEntry entry = itr.nextElement();
                    if (!this.shouldExtract(entry.getName())) continue;
                    File out = new File(this.destDir.call(), entry.getName());
                    this.getLogger().debug("  " + out);
                    if (entry.isDirectory()) {
                        if (!this.includeEmptyDirs || out.exists()) continue;
                        out.mkdirs();
                        continue;
                    }
                    File outParent = out.getParentFile();
                    if (!outParent.exists()) {
                        outParent.mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(out);
                    InputStream ins = input.getInputStream(entry);
                    ByteStreams.copy((InputStream)ins, (OutputStream)fos);
                    fos.close();
                    ins.close();
                }
            }
        }
    }

    private boolean shouldExtract(String path) {
        for (String exclude : this.excludes) {
            if (!this.antMatcher.matches(exclude, path)) continue;
            return false;
        }
        for (String include : this.includes) {
            if (!this.antMatcher.matches(include, path)) continue;
            return true;
        }
        return this.includes.size() == 0;
    }

    public ExtractTask from(DelayedFile ... paths) {
        for (DelayedFile path : paths) {
            this.sourcePaths.add(path);
        }
        return this;
    }

    public ExtractTask into(DelayedFile target) {
        this.destDir = target;
        return this;
    }

    public ExtractTask include(String ... paterns) {
        for (String patern : paterns) {
            this.includes.add(patern);
        }
        return this;
    }

    public ExtractTask exclude(String ... paterns) {
        for (String patern : paterns) {
            this.excludes.add(patern);
        }
        return this;
    }

    public boolean isIncludeEmptyDirs() {
        return this.includeEmptyDirs;
    }

    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }
}

