/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.abstractutil;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.abstractutil.CachedTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class EditJarTask
extends CachedTask {
    @InputFile
    protected DelayedFile inJar;
    @OutputFile
    @CachedTask.Cached
    protected DelayedFile outJar;
    protected HashMap<String, String> sourceMap = new HashMap();
    protected HashMap<String, byte[]> resourceMap = new HashMap();

    @TaskAction
    public void doTask() throws Throwable {
        this.getLogger().info("Reading jar: " + (Object)((Object)this.inJar));
        this.readJarAndClean(this.getInJar());
        this.doStuff();
        this.getLogger().info("Saving jar: " + (Object)((Object)this.outJar));
        this.saveJar(this.getOutJar());
    }

    public abstract String asRead(String var1);

    public abstract void doStuff() throws Throwable;

    private void readJarAndClean(File jar) throws IOException {
        ZipInputStream zin = new ZipInputStream(new FileInputStream(jar));
        ZipEntry entry = null;
        while ((entry = zin.getNextEntry()) != null) {
            if (entry.getName().contains("META-INF")) continue;
            if (entry.isDirectory() || !entry.getName().endsWith(".java")) {
                this.resourceMap.put(entry.getName(), ByteStreams.toByteArray((InputStream)zin));
                continue;
            }
            String fileStr = new String(ByteStreams.toByteArray((InputStream)zin), Charset.defaultCharset());
            fileStr = this.asRead(fileStr);
            this.sourceMap.put(entry.getName(), fileStr);
        }
        zin.close();
    }

    private void saveJar(File output) throws IOException {
        ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(output));
        for (Map.Entry<String, byte[]> entry : this.resourceMap.entrySet()) {
            zout.putNextEntry(new ZipEntry(entry.getKey()));
            zout.write(entry.getValue());
            zout.closeEntry();
        }
        for (Map.Entry<String, Object> entry : this.sourceMap.entrySet()) {
            zout.putNextEntry(new ZipEntry(entry.getKey()));
            zout.write(((String)entry.getValue()).getBytes());
            zout.closeEntry();
        }
        zout.close();
    }

    public File getInJar() {
        return this.inJar.call();
    }

    public void setInJar(DelayedFile inJar) {
        this.inJar = inJar;
    }

    public File getOutJar() {
        return this.outJar.call();
    }

    public void setOutJar(DelayedFile outJar) {
        this.outJar = outJar;
    }

    public HashMap<String, byte[]> getResourceMap() {
        return this.resourceMap;
    }

    public void setResourceMap(HashMap<String, byte[]> resourceMap) {
        this.resourceMap = resourceMap;
    }

    public HashMap<String, String> getSourceMap() {
        return this.sourceMap;
    }

    public void setSourceMap(HashMap<String, String> sourceMap) {
        this.sourceMap = sourceMap;
    }
}

