/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.code.ExceptionHandler;
import org.jetbrains.java.decompiler.code.ExceptionTable;
import org.jetbrains.java.decompiler.code.FullInstructionSequence;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IVariableNameProvider;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.attr.StructCodeAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGenericSignatureAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMain;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMethodDescriptor;
import org.jetbrains.java.decompiler.util.DataInputFullStream;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class StructMethod
extends StructMember {
    private static final int[] opr_iconst = new int[]{-1, 0, 1, 2, 3, 4, 5};
    private static final int[] opr_loadstore = new int[]{0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3};
    private static final int[] opcs_load = new int[]{21, 22, 23, 24, 25};
    private static final int[] opcs_store = new int[]{54, 55, 56, 57, 58};
    private final String name;
    private final String descriptor;
    private final int bytecodeVersion;
    private final int localVariables;
    private final int codeLength;
    private final int codeFullLength;
    private InstructionSequence seq = null;
    private boolean expanded = false;
    private final String classQualifiedName;
    private final GenericMethodDescriptor signature;
    private IVariableNameProvider renamer;
    public Set<String> enclosedClasses;

    public static StructMethod create(DataInputFullStream in, ConstantPool pool, String clQualifiedName, int bytecodeVersion, boolean own) throws IOException {
        StructGenericSignatureAttribute signatureAttr;
        int accessFlags = in.readUnsignedShort();
        int nameIndex = in.readUnsignedShort();
        int descriptorIndex = in.readUnsignedShort();
        String[] values = pool.getClassElement(2, clQualifiedName, nameIndex, descriptorIndex);
        Map<String, StructGeneralAttribute> attributes = StructMethod.readAttributes(in, pool);
        StructCodeAttribute code = (StructCodeAttribute)attributes.remove(StructGeneralAttribute.ATTRIBUTE_CODE.name);
        if (code != null) {
            attributes.putAll(code.codeAttributes);
        }
        GenericMethodDescriptor signature = null;
        if (DecompilerContext.getOption("dgs") && (signatureAttr = (StructGenericSignatureAttribute)attributes.get(StructGeneralAttribute.ATTRIBUTE_SIGNATURE.name)) != null) {
            signature = GenericMain.parseMethodSignature(signatureAttr.getSignature());
        }
        return new StructMethod(accessFlags, attributes, values[0], values[1], bytecodeVersion, own ? code : null, clQualifiedName, signature);
    }

    private StructMethod(int accessFlags, Map<String, StructGeneralAttribute> attributes, String name, String descriptor, int bytecodeVersion, StructCodeAttribute code, String classQualifiedName, GenericMethodDescriptor signature) {
        super(accessFlags, attributes);
        this.name = name;
        this.descriptor = descriptor;
        this.bytecodeVersion = bytecodeVersion;
        if (code != null) {
            this.localVariables = code.localVariables;
            this.codeLength = code.codeLength;
            this.codeFullLength = code.codeFullLength;
        } else {
            this.codeFullLength = -1;
            this.codeLength = -1;
            this.localVariables = -1;
        }
        this.classQualifiedName = classQualifiedName;
        this.signature = signature;
    }

    public void expandData(StructClass classStruct) throws IOException {
        if (this.codeLength >= 0 && !this.expanded) {
            byte[] code = classStruct.getLoader().loadBytecode(classStruct, this, this.codeFullLength);
            this.seq = this.parseBytecode(new DataInputFullStream(code), this.codeLength, classStruct.getPool());
            this.expanded = true;
        }
    }

    public void releaseResources() {
        if (this.codeLength >= 0 && this.expanded) {
            this.seq = null;
            this.expanded = false;
        }
    }

    private InstructionSequence parseBytecode(DataInputFullStream in, int length, ConstantPool pool) throws IOException {
        VBStyleCollection<Instruction, Integer> instructions = new VBStyleCollection<Instruction, Integer>();
        int i = 0;
        while (i < length) {
            boolean wide;
            int offset = i;
            int opcode = in.readUnsignedByte();
            int group = 1;
            boolean bl = wide = opcode == 196;
            if (wide) {
                ++i;
                opcode = in.readUnsignedByte();
            }
            ArrayList<Integer> operands = new ArrayList<Integer>();
            if (opcode >= 2 && opcode <= 8) {
                operands.add(opr_iconst[opcode - 2]);
                opcode = 16;
            } else if (opcode >= 26 && opcode <= 45) {
                operands.add(opr_loadstore[opcode - 26]);
                opcode = opcs_load[(opcode - 26) / 4];
            } else if (opcode >= 59 && opcode <= 78) {
                operands.add(opr_loadstore[opcode - 59]);
                opcode = opcs_store[(opcode - 59) / 4];
            } else {
                switch (opcode) {
                    case 16: {
                        operands.add(Integer.valueOf(in.readByte()));
                        ++i;
                        break;
                    }
                    case 18: 
                    case 188: {
                        operands.add(in.readUnsignedByte());
                        ++i;
                        break;
                    }
                    case 17: 
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 198: 
                    case 199: {
                        if (opcode != 17) {
                            group = 2;
                        }
                        operands.add(Integer.valueOf(in.readShort()));
                        i += 2;
                        break;
                    }
                    case 19: 
                    case 20: 
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 187: 
                    case 189: 
                    case 192: 
                    case 193: {
                        operands.add(in.readUnsignedShort());
                        i += 2;
                        if (opcode >= 178 && opcode <= 181) {
                            group = 5;
                            break;
                        }
                        if (opcode < 182 || opcode > 184) break;
                        group = 4;
                        break;
                    }
                    case 186: {
                        if (this.bytecodeVersion < 51) break;
                        operands.add(in.readUnsignedShort());
                        in.discard(2);
                        group = 4;
                        i += 4;
                        break;
                    }
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 169: {
                        if (wide) {
                            operands.add(in.readUnsignedShort());
                            i += 2;
                        } else {
                            operands.add(in.readUnsignedByte());
                            ++i;
                        }
                        if (opcode != 169) break;
                        group = 6;
                        break;
                    }
                    case 132: {
                        if (wide) {
                            operands.add(in.readUnsignedShort());
                            operands.add(Integer.valueOf(in.readShort()));
                            i += 4;
                            break;
                        }
                        operands.add(in.readUnsignedByte());
                        operands.add(Integer.valueOf(in.readByte()));
                        i += 2;
                        break;
                    }
                    case 200: 
                    case 201: {
                        opcode = opcode == 201 ? 168 : 167;
                        operands.add(in.readInt());
                        group = 2;
                        i += 4;
                        break;
                    }
                    case 185: {
                        operands.add(in.readUnsignedShort());
                        operands.add(in.readUnsignedByte());
                        in.discard(1);
                        group = 4;
                        i += 4;
                        break;
                    }
                    case 197: {
                        operands.add(in.readUnsignedShort());
                        operands.add(in.readUnsignedByte());
                        i += 3;
                        break;
                    }
                    case 170: {
                        in.discard((4 - (i + 1) % 4) % 4);
                        i += (4 - (i + 1) % 4) % 4;
                        operands.add(in.readInt());
                        i += 4;
                        int low = in.readInt();
                        operands.add(low);
                        i += 4;
                        int high = in.readInt();
                        operands.add(high);
                        i += 4;
                        for (int j = 0; j < high - low + 1; ++j) {
                            operands.add(in.readInt());
                            i += 4;
                        }
                        group = 3;
                        break;
                    }
                    case 171: {
                        in.discard((4 - (i + 1) % 4) % 4);
                        i += (4 - (i + 1) % 4) % 4;
                        operands.add(in.readInt());
                        i += 4;
                        int npairs = in.readInt();
                        operands.add(npairs);
                        i += 4;
                        for (int j = 0; j < npairs; ++j) {
                            operands.add(in.readInt());
                            i += 4;
                            operands.add(in.readInt());
                            i += 4;
                        }
                        group = 3;
                        break;
                    }
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 191: {
                        group = 6;
                    }
                }
            }
            int[] ops = null;
            if (!operands.isEmpty()) {
                ops = new int[operands.size()];
                for (int j = 0; j < operands.size(); ++j) {
                    ops[j] = (Integer)operands.get(j);
                }
            }
            Instruction instr = Instruction.create(opcode, wide, group, this.bytecodeVersion, ops, ++i - offset);
            instructions.addWithKey(instr, offset);
        }
        ArrayList<ExceptionHandler> lstHandlers = new ArrayList<ExceptionHandler>();
        int exception_count = in.readUnsignedShort();
        for (int i2 = 0; i2 < exception_count; ++i2) {
            ExceptionHandler handler = new ExceptionHandler();
            handler.from = in.readUnsignedShort();
            handler.to = in.readUnsignedShort();
            handler.handler = in.readUnsignedShort();
            int excclass = in.readUnsignedShort();
            if (excclass != 0) {
                handler.exceptionClass = pool.getPrimitiveConstant(excclass).getString();
            }
            lstHandlers.add(handler);
        }
        FullInstructionSequence seq = new FullInstructionSequence(instructions, new ExceptionTable(lstHandlers));
        int i3 = seq.length() - 1;
        seq.setPointer(i3);
        while (i3 >= 0) {
            Instruction instr = seq.getInstr(i3--);
            if (instr.group != 1) {
                instr.initInstruction(seq);
            }
            seq.addToPointer(-1);
        }
        return seq;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public int getBytecodeVersion() {
        return this.bytecodeVersion;
    }

    public boolean containsCode() {
        return this.codeLength >= 0;
    }

    public int getLocalVariables() {
        return this.localVariables;
    }

    public InstructionSequence getInstructionSequence() {
        return this.seq;
    }

    public IVariableNameProvider getVariableNamer() {
        if (this.renamer == null) {
            this.renamer = DecompilerContext.getNamingFactory().createFactory(this);
        }
        return this.renamer;
    }

    public void clearVariableNamer() {
        this.renamer = null;
    }

    public StructLocalVariableTableAttribute getLocalVariableAttr() {
        return this.getAttribute(StructGeneralAttribute.ATTRIBUTE_LOCAL_VARIABLE_TABLE);
    }

    public String toString() {
        return this.name;
    }

    public String getClassQualifiedName() {
        return this.classQualifiedName;
    }

    public GenericMethodDescriptor getSignature() {
        return this.signature;
    }
}

