/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.VarNamesCollector;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.util.StatementIterator;

public class VarDefinitionHelper {
    private final HashMap<Integer, Statement> mapVarDefStatements = new HashMap();
    private final HashMap<Integer, HashSet<Integer>> mapStatementVars = new HashMap();
    private final HashSet<Integer> implDefVars = new HashSet();
    private final VarProcessor varproc;
    private final Statement root;
    private final StructMethod mt;

    public VarDefinitionHelper(Statement root, StructMethod mt, VarProcessor varproc) {
        this.varproc = varproc;
        this.root = root;
        this.mt = mt;
        VarNamesCollector vc = varproc.getVarNamesCollector();
        boolean thisvar = !mt.hasModifier(8);
        MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
        int paramcount = 0;
        if (thisvar) {
            paramcount = 1;
        }
        paramcount += md.params.length;
        int varindex = 0;
        for (int i = 0; i < paramcount; ++i) {
            this.implDefVars.add(varindex);
            VarVersionPair vpp = new VarVersionPair(varindex, 0);
            varproc.setVarName(vpp, vc.getFreeName(varindex));
            if (thisvar) {
                if (i == 0) {
                    ++varindex;
                    continue;
                }
                varindex += md.params[i - 1].stackSize;
                continue;
            }
            varindex += md.params[i].stackSize;
        }
        if (thisvar) {
            StructClass current_class = (StructClass)DecompilerContext.getProperty("CURRENT_CLASS");
            varproc.getThisVars().put(new VarVersionPair(0, 0), current_class.qualifiedName);
            varproc.setVarName(new VarVersionPair(0, 0), "this");
            vc.addName("this");
        }
        this.mergeVars(root);
        LinkedList<Statement> stack = new LinkedList<Statement>();
        stack.add(root);
        while (!stack.isEmpty()) {
            Statement st = (Statement)stack.removeFirst();
            List<VarExprent> lstVars = null;
            if (st.type == 12) {
                lstVars = ((CatchAllStatement)st).getVars();
            } else if (st.type == 7) {
                lstVars = new ArrayList<VarExprent>(((CatchStatement)st).getVars());
                for (Exprent exp : ((CatchStatement)st).getResources()) {
                    lstVars.add((VarExprent)((AssignmentExprent)exp).getLeft());
                }
            }
            if (lstVars != null) {
                for (VarExprent var : lstVars) {
                    this.implDefVars.add(var.getIndex());
                    varproc.setVarName(new VarVersionPair(var), vc.getFreeName(var.getIndex()));
                    var.setDefinition(true);
                }
            }
            stack.addAll(st.getStats());
        }
        this.initStatement(root);
    }

    public void setVarDefinitions() {
        VarNamesCollector vc = this.varproc.getVarNamesCollector();
        for (Map.Entry<Integer, Statement> en : this.mapVarDefStatements.entrySet()) {
            Statement first;
            Statement stat = en.getValue();
            Integer index = en.getKey();
            if (this.implDefVars.contains(index)) continue;
            this.varproc.setVarName(new VarVersionPair((int)index, 0), vc.getFreeName(index));
            if (stat.type == 5) {
                VarExprent var;
                DoStatement dstat = (DoStatement)stat;
                if (dstat.getLooptype() == 3) {
                    if (dstat.getInitExprent() != null && this.setDefinition(dstat.getInitExprent(), index)) continue;
                    List<Exprent> lstSpecial = Arrays.asList(dstat.getConditionExprent(), dstat.getIncExprent());
                    for (VarExprent var2 : VarDefinitionHelper.getAllVars(lstSpecial)) {
                        if (var2.getIndex() != index.intValue()) continue;
                        stat = stat.getParent();
                        break;
                    }
                } else if (dstat.getLooptype() == 4 && dstat.getInitExprent() != null && dstat.getInitExprent().type == 12 && (var = (VarExprent)dstat.getInitExprent()).getIndex() == index.intValue()) {
                    var.setDefinition(true);
                    continue;
                }
            }
            List<Exprent> lst = (first = this.findFirstBlock(stat, index)) == null ? stat.getVarDefinitions() : (first.getExprents() == null ? first.getVarDefinitions() : first.getExprents());
            boolean defset = false;
            int addindex = 0;
            for (Exprent expr : lst) {
                if (this.setDefinition(expr, index)) {
                    defset = true;
                    break;
                }
                boolean foundvar = false;
                for (Exprent exp : expr.getAllExprents(true)) {
                    if (exp.type != 12 || ((VarExprent)exp).getIndex() != index.intValue()) continue;
                    foundvar = true;
                    break;
                }
                if (foundvar) break;
                ++addindex;
            }
            if (defset) continue;
            VarExprent var = new VarExprent(index, this.varproc.getVarType(new VarVersionPair((int)index, 0)), this.varproc);
            var.setDefinition(true);
            StructLocalVariableTableAttribute.LocalVariable lvt = this.findLVT((int)index, stat);
            if (lvt != null) {
                var.setLVT(lvt);
            }
            lst.add(addindex, var);
        }
        this.mergeVars(this.root);
        this.propogateLVTs(this.root);
        this.setNonFinal(this.root, new HashSet<VarVersionPair>());
    }

    private StructLocalVariableTableAttribute.LocalVariable findLVT(int index, Statement stat) {
        if (stat.getExprents() == null) {
            for (Object obj : stat.getSequentialObjects()) {
                StructLocalVariableTableAttribute.LocalVariable lvt;
                if (!(obj instanceof Statement ? (lvt = this.findLVT(index, (Statement)obj)) != null : obj instanceof Exprent && (lvt = this.findLVT(index, (Exprent)obj)) != null)) continue;
                return lvt;
            }
        } else {
            for (Exprent exp : stat.getExprents()) {
                StructLocalVariableTableAttribute.LocalVariable lvt = this.findLVT(index, exp);
                if (lvt == null) continue;
                return lvt;
            }
        }
        return null;
    }

    private StructLocalVariableTableAttribute.LocalVariable findLVT(int index, Exprent exp) {
        for (Exprent e : exp.getAllExprents(false)) {
            StructLocalVariableTableAttribute.LocalVariable lvt = this.findLVT(index, e);
            if (lvt == null) continue;
            return lvt;
        }
        if (exp.type != 12) {
            return null;
        }
        VarExprent var = (VarExprent)exp;
        return var.getIndex() == index ? var.getLVT() : null;
    }

    private Statement findFirstBlock(Statement stat, Integer varindex) {
        LinkedList<Statement> stack = new LinkedList<Statement>();
        stack.add(stat);
        block4: while (!stack.isEmpty()) {
            Statement st = (Statement)stack.remove(0);
            if (!stack.isEmpty() && !this.mapStatementVars.get(st.id).contains(varindex)) continue;
            if (st.isLabeled() && !stack.isEmpty()) {
                return st;
            }
            if (st.getExprents() != null) {
                return st;
            }
            stack.clear();
            switch (st.type) {
                case 15: {
                    stack.addAll(0, st.getStats());
                    continue block4;
                }
                case 2: 
                case 6: 
                case 10: 
                case 13: {
                    stack.add(st.getFirst());
                    continue block4;
                }
            }
            return st;
        }
        return null;
    }

    private Set<Integer> initStatement(Statement stat) {
        List<VarExprent> condlst;
        HashMap<Integer, Integer> mapCount = new HashMap<Integer, Integer>();
        if (stat.getExprents() == null) {
            ArrayList childVars = new ArrayList();
            ArrayList<Exprent> currVars = new ArrayList<Exprent>();
            for (Object obj : stat.getSequentialObjects()) {
                if (obj instanceof Statement) {
                    CatchAllStatement fin;
                    Statement st = (Statement)obj;
                    childVars.addAll(this.initStatement(st));
                    if (st.type == 5) {
                        DoStatement dost = (DoStatement)st;
                        if (dost.getLooptype() == 3 || dost.getLooptype() == 4 || dost.getLooptype() == 0) continue;
                        currVars.add(dost.getConditionExprent());
                        continue;
                    }
                    if (st.type != 12 || !(fin = (CatchAllStatement)st).isFinally() || fin.getMonitor() == null) continue;
                    currVars.add(fin.getMonitor());
                    continue;
                }
                if (!(obj instanceof Exprent)) continue;
                currVars.add((Exprent)obj);
            }
            Iterator<Object> iterator = childVars.iterator();
            while (iterator.hasNext()) {
                Integer index = (Integer)iterator.next();
                Integer count = (Integer)mapCount.get(index);
                if (count == null) {
                    count = 0;
                }
                mapCount.put(index, count + 1);
            }
            condlst = VarDefinitionHelper.getAllVars(currVars);
        } else {
            condlst = VarDefinitionHelper.getAllVars(stat.getExprents());
        }
        for (VarExprent var : condlst) {
            mapCount.put(var.getIndex(), 2);
        }
        HashSet<Integer> set = new HashSet<Integer>(mapCount.keySet());
        for (Map.Entry en : mapCount.entrySet()) {
            if ((Integer)en.getValue() <= 1) continue;
            this.mapVarDefStatements.put((Integer)en.getKey(), stat);
        }
        this.mapStatementVars.put(stat.id, set);
        return set;
    }

    private static List<VarExprent> getAllVars(List<Exprent> lst) {
        ArrayList<VarExprent> res = new ArrayList<VarExprent>();
        ArrayList<Exprent> listTemp = new ArrayList<Exprent>();
        for (Exprent expr : lst) {
            listTemp.addAll(expr.getAllExprents(true));
            listTemp.add(expr);
        }
        for (Exprent exprent : listTemp) {
            if (exprent.type != 12) continue;
            res.add((VarExprent)exprent);
        }
        return res;
    }

    private boolean setDefinition(Exprent expr, Integer index) {
        if (expr.type == 2) {
            VarExprent var;
            Exprent left = ((AssignmentExprent)expr).getLeft();
            if (left.type == 12 && (var = (VarExprent)left).getIndex() == index.intValue()) {
                var.setDefinition(true);
                return true;
            }
        }
        return false;
    }

    private void populateTypeBounds(VarProcessor proc, Statement stat) {
        Map<VarVersionPair, VarType> mapExprentMinTypes = this.varproc.getVarVersions().getTypeProcessor().getMapExprentMinTypes();
        Map<VarVersionPair, VarType> mapExprentMaxTypes = this.varproc.getVarVersions().getTypeProcessor().getMapExprentMaxTypes();
        LinkedList<Statement> stack = new LinkedList<Statement>();
        stack.add(this.root);
        while (!stack.isEmpty()) {
            Statement st = (Statement)stack.removeFirst();
            if (st.getExprents() != null) {
                LinkedList<Exprent> exps = new LinkedList<Exprent>();
                exps.addAll(st.getExprents());
                block4: while (!exps.isEmpty()) {
                    Exprent exp = (Exprent)exps.removeFirst();
                    switch (exp.type) {
                        case 4: 
                        case 5: 
                        case 8: {
                            ExitExprent exit;
                            Exprent instance = null;
                            String target = null;
                            if (exp.type == 8) {
                                instance = ((InvocationExprent)exp).getInstance();
                                target = ((InvocationExprent)exp).getClassname();
                            } else if (exp.type == 5) {
                                instance = ((FieldExprent)exp).getInstance();
                                target = ((FieldExprent)exp).getClassname();
                            } else if (exp.type == 4 && (exit = (ExitExprent)exp).getExitType() == 0) {
                                instance = exit.getValue();
                                target = exit.getRetType().value;
                            }
                            if ("java/lang/Object".equals(target) || instance == null || instance.type != 12) continue block4;
                            VarVersionPair key = ((VarExprent)instance).getVarVersionPair();
                            VarType newType = new VarType(8, 0, target);
                            VarType oldMin = mapExprentMinTypes.get(key);
                            VarType oldMax = mapExprentMaxTypes.get(key);
                            if (newType.equals(oldMax)) continue block4;
                            if (oldMax != null && oldMax.type == 8) {
                                if (!DecompilerContext.getStructContext().instanceOf(newType.value, oldMax.value)) continue block4;
                                mapExprentMaxTypes.put(key, newType);
                                break;
                            }
                            mapExprentMaxTypes.put(key, newType);
                            break;
                        }
                        default: {
                            exps.addAll(exp.getAllExprents());
                        }
                    }
                }
            }
            stack.addAll(st.getStats());
        }
    }

    private VPPEntry mergeVars(Statement stat) {
        HashMap<Integer, VarVersionPair> parent = new HashMap<Integer, VarVersionPair>();
        MethodDescriptor md = MethodDescriptor.parseDescriptor(this.mt.getDescriptor());
        int index = 0;
        if (!this.mt.hasModifier(8)) {
            parent.put(index, new VarVersionPair(index++, 0));
        }
        for (VarType var : md.params) {
            parent.put(index, new VarVersionPair(index, 0));
            index += var.stackSize;
        }
        this.populateTypeBounds(this.varproc, stat);
        HashMap<VarVersionPair, VarVersionPair> blacklist = new HashMap<VarVersionPair, VarVersionPair>();
        VPPEntry remap = this.mergeVars(stat, parent, new HashMap<Integer, VarVersionPair>(), blacklist);
        while (remap != null) {
            if (!this.remapVar(stat, (VarVersionPair)remap.getKey(), (VarVersionPair)remap.getValue())) {
                blacklist.put((VarVersionPair)remap.getKey(), (VarVersionPair)remap.getValue());
            }
            remap = this.mergeVars(stat, parent, new HashMap<Integer, VarVersionPair>(), blacklist);
        }
        return null;
    }

    private VPPEntry mergeVars(Statement stat, Map<Integer, VarVersionPair> parent, Map<Integer, VarVersionPair> leaked, Map<VarVersionPair, VarVersionPair> blacklist) {
        HashMap<Integer, VarVersionPair> this_vars = new HashMap<Integer, VarVersionPair>();
        if (parent.size() > 0) {
            this_vars.putAll(parent);
        }
        if (stat.getVarDefinitions().size() > 0) {
            for (int x = 0; x < stat.getVarDefinitions().size(); ++x) {
                Exprent exp = stat.getVarDefinitions().get(x);
                if (exp.type != 12) continue;
                VarExprent var = (VarExprent)exp;
                int index = this.varproc.getVarOriginalIndex(var.getIndex());
                if (this_vars.containsKey(index)) {
                    stat.getVarDefinitions().remove(x);
                    return new VPPEntry(var, (VarVersionPair)this_vars.get(index));
                }
                this_vars.put(index, new VarVersionPair(var));
                leaked.put(index, new VarVersionPair(var));
            }
        }
        Map<Integer, VarVersionPair> scoped = null;
        switch (stat.type) {
            case 0: 
            case 8: 
            case 13: 
            case 15: {
                scoped = leaked;
            }
        }
        if (stat.getExprents() == null) {
            List<Object> objs = stat.getSequentialObjects();
            for (int i = 0; i < objs.size(); ++i) {
                VPPEntry ret;
                Object obj = objs.get(i);
                if (obj instanceof Statement) {
                    Statement st = (Statement)obj;
                    HashMap<Integer, VarVersionPair> leaked_n = new HashMap<Integer, VarVersionPair>();
                    VPPEntry remap = this.mergeVars(st, this_vars, leaked_n, blacklist);
                    if (remap != null) {
                        return remap;
                    }
                    if (leaked_n.size() <= 0) continue;
                    if (stat.type == 2) {
                        IfStatement ifst = (IfStatement)stat;
                        if (obj == ifst.getIfstat() || obj == ifst.getElsestat()) {
                            leaked_n.clear();
                        } else if (obj == ifst.getFirst()) {
                            leaked.putAll(leaked_n);
                        }
                    } else if (stat.type == 6 || stat.type == 10) {
                        if (obj == stat.getFirst()) {
                            leaked.putAll(leaked_n);
                        } else {
                            leaked_n.clear();
                        }
                    } else if (stat.type == 7 || stat.type == 12) {
                        leaked_n.clear();
                    }
                    this_vars.putAll(leaked_n);
                    continue;
                }
                if (!(obj instanceof Exprent) || (ret = this.processExprent((Exprent)obj, this_vars, scoped, blacklist)) == null || !VarDefinitionHelper.isVarReadFirst((VarVersionPair)ret.getValue(), stat, i + 1, new VarExprent[0])) continue;
                return ret;
            }
        } else {
            List<Exprent> exps = stat.getExprents();
            for (int i = 0; i < exps.size(); ++i) {
                VPPEntry ret = this.processExprent(exps.get(i), this_vars, scoped, blacklist);
                if (ret == null || VarDefinitionHelper.isVarReadFirst((VarVersionPair)ret.getValue(), stat, i + 1, new VarExprent[0])) continue;
                return ret;
            }
        }
        return null;
    }

    private VPPEntry processExprent(Exprent exp, Map<Integer, VarVersionPair> this_vars, Map<Integer, VarVersionPair> leaked, Map<VarVersionPair, VarVersionPair> blacklist) {
        VarVersionPair old;
        VarVersionPair black;
        VarExprent var = null;
        if (exp.type == 2) {
            AssignmentExprent ass = (AssignmentExprent)exp;
            if (ass.getLeft().type != 12) {
                return null;
            }
            var = (VarExprent)ass.getLeft();
        } else if (exp.type == 12) {
            var = (VarExprent)exp;
        }
        if (var == null) {
            return null;
        }
        if (!var.isDefinition()) {
            return null;
        }
        int index = this.varproc.getVarOriginalIndex(var.getIndex());
        VarVersionPair new_ = this_vars.get(index);
        if (!(new_ == null || (black = blacklist.get(old = new VarVersionPair(var))) != null && black.equals(new_))) {
            return new VPPEntry(var, this_vars.get(index));
        }
        this_vars.put(index, new VarVersionPair(var));
        if (leaked != null) {
            leaked.put(index, new VarVersionPair(var));
        }
        return null;
    }

    private boolean remapVar(Statement stat, VarVersionPair from, VarVersionPair to) {
        if (from.equals(to)) {
            throw new IllegalArgumentException("Shit went wrong: " + from);
        }
        boolean success = false;
        if (stat.getExprents() == null) {
            for (Object obj : stat.getSequentialObjects()) {
                if (obj instanceof Statement) {
                    success |= this.remapVar((Statement)obj, from, to);
                    continue;
                }
                if (!(obj instanceof Exprent) || !this.remapVar((Exprent)obj, from, to)) continue;
                success = true;
            }
        } else {
            boolean remapped = false;
            for (int x = 0; x < stat.getExprents().size(); ++x) {
                Exprent exp = stat.getExprents().get(x);
                if (!this.remapVar(exp, from, to)) continue;
                remapped = true;
                if (exp.type != 12 || ((VarExprent)exp).isDefinition()) continue;
                stat.getExprents().remove(x);
                --x;
            }
            success |= remapped;
        }
        if (success) {
            Iterator<Exprent> itr = stat.getVarDefinitions().iterator();
            while (itr.hasNext()) {
                VarType merged;
                Exprent exp = itr.next();
                if (exp.type != 12) continue;
                VarExprent var = (VarExprent)exp;
                if (from.equals(var.getVarVersionPair())) {
                    itr.remove();
                    continue;
                }
                if (to.var != var.getIndex() || to.version != var.getVersion() || (merged = this.getMergedType(from, to)) == null) continue;
                var.setVarType(merged);
            }
        }
        return success;
    }

    private boolean remapVar(Exprent exprent, VarVersionPair from, VarVersionPair to) {
        if (exprent == null) {
            return false;
        }
        List<Exprent> lst = exprent.getAllExprents(true);
        lst.add(exprent);
        boolean remapped = false;
        for (Exprent expr : lst) {
            VarType merged;
            VarExprent var;
            VarVersionPair old;
            if (expr.type == 2) {
                VarType merged2;
                ConstExprent right;
                VarVersionPair left;
                AssignmentExprent ass = (AssignmentExprent)expr;
                if (ass.getLeft().type != 12 || ass.getRight().type != 3 || !(left = new VarVersionPair((VarExprent)ass.getLeft())).equals(from) && !left.equals(to) || (right = (ConstExprent)ass.getRight()).getConstType() == VarType.VARTYPE_NULL || (merged2 = this.getMergedType(from, to)) == null) continue;
                right.setConstType(merged2);
                continue;
            }
            if (expr.type != 12 || !(old = new VarVersionPair(var = (VarExprent)expr)).equals(from) || (merged = this.getMergedType(from, to)) == null) continue;
            var.setIndex(to.var);
            var.setVersion(to.version);
            var.setVarType(merged);
            if (var.isDefinition()) {
                var.setDefinition(false);
            }
            this.varproc.setVarType(to, merged);
            remapped = true;
        }
        return remapped;
    }

    private VarType getMergedType(VarVersionPair from, VarVersionPair to) {
        Map<VarVersionPair, VarType> minTypes = this.varproc.getVarVersions().getTypeProcessor().getMapExprentMinTypes();
        Map<VarVersionPair, VarType> maxTypes = this.varproc.getVarVersions().getTypeProcessor().getMapExprentMaxTypes();
        return this.getMergedType(minTypes.get(from), minTypes.get(to), maxTypes.get(from), maxTypes.get(to));
    }

    private VarType getMergedType(VarType fromMin, VarType toMin, VarType fromMax, VarType toMax) {
        VarType type;
        if (fromMin != null && fromMin.equals(toMin)) {
            return fromMin;
        }
        VarType varType = fromMin == null ? toMin : (type = toMin == null ? fromMin : VarType.getCommonSupertype(fromMin, toMin));
        if (type == null || fromMin == null || toMin == null) {
            return null;
        }
        if (type.type == 8) {
            if (toMax != null) {
                if (fromMax != null) {
                    if (DecompilerContext.getStructContext().instanceOf(fromMax.value, toMax.value)) {
                        return fromMax;
                    }
                } else if (fromMin != null && DecompilerContext.getStructContext().instanceOf(fromMin.value, toMax.value)) {
                    return fromMin;
                }
            } else if (toMin != null) {
                if (fromMax != null) {
                    if (DecompilerContext.getStructContext().instanceOf(fromMax.value, toMin.value)) {
                        return fromMax;
                    }
                } else if (fromMin != null && DecompilerContext.getStructContext().instanceOf(toMin.value, fromMin.value)) {
                    return toMin;
                }
            }
            return null;
        }
        return type;
    }

    private void propogateLVTs(Statement stat) {
        MethodDescriptor md = MethodDescriptor.parseDescriptor(this.mt.getDescriptor());
        LinkedHashMap<VarVersionPair, VarInfo> types = new LinkedHashMap<VarVersionPair, VarInfo>();
        if (this.varproc.hasLVT()) {
            int index = 0;
            if (!this.mt.hasModifier(8)) {
                List<StructLocalVariableTableAttribute.LocalVariable> lvt = this.varproc.getCandidates(index);
                if (lvt != null && lvt.size() > 0) {
                    types.put(new VarVersionPair(index, 0), new VarInfo((StructLocalVariableTableAttribute.LocalVariable)lvt.get(0), null));
                }
                ++index;
            }
            for (VarType var : md.params) {
                List<StructLocalVariableTableAttribute.LocalVariable> lvt = this.varproc.getCandidates(index);
                if (lvt != null && lvt.size() > 0) {
                    types.put(new VarVersionPair(index, 0), new VarInfo(lvt.get(0), null));
                }
                index += var.stackSize;
            }
        }
        this.findTypes(stat, types);
        LinkedHashMap<VarVersionPair, String> typeNames = new LinkedHashMap<VarVersionPair, String>();
        for (Map.Entry entry : types.entrySet()) {
            typeNames.put((VarVersionPair)entry.getKey(), ((VarInfo)entry.getValue()).getCast());
        }
        Map<VarVersionPair, String> renames = this.mt.getVariableNamer().rename(typeNames);
        StatementIterator.iterate(this.root, exprent -> {
            NewExprent _new;
            ClassesProcessor.ClassNode child;
            ArrayList<StructMethod> methods = new ArrayList<StructMethod>();
            if (exprent.type == 12) {
                VarExprent var = (VarExprent)exprent;
                if (var.isClassDef() && (child = DecompilerContext.getClassProcessor().getMapRootClasses().get(var.getVarType().value)) != null) {
                    methods.addAll(child.classStruct.getMethods());
                }
            } else if (exprent.type == 10 && (_new = (NewExprent)exprent).isAnonymous() && (child = DecompilerContext.getClassProcessor().getMapRootClasses().get(_new.getNewType().value)) != null) {
                if (_new.isLambda()) {
                    if (!child.lambdaInformation.is_method_reference) {
                        methods.add(child.classStruct.getMethod(child.lambdaInformation.content_method_name, child.lambdaInformation.content_method_descriptor));
                    }
                } else {
                    methods.addAll(child.classStruct.getMethods());
                }
            }
            for (StructMethod meth : methods) {
                meth.getVariableNamer().addParentContext(this.mt.getVariableNamer());
            }
            return 0;
        });
        if (this.mt.enclosedClasses != null) {
            for (String cls : this.mt.enclosedClasses) {
                StructClass cl = DecompilerContext.getStructContext().getClass(cls);
                for (StructMethod meth : cl.getMethods()) {
                    meth.getVariableNamer().addParentContext(this.mt.getVariableNamer());
                }
            }
        }
        HashMap<VarVersionPair, StructLocalVariableTableAttribute.LocalVariable> hashMap = new HashMap<VarVersionPair, StructLocalVariableTableAttribute.LocalVariable>();
        for (Map.Entry e : types.entrySet()) {
            String rename;
            VarVersionPair idx = (VarVersionPair)e.getKey();
            if (idx.var == 0 && !this.mt.hasModifier(8)) continue;
            StructLocalVariableTableAttribute.LocalVariable lvt = ((VarInfo)e.getValue()).getLVT();
            String string = rename = renames == null ? null : renames.get(idx);
            if (rename != null) {
                this.varproc.setVarName(idx, rename);
            }
            if (lvt == null) continue;
            if (rename != null) {
                lvt = lvt.rename(rename);
            }
            this.varproc.setVarLVT(idx, lvt);
            hashMap.put(idx, lvt);
        }
        this.applyTypes(stat, hashMap);
    }

    private void findTypes(Statement stat, Map<VarVersionPair, VarInfo> types) {
        if (stat == null) {
            return;
        }
        for (Exprent exp : stat.getVarDefinitions()) {
            this.findTypes(exp, types);
        }
        if (stat.getExprents() == null) {
            for (Object obj : stat.getSequentialObjects()) {
                if (obj instanceof Statement) {
                    this.findTypes((Statement)obj, types);
                    continue;
                }
                if (!(obj instanceof Exprent)) continue;
                this.findTypes((Exprent)obj, types);
            }
        } else {
            for (Exprent exp : stat.getExprents()) {
                this.findTypes(exp, types);
            }
        }
    }

    private void findTypes(Exprent exp, Map<VarVersionPair, VarInfo> types) {
        List<Exprent> lst = exp.getAllExprents(true);
        lst.add(exp);
        for (Exprent exprent : lst) {
            if (exprent.type != 12) continue;
            VarExprent var = (VarExprent)exprent;
            VarVersionPair ver = new VarVersionPair(var);
            if (var.isDefinition()) {
                types.put(ver, new VarInfo(var.getLVT(), var.getVarType()));
                continue;
            }
            VarInfo existing = types.get(ver);
            if (existing == null) {
                existing = new VarInfo(var.getLVT(), var.getVarType());
            } else if (existing.getLVT() == null && var.getLVT() != null) {
                existing = new VarInfo(var.getLVT(), existing.getType());
            }
            types.put(ver, existing);
        }
    }

    private void applyTypes(Statement stat, Map<VarVersionPair, StructLocalVariableTableAttribute.LocalVariable> types) {
        if (stat == null || types.size() == 0) {
            return;
        }
        for (Exprent exp : stat.getVarDefinitions()) {
            this.applyTypes(exp, types);
        }
        if (stat.getExprents() == null) {
            for (Object obj : stat.getSequentialObjects()) {
                if (obj instanceof Statement) {
                    this.applyTypes((Statement)obj, types);
                    continue;
                }
                if (!(obj instanceof Exprent)) continue;
                this.applyTypes((Exprent)obj, types);
            }
        } else {
            for (Exprent exp : stat.getExprents()) {
                this.applyTypes(exp, types);
            }
        }
    }

    private void applyTypes(Exprent exprent, Map<VarVersionPair, StructLocalVariableTableAttribute.LocalVariable> types) {
        if (exprent == null) {
            return;
        }
        List<Exprent> lst = exprent.getAllExprents(true);
        lst.add(exprent);
        for (Exprent expr : lst) {
            if (expr.type != 12) continue;
            VarExprent var = (VarExprent)expr;
            StructLocalVariableTableAttribute.LocalVariable lvt = types.get(new VarVersionPair(var));
            if (lvt != null) {
                var.setLVT(lvt);
                continue;
            }
            System.currentTimeMillis();
        }
    }

    private static boolean isVarReadFirst(VarVersionPair var, Statement stat, int index, VarExprent ... whitelist) {
        if (stat.getExprents() == null) {
            List<Object> objs = stat.getSequentialObjects();
            for (int x = index; x < objs.size(); ++x) {
                Object obj = objs.get(x);
                if (!(obj instanceof Statement ? VarDefinitionHelper.isVarReadFirst(var, (Statement)obj, 0, whitelist) : obj instanceof Exprent && VarDefinitionHelper.isVarReadFirst(var, (Exprent)obj, whitelist))) continue;
                return true;
            }
        } else {
            for (int x = index; x < stat.getExprents().size(); ++x) {
                if (!VarDefinitionHelper.isVarReadFirst(var, stat.getExprents().get(x), whitelist)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isVarReadFirst(VarVersionPair target, Exprent exp, VarExprent ... whitelist) {
        AssignmentExprent ass = exp.type == 2 ? (AssignmentExprent)exp : null;
        List<Exprent> lst = exp.getAllExprents(true);
        lst.add(exp);
        for (Exprent ex : lst) {
            VarExprent var;
            if (ex.type != 12 || (var = (VarExprent)ex).getIndex() != target.var || var.getVersion() != target.version) continue;
            boolean allowed = false;
            if (ass != null && var == ass.getLeft()) {
                allowed = true;
            }
            for (VarExprent white : whitelist) {
                if (var != white) continue;
                allowed = true;
            }
            if (allowed) continue;
            return true;
        }
        return false;
    }

    private void setNonFinal(Statement stat, Set<VarVersionPair> unInitialized) {
        IfStatement ifstat;
        if (stat.getExprents() != null && !stat.getExprents().isEmpty()) {
            for (Exprent exp : stat.getExprents()) {
                if (exp.type == 12) {
                    unInitialized.add(new VarVersionPair((VarExprent)exp));
                    continue;
                }
                this.setNonFinal(exp, unInitialized);
            }
        }
        if (!stat.getVarDefinitions().isEmpty() && stat.type != 5) {
            for (Exprent var : stat.getVarDefinitions()) {
                unInitialized.add(new VarVersionPair((VarExprent)var));
            }
        }
        if (stat.type == 5) {
            DoStatement dostat = (DoStatement)stat;
            if (dostat.getInitExprentList() != null) {
                this.setNonFinal(dostat.getInitExprent(), unInitialized);
            }
            if (dostat.getIncExprentList() != null) {
                this.setNonFinal(dostat.getIncExprent(), unInitialized);
            }
        } else if (stat.type == 2 && (ifstat = (IfStatement)stat).getIfstat() != null && ifstat.getElsestat() != null) {
            this.setNonFinal(ifstat.getFirst(), unInitialized);
            this.setNonFinal(ifstat.getIfstat(), new HashSet<VarVersionPair>(unInitialized));
            this.setNonFinal(ifstat.getElsestat(), unInitialized);
            return;
        }
        for (Statement st : stat.getStats()) {
            this.setNonFinal(st, unInitialized);
        }
    }

    private void setNonFinal(Exprent exp, Set<VarVersionPair> unInitialized) {
        FunctionExprent func;
        VarExprent var = null;
        if (exp == null) {
            return;
        }
        if (exp.type == 2) {
            AssignmentExprent assign = (AssignmentExprent)exp;
            if (assign.getLeft().type == 12) {
                var = (VarExprent)assign.getLeft();
            }
        } else if (exp.type == 6 && (func = (FunctionExprent)exp).getFuncType() >= 32 && func.getFuncType() <= 35 && func.getLstOperands().get((int)0).type == 12) {
            var = (VarExprent)func.getLstOperands().get(0);
        }
        if (var != null && !var.isDefinition() && !unInitialized.remove(var.getVarVersionPair())) {
            var.getProcessor().setVarFinal(var.getVarVersionPair(), 1);
        }
        for (Exprent ex : exp.getAllExprents()) {
            this.setNonFinal(ex, unInitialized);
        }
    }

    private static class VarInfo {
        private StructLocalVariableTableAttribute.LocalVariable lvt;
        private String cast;
        private VarType type;

        private VarInfo(StructLocalVariableTableAttribute.LocalVariable lvt, VarType type) {
            this.cast = lvt != null && lvt.getSignature() != null ? ExprProcessor.getCastTypeName(GenericType.parse(lvt.getSignature()), false) : (lvt != null ? ExprProcessor.getCastTypeName(lvt.getVarType(), false) : (type != null ? ExprProcessor.getCastTypeName(type, false) : "this"));
            this.lvt = lvt;
            this.type = type;
        }

        public StructLocalVariableTableAttribute.LocalVariable getLVT() {
            return this.lvt;
        }

        public String getCast() {
            return this.cast;
        }

        public VarType getType() {
            return this.type;
        }
    }

    private static class VPPEntry
    extends SimpleEntry<VarVersionPair, VarVersionPair> {
        public VPPEntry(VarExprent key, VarVersionPair value) {
            super(new VarVersionPair(key), value);
        }
    }

    private static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V tmp = this.value;
            this.value = value;
            return tmp;
        }
    }
}

