/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.DecHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.IfExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.StartEndPair;
import org.jetbrains.java.decompiler.util.TextBuffer;
import org.jetbrains.java.decompiler.util.TextUtil;

public final class IfStatement
extends Statement {
    public static final int IFTYPE_IF = 0;
    public static final int IFTYPE_IFELSE = 1;
    public int iftype;
    private Statement ifstat;
    private Statement elsestat;
    private StatEdge ifedge;
    private StatEdge elseedge;
    private boolean negated = false;
    private final List<Exprent> headexprent = new ArrayList<Exprent>(1);

    private IfStatement() {
        this.type = 2;
        this.headexprent.add(null);
    }

    private IfStatement(Statement head, int regedges, Statement postst) {
        this();
        this.first = head;
        this.stats.addWithKey(head, head.id);
        List<StatEdge> lstHeadSuccs = head.getSuccessorEdges(0x40000000);
        switch (regedges) {
            case 0: {
                this.ifstat = null;
                this.elsestat = null;
                break;
            }
            case 1: {
                this.ifstat = null;
                this.elsestat = null;
                StatEdge edgeif = lstHeadSuccs.get(1);
                if (edgeif.getType() != 1) {
                    this.post = lstHeadSuccs.get(0).getDestination();
                    break;
                }
                this.post = edgeif.getDestination();
                this.negated = true;
                break;
            }
            case 2: {
                this.elsestat = lstHeadSuccs.get(0).getDestination();
                this.ifstat = lstHeadSuccs.get(1).getDestination();
                List<StatEdge> lstSucc = this.ifstat.getSuccessorEdges(1);
                List<StatEdge> lstSucc1 = this.elsestat.getSuccessorEdges(1);
                if (this.ifstat.getPredecessorEdges(1).size() > 1 || lstSucc.size() > 1) {
                    this.post = this.ifstat;
                } else if (this.elsestat.getPredecessorEdges(1).size() > 1 || lstSucc1.size() > 1) {
                    this.post = this.elsestat;
                } else if (lstSucc.size() == 0) {
                    this.post = this.elsestat;
                } else if (lstSucc1.size() == 0) {
                    this.post = this.ifstat;
                }
                if (this.ifstat == this.post) {
                    if (this.elsestat != this.post) {
                        this.ifstat = this.elsestat;
                        this.negated = true;
                    } else {
                        this.ifstat = null;
                    }
                    this.elsestat = null;
                } else if (this.elsestat == this.post) {
                    this.elsestat = null;
                } else {
                    this.post = postst;
                }
                if (this.elsestat != null) break;
                regedges = 1;
            }
        }
        this.ifedge = lstHeadSuccs.get(this.negated ? 0 : 1);
        this.elseedge = regedges == 2 ? lstHeadSuccs.get(this.negated ? 1 : 0) : null;
        int n = this.iftype = regedges == 2 ? 1 : 0;
        if (this.iftype == 0) {
            StatEdge edge;
            if (regedges == 0) {
                edge = lstHeadSuccs.get(0);
                head.removeSuccessor(edge);
                edge.setSource(this);
                this.addSuccessor(edge);
            } else if (regedges == 1) {
                edge = lstHeadSuccs.get(this.negated ? 1 : 0);
                head.removeSuccessor(edge);
            }
        }
        if (this.ifstat != null) {
            this.stats.addWithKey(this.ifstat, this.ifstat.id);
        }
        if (this.elsestat != null) {
            this.stats.addWithKey(this.elsestat, this.elsestat.id);
        }
        if (this.post == head) {
            this.post = this;
        }
    }

    public static Statement isHead(Statement head) {
        if (head.type == 8 && head.getLastBasicType() == 0) {
            ArrayList lst;
            boolean ok;
            int regsize = head.getSuccessorEdges(1).size();
            Statement p = null;
            boolean bl = ok = regsize < 2;
            if (!ok && DecHelper.isChoiceStatement(head, lst = new ArrayList())) {
                p = (Statement)lst.remove(0);
                for (Statement st : lst) {
                    if (!st.isMonitorEnter()) continue;
                    return null;
                }
                ok = DecHelper.checkStatementExceptions(lst);
            }
            if (ok) {
                return new IfStatement(head, regsize, p);
            }
        }
        return null;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        TextBuffer buf = new TextBuffer();
        buf.append(ExprProcessor.listToJava(this.varDefinitions, indent, tracer));
        buf.append(this.first.toJava(indent, tracer));
        if (this.isLabeled()) {
            buf.appendIndent(indent).append("label").append(this.id.toString()).append(":").appendLineSeparator();
            tracer.incrementCurrentSourceLine();
        }
        buf.appendIndent(indent).append(this.headexprent.get(0).toJava(indent, tracer)).append(" {").appendLineSeparator();
        tracer.incrementCurrentSourceLine();
        if (this.ifstat == null) {
            boolean semicolon = false;
            if (this.ifedge.explicit) {
                semicolon = true;
                if (this.ifedge.getType() == 4) {
                    buf.appendIndent(indent + 1).append("break");
                } else {
                    buf.appendIndent(indent + 1).append("continue");
                }
                if (this.ifedge.labeled) {
                    buf.append(" label").append(this.ifedge.closure.id.toString());
                }
            }
            if (semicolon) {
                buf.append(";").appendLineSeparator();
                tracer.incrementCurrentSourceLine();
            }
        } else {
            buf.append(ExprProcessor.jmpWrapper(this.ifstat, indent + 1, true, tracer));
        }
        boolean elseif = false;
        if (this.elsestat != null) {
            if (this.elsestat.type == 2 && this.elsestat.varDefinitions.isEmpty() && this.elsestat.getFirst().getExprents().isEmpty() && !this.elsestat.isLabeled() && (this.elsestat.getSuccessorEdges(0x40000000).isEmpty() || !this.elsestat.getSuccessorEdges((int)0x40000000).get((int)0).explicit)) {
                buf.appendIndent(indent).append("} else ");
                TextBuffer content = ExprProcessor.jmpWrapper(this.elsestat, indent, false, tracer);
                content.setStart(TextUtil.getIndentString(indent).length());
                buf.append(content);
                elseif = true;
            } else {
                BytecodeMappingTracer else_tracer = new BytecodeMappingTracer(tracer.getCurrentSourceLine() + 1);
                TextBuffer content = ExprProcessor.jmpWrapper(this.elsestat, indent + 1, false, else_tracer);
                if (content.length() > 0) {
                    buf.appendIndent(indent).append("} else {").appendLineSeparator();
                    tracer.setCurrentSourceLine(else_tracer.getCurrentSourceLine());
                    tracer.addTracer(else_tracer);
                    buf.append(content);
                }
            }
        }
        if (!elseif) {
            buf.appendIndent(indent).append("}").appendLineSeparator();
            tracer.incrementCurrentSourceLine();
        }
        return buf;
    }

    @Override
    public void initExprents() {
        IfExprent ifexpr = (IfExprent)this.first.getExprents().remove(this.first.getExprents().size() - 1);
        if (this.negated) {
            ifexpr = (IfExprent)ifexpr.copy();
            ifexpr.negateIf();
        }
        this.headexprent.set(0, ifexpr);
    }

    @Override
    public List<Object> getSequentialObjects() {
        ArrayList<Object> lst = new ArrayList<Object>(this.stats);
        lst.add(1, this.headexprent.get(0));
        return lst;
    }

    @Override
    public void replaceExprent(Exprent oldexpr, Exprent newexpr) {
        if (this.headexprent.get(0) == oldexpr) {
            this.headexprent.set(0, newexpr);
        }
    }

    @Override
    public void replaceStatement(Statement oldstat, Statement newstat) {
        super.replaceStatement(oldstat, newstat);
        if (this.ifstat == oldstat) {
            this.ifstat = newstat;
        }
        if (this.elsestat == oldstat) {
            this.elsestat = newstat;
        }
        List<StatEdge> lstSuccs = this.first.getSuccessorEdges(0x40000000);
        if (this.iftype == 0) {
            this.ifedge = lstSuccs.get(0);
            this.elseedge = null;
        } else {
            StatEdge edge0 = lstSuccs.get(0);
            StatEdge edge1 = lstSuccs.get(1);
            if (edge0.getDestination() == this.ifstat) {
                this.ifedge = edge0;
                this.elseedge = edge1;
            } else {
                this.ifedge = edge1;
                this.elseedge = edge0;
            }
        }
    }

    @Override
    public Statement getSimpleCopy() {
        IfStatement is = new IfStatement();
        is.iftype = this.iftype;
        is.negated = this.negated;
        return is;
    }

    @Override
    public void initSimpleCopy() {
        this.first = (Statement)this.stats.get(0);
        List<StatEdge> lstSuccs = this.first.getSuccessorEdges(0x40000000);
        this.ifedge = lstSuccs.get(this.iftype == 0 || this.negated ? 0 : 1);
        if (this.stats.size() > 1) {
            this.ifstat = (Statement)this.stats.get(1);
        }
        if (this.iftype == 1) {
            this.elseedge = lstSuccs.get(this.negated ? 1 : 0);
            this.elsestat = (Statement)this.stats.get(2);
        }
    }

    public Statement getElsestat() {
        return this.elsestat;
    }

    public void setElsestat(Statement elsestat) {
        this.elsestat = elsestat;
    }

    public Statement getIfstat() {
        return this.ifstat;
    }

    public void setIfstat(Statement ifstat) {
        this.ifstat = ifstat;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    public List<Exprent> getHeadexprentList() {
        return this.headexprent;
    }

    public IfExprent getHeadexprent() {
        return (IfExprent)this.headexprent.get(0);
    }

    public void setElseEdge(StatEdge elseedge) {
        this.elseedge = elseedge;
    }

    public void setIfEdge(StatEdge ifedge) {
        this.ifedge = ifedge;
    }

    public StatEdge getIfEdge() {
        return this.ifedge;
    }

    public StatEdge getElseEdge() {
        return this.elseedge;
    }

    @Override
    public StartEndPair getStartEndRange() {
        return StartEndPair.join(super.getStartEndRange(), this.ifstat != null ? this.ifstat.getStartEndRange() : null, this.elsestat != null ? this.elsestat.getStartEndRange() : null);
    }

    @Override
    public IMatchable findObject(MatchNode matchNode, int index) {
        String position;
        IMatchable object = super.findObject(matchNode, index);
        if (object != null) {
            return object;
        }
        if (matchNode.getType() == 1 && "head".equals(position = (String)matchNode.getRuleValue(IMatchable.MatchProperties.EXPRENT_POSITION))) {
            return this.getHeadexprent();
        }
        return null;
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        Integer type = (Integer)matchNode.getRuleValue(IMatchable.MatchProperties.STATEMENT_IFTYPE);
        return type == null || this.iftype == type;
    }
}

