/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ArrayExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.SwitchExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.struct.StructField;

public final class SwitchHelper {
    public static final int STATIC_FINAL_SYNTHETIC = 4120;

    public static boolean simplifySwitches(Statement stat) {
        boolean ret = false;
        if (stat.type == 6) {
            ret = SwitchHelper.simplify((SwitchStatement)stat);
        }
        for (int i = 0; i < stat.getStats().size(); ++i) {
            ret |= SwitchHelper.simplifySwitches((Statement)stat.getStats().get(i));
        }
        return ret;
    }

    private static boolean simplify(SwitchStatement switchStatement) {
        SwitchExprent switchExprent;
        Exprent value;
        SwitchStatement following = null;
        List<StatEdge> edges = switchStatement.getSuccessorEdges(1);
        if (edges.size() == 1 && edges.get((int)0).getDestination().type == 6) {
            following = (SwitchStatement)edges.get(0).getDestination();
        }
        if (SwitchHelper.isEnumArray(value = (switchExprent = (SwitchExprent)switchStatement.getHeadexprent()).getValue())) {
            MethodWrapper wrapper;
            List<List<Exprent>> caseValues = switchStatement.getCaseValues();
            HashMap mapping = new HashMap(caseValues.size());
            ArrayExprent array = (ArrayExprent)value;
            FieldExprent arrayField = (FieldExprent)array.getArray();
            ClassesProcessor.ClassNode classNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(arrayField.getClassname());
            if (classNode != null && (wrapper = classNode.getWrapper().getMethodWrapper("<clinit>", "()V")) != null && wrapper.root != null) {
                wrapper.getOrBuildGraph().iterateExprents(exprent -> {
                    if (exprent instanceof AssignmentExprent) {
                        AssignmentExprent assignment = (AssignmentExprent)exprent;
                        Exprent left = assignment.getLeft();
                        if (left.type == 1 && ((ArrayExprent)left).getArray().equals(arrayField)) {
                            mapping.put(assignment.getRight(), ((InvocationExprent)((ArrayExprent)left).getIndex()).getInstance());
                        }
                    }
                    return 0;
                });
            }
            ArrayList realCaseValues = new ArrayList(caseValues.size());
            for (List<Exprent> caseValue : caseValues) {
                ArrayList<Exprent> values = new ArrayList<Exprent>(caseValue.size());
                realCaseValues.add(values);
                for (Exprent exprent2 : caseValue) {
                    if (exprent2 == null) {
                        values.add(null);
                        continue;
                    }
                    Exprent realConst = (Exprent)mapping.get(exprent2);
                    if (realConst == null) {
                        DecompilerContext.getLogger().writeMessage("Unable to simplify switch on enum: " + exprent2 + " not found, available: " + mapping, IFernflowerLogger.Severity.ERROR);
                        return false;
                    }
                    values.add(realConst.copy());
                }
            }
            caseValues.clear();
            caseValues.addAll(realCaseValues);
            switchExprent.replaceExprent(value, ((InvocationExprent)array.getIndex()).getInstance().copy());
            return true;
        }
        if (SwitchHelper.isSwitchOnString(switchStatement, following)) {
            HashMap<Integer, Exprent> caseMap = new HashMap<Integer, Exprent>();
            for (int i = 0; i < switchStatement.getCaseStatements().size(); ++i) {
                Statement curr = switchStatement.getCaseStatements().get(i);
                while (curr != null && curr.type == 2) {
                    IfStatement ifStat = (IfStatement)curr;
                    Exprent condition = ifStat.getHeadexprent().getCondition();
                    if (condition.type == 6 && ((FunctionExprent)condition).getFuncType() == 43) {
                        condition = ((FunctionExprent)condition).getLstOperands().get(0);
                    }
                    if (condition.type == 8 && ((InvocationExprent)condition).getLstParameters().size() == 1) {
                        Exprent assign = ifStat.getIfstat().getExprents().get(0);
                        int caseVal = ((ConstExprent)((AssignmentExprent)assign).getRight()).getIntValue();
                        caseMap.put(caseVal, ((InvocationExprent)condition).getLstParameters().get(0));
                    }
                    curr = ifStat.getElsestat();
                }
            }
            List realCaseValues = following.getCaseValues().stream().map(l -> l.stream().map(e -> e instanceof ConstExprent ? Integer.valueOf(((ConstExprent)e).getIntValue()) : null).map(caseMap::get).collect(Collectors.toList())).collect(Collectors.toList());
            following.getCaseValues().clear();
            following.getCaseValues().addAll(realCaseValues);
            Exprent followingVal = ((SwitchExprent)following.getHeadexprent()).getValue();
            following.getHeadexprent().replaceExprent(followingVal, ((InvocationExprent)value).getInstance());
            switchStatement.getFirst().getExprents().remove(switchStatement.getFirst().getExprents().size() - 1);
            switchStatement.getFirst().getAllPredecessorEdges().forEach(switchStatement.getFirst()::removePredecessor);
            switchStatement.getFirst().getAllSuccessorEdges().forEach(switchStatement.getFirst()::removeSuccessor);
            switchStatement.getParent().replaceStatement(switchStatement, switchStatement.getFirst());
            return true;
        }
        return false;
    }

    private static boolean isEnumArray(Exprent exprent) {
        ArrayExprent arr;
        Exprent tmp;
        if (exprent instanceof ArrayExprent && (tmp = (arr = (ArrayExprent)exprent).getArray()) instanceof FieldExprent) {
            FieldExprent field = (FieldExprent)tmp;
            Exprent index = arr.getIndex();
            ClassesProcessor.ClassNode classNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(field.getClassname());
            if (classNode == null || !"[I".equals(field.getDescriptor().descriptorString)) {
                return field.getName().startsWith("$SwitchMap") || index instanceof InvocationExprent && ((InvocationExprent)index).getName().equals("ordinal");
            }
            StructField stField = classNode.getWrapper().getClassStruct().getField(field.getName(), field.getDescriptor().descriptorString);
            if ((stField.getAccessFlags() & 0x1018) != 4120) {
                return false;
            }
            if ((classNode.getWrapper().getClassStruct().getAccessFlags() & 0x1000) == 4096) {
                return true;
            }
        }
        return false;
    }

    private static boolean isSwitchOnString(SwitchStatement first, SwitchStatement second) {
        if (second != null) {
            Exprent firstValue = ((SwitchExprent)first.getHeadexprent()).getValue();
            Exprent secondValue = ((SwitchExprent)second.getHeadexprent()).getValue();
            if (firstValue.type == 8 && secondValue.type == 12 && first.getCaseStatements().get((int)0).type == 2) {
                InvocationExprent invExpr = (InvocationExprent)firstValue;
                VarExprent varExpr = (VarExprent)secondValue;
                if (invExpr.getName().equals("hashCode") && invExpr.getClassname().equals("java/lang/String")) {
                    boolean matches = true;
                    for (int i = 0; matches && i < first.getCaseStatements().size(); ++i) {
                        if (first.getCaseEdges().get(i).contains(first.getDefault_edge())) continue;
                        Statement curr = first.getCaseStatements().get(i);
                        while (matches && curr != null) {
                            if (curr.type == 2) {
                                List<Exprent> block;
                                InvocationExprent condInvocation;
                                IfStatement ifStat = (IfStatement)curr;
                                Exprent condition = ifStat.getHeadexprent().getCondition();
                                if (condition.type == 6 && ((FunctionExprent)condition).getFuncType() == 43) {
                                    condition = ((FunctionExprent)condition).getLstOperands().get(0);
                                }
                                if (condition.type == 8 && (condInvocation = (InvocationExprent)condition).getName().equals("equals") && condInvocation.getInstance().equals(invExpr.getInstance()) && (block = ifStat.getIfstat().getExprents()) != null && block.size() == 1 && block.get((int)0).type == 2) {
                                    AssignmentExprent assign = (AssignmentExprent)block.get(0);
                                    if (assign.getRight().type == 3 && varExpr.equals(assign.getLeft())) {
                                        curr = ifStat.getElsestat();
                                        continue;
                                    }
                                }
                            }
                            matches = false;
                        }
                    }
                    return matches;
                }
            }
        }
        return false;
    }
}

