/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;

public final class LoopExtractHelper {
    public static boolean extractLoops(Statement root) {
        boolean res;
        boolean bl = res = LoopExtractHelper.extractLoopsRec(root) != 0;
        if (res) {
            SequenceHelper.condenseSequences(root);
        }
        return res;
    }

    private static int extractLoopsRec(Statement stat) {
        boolean updated;
        boolean res = false;
        block0: do {
            updated = false;
            for (Statement st : stat.getStats()) {
                int extr = LoopExtractHelper.extractLoopsRec(st);
                res |= extr != 0;
                if (extr != 2) continue;
                updated = true;
                continue block0;
            }
        } while (updated);
        if (stat.type == 5 && LoopExtractHelper.extractLoop((DoStatement)stat)) {
            return 2;
        }
        return res ? 1 : 0;
    }

    private static boolean extractLoop(DoStatement stat) {
        if (stat.getLooptype() != 0) {
            return false;
        }
        ArrayList<Statement> stats = new ArrayList<Statement>();
        for (StatEdge edge : stat.getLabelEdges()) {
            if (edge.getType() == 8 || edge.getDestination().type == 14) continue;
            if (edge.getType() == 4 && LoopExtractHelper.isExternStatement(stat, edge.getSource(), edge.getSource())) {
                stats.add(edge.getSource());
                continue;
            }
            return false;
        }
        if (stats.size() > 0 && stat.getParent().getStats().getLast() != stat) {
            return false;
        }
        if (!LoopExtractHelper.extractFirstIf(stat, stats)) {
            return LoopExtractHelper.extractLastIf(stat, stats);
        }
        return true;
    }

    private static boolean extractLastIf(DoStatement stat, List<Statement> stats) {
        Statement last = stat.getFirst();
        while (last.type == 15) {
            last = last.getStats().getLast();
        }
        if (last.type == 2) {
            IfStatement lastif = (IfStatement)last;
            if (lastif.iftype == 0 && lastif.getIfstat() != null) {
                Statement ifstat = lastif.getIfstat();
                List<StatEdge> successorEdges = lastif.getAllSuccessorEdges();
                if (successorEdges.isEmpty()) {
                    return false;
                }
                StatEdge elseedge = successorEdges.get(0);
                if (elseedge == null || elseedge.getType() == 8 && elseedge.closure == stat) {
                    Set<Statement> set = stat.getNeighboursSet(8, 0);
                    set.remove(last);
                    if (set.isEmpty() && LoopExtractHelper.isExternStatement(stat, ifstat, ifstat)) {
                        Statement first = stat.getFirst();
                        while (first.type == 15) {
                            first = first.getFirst();
                        }
                        if (first.type == 5 && ((DoStatement)first).getLooptype() == 0) {
                            return false;
                        }
                        for (Statement s : stats) {
                            if (ifstat.containsStatement(s)) continue;
                            return false;
                        }
                        LoopExtractHelper.extractIfBlock(stat, lastif);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean extractFirstIf(DoStatement stat, List<Statement> stats) {
        Statement ifstat;
        IfStatement firstif;
        Statement first = stat.getFirst();
        while (first.type == 15) {
            first = first.getFirst();
        }
        if (first.type == 2 && (firstif = (IfStatement)first).getFirst().getExprents().isEmpty() && firstif.iftype == 0 && firstif.getIfstat() != null && LoopExtractHelper.isExternStatement(stat, ifstat = firstif.getIfstat(), ifstat)) {
            for (Statement s : stats) {
                if (ifstat.containsStatement(s)) continue;
                return false;
            }
            LoopExtractHelper.extractIfBlock(stat, firstif);
            return true;
        }
        return false;
    }

    private static boolean isExternStatement(DoStatement loop, Statement block, Statement stat) {
        for (StatEdge edge : stat.getAllSuccessorEdges()) {
            if (!loop.containsStatement(edge.getDestination()) || block.containsStatement(edge.getDestination())) continue;
            return false;
        }
        for (Statement st : stat.getStats()) {
            if (LoopExtractHelper.isExternStatement(loop, block, st)) continue;
            return false;
        }
        return true;
    }

    private static void extractIfBlock(DoStatement loop, IfStatement ifstat) {
        Statement target = ifstat.getIfstat();
        StatEdge ifedge = ifstat.getIfEdge();
        ifstat.setIfstat(null);
        ifedge.getSource().changeEdgeType(1, ifedge, 4);
        ifedge.closure = loop;
        ifstat.getStats().removeWithKey(target.id);
        loop.addLabeledEdge(ifedge);
        SequenceStatement block = new SequenceStatement(Arrays.asList(loop, target));
        loop.getParent().replaceStatement(loop, block);
        block.setAllParent();
        loop.addSuccessor(new StatEdge(1, (Statement)loop, target));
        for (StatEdge edge : new ArrayList<StatEdge>(block.getLabelEdges())) {
            if (edge.getType() != 8 && edge != ifedge) continue;
            loop.addLabeledEdge(edge);
        }
        for (StatEdge edge : block.getPredecessorEdges(8)) {
            if (!loop.containsStatementStrict(edge.getSource())) continue;
            block.removePredecessor(edge);
            edge.getSource().changeEdgeNode(1, edge, loop);
            loop.addPredecessor(edge);
        }
        List<StatEdge> link = target.getPredecessorEdges(4);
        if (link.size() == 1) {
            link.get((int)0).canInline = false;
        }
    }
}

