/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.decompiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class ThreadSafeResultSaver
implements IResultSaver {
    private final Map<String, ArchiveContext> archiveContexts = new HashMap<String, ArchiveContext>();
    private final File target;
    private final boolean archiveMode;
    private ArchiveContext singeArchiveCtx;

    public ThreadSafeResultSaver(File target) {
        this.target = target;
        this.archiveMode = !target.isDirectory();
    }

    private ArchiveContext getCtx(String path) {
        if (this.archiveMode) {
            return this.singeArchiveCtx;
        }
        return this.archiveContexts.get(path);
    }

    @Override
    public void createArchive(String path, String archiveName, Manifest manifest) {
        if (this.archiveMode && this.singeArchiveCtx != null) {
            throw new UnsupportedOperationException("Attempted to write multiple archives at the same time.");
        }
        File file = this.archiveMode ? this.target : new File(this.getAbsolutePath(path), archiveName);
        ArchiveContext ctx = this.getCtx(file.getPath());
        if (ctx != null) {
            throw new RuntimeException("Archive already open for: " + file);
        }
        try {
            if (!file.createNewFile() && !file.isFile()) {
                throw new IOException("Cannot create file " + file);
            }
            FileOutputStream fos = new FileOutputStream(file);
            ZipOutputStream zos = manifest != null ? new JarOutputStream((OutputStream)fos, manifest) : new ZipOutputStream(fos);
            ctx = new ArchiveContext(file, zos);
            if (this.archiveMode) {
                this.singeArchiveCtx = ctx;
            } else {
                this.archiveContexts.put(file.getPath(), ctx);
            }
        }
        catch (IOException e) {
            DecompilerContext.getLogger().writeMessage("Cannot create archive " + file, e);
        }
    }

    @Override
    public void saveDirEntry(String path, String archiveName, String entryName) {
        this.saveEntryData(path, archiveName, entryName, null, null);
    }

    @Override
    public void copyEntry(String source, String path, String archiveName, String entryName) {
        String file = new File(this.getAbsolutePath(path), archiveName).getPath();
        ArchiveContext ctx = this.getCtx(file);
        if (ctx == null) {
            throw new RuntimeException("Archive closed and tried to copy entry '" + entryName + "' from '" + source + "' to '" + file + "'.");
        }
        ctx.submit(() -> {
            block27: {
                if (!ctx.addEntry(entryName)) {
                    return;
                }
                try (ZipFile srcArchive = new ZipFile(new File(source));){
                    ZipEntry entry = srcArchive.getEntry(entryName);
                    if (entry == null) break block27;
                    try (InputStream in = srcArchive.getInputStream(entry);){
                        ctx.stream.putNextEntry(new ZipEntry(entryName));
                        InterpreterUtil.copyStream(in, ctx.stream);
                    }
                }
                catch (IOException e) {
                    DecompilerContext.getLogger().writeMessage("Cannot copy entry " + entryName + " from " + source + " to " + file, e);
                }
            }
        });
    }

    @Override
    public void saveClassEntry(String path, String archiveName, String qualifiedName, String entryName, String content, int[] mapping) {
        this.saveEntryData(path, archiveName, entryName, content.getBytes(StandardCharsets.UTF_8), this.getCodeLineData(mapping));
    }

    private void saveEntryData(String path, String archiveName, String entryName, byte[] content, byte[] extra) {
        String file = new File(this.getAbsolutePath(path), archiveName).getPath();
        ArchiveContext ctx = this.getCtx(file);
        if (ctx == null) {
            throw new RuntimeException("Archive closed and tried to write entry '" + entryName + "' to '" + file + "'.");
        }
        ctx.submit(() -> {
            if (!ctx.addEntry(entryName)) {
                return;
            }
            try {
                ZipEntry entry = new ZipEntry(entryName);
                if (extra != null) {
                    entry.setExtra(extra);
                }
                ctx.stream.putNextEntry(entry);
                if (content != null) {
                    ctx.stream.write(content);
                }
            }
            catch (IOException e) {
                DecompilerContext.getLogger().writeMessage("Cannot write entry " + entryName + " to " + file, e);
            }
        });
    }

    @Override
    public void closeArchive(String path, String archiveName) {
        String file = new File(this.getAbsolutePath(path), archiveName).getPath();
        ArchiveContext ctx = this.getCtx(file);
        if (ctx == null) {
            throw new RuntimeException("Tried to close closed archive '" + file + "'.");
        }
        Future<?> closeFuture = ctx.submit(() -> {
            try {
                ctx.stream.close();
            }
            catch (IOException e) {
                DecompilerContext.getLogger().writeMessage("Cannot close " + file, IFernflowerLogger.Severity.WARN, e);
            }
        });
        ctx.executor.shutdown();
        try {
            closeFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        if (this.archiveMode) {
            this.singeArchiveCtx = null;
        } else {
            this.archiveContexts.remove(file);
        }
    }

    @Override
    public void saveFolder(String path) {
        if (this.archiveMode) {
            if (!"".equals(path)) {
                throw new UnsupportedOperationException("Targeted a single output, but tried to create a directory");
            }
            return;
        }
        File dir = new File(this.getAbsolutePath(path));
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new RuntimeException("Cannot create directory " + dir);
        }
    }

    @Override
    public void copyFile(String source, String path, String entryName) {
        if (this.archiveMode) {
            throw new UnsupportedOperationException("Targeted a single output, but tried to copy file");
        }
        try {
            InterpreterUtil.copyFile(new File(source), new File(this.getAbsolutePath(path), entryName));
        }
        catch (IOException ex) {
            DecompilerContext.getLogger().writeMessage("Cannot copy " + source + " to " + entryName, ex);
        }
    }

    @Override
    public void saveClassFile(String path, String qualifiedName, String entryName, String content, int[] mapping) {
        if (this.archiveMode) {
            throw new UnsupportedOperationException("Targeted a single output, but tried to save a class file");
        }
        File file = new File(this.getAbsolutePath(path), entryName);
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            out.write(content);
        }
        catch (IOException ex) {
            DecompilerContext.getLogger().writeMessage("Cannot write class file " + file, ex);
        }
    }

    private String getAbsolutePath(String path) {
        return new File(this.target, path).getAbsolutePath();
    }

    private static class ArchiveContext {
        public final File file;
        public final ZipOutputStream stream;
        public final ExecutorService executor = Executors.newSingleThreadExecutor();
        public final Set<String> savedEntries = new HashSet<String>();

        private ArchiveContext(File file, ZipOutputStream stream) {
            this.file = file;
            this.stream = stream;
        }

        public Future<?> submit(Runnable runnable) {
            return this.executor.submit(runnable);
        }

        public boolean addEntry(String entryName) {
            boolean added = this.savedEntries.add(entryName);
            if (!added) {
                DecompilerContext.getLogger().writeMessage("Zip entry " + entryName + " already exists in " + this.file, IFernflowerLogger.Severity.WARN);
            }
            return added;
        }
    }
}

