/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGenericSignatureAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericFieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMain;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructField
extends StructMember {
    private final String name;
    private final String descriptor;
    private GenericFieldDescriptor signature;

    public StructField(DataInputFullStream in, StructClass clStruct) throws IOException {
        this.accessFlags = in.readUnsignedShort();
        int nameIndex = in.readUnsignedShort();
        int descriptorIndex = in.readUnsignedShort();
        ConstantPool pool = clStruct.getPool();
        String[] values = pool.getClassElement(1, clStruct.qualifiedName, nameIndex, descriptorIndex);
        this.name = values[0];
        this.descriptor = values[1];
        this.attributes = this.readAttributes(in, pool);
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return this.name;
    }

    public GenericFieldDescriptor getSignature() {
        return this.signature;
    }

    @Override
    protected StructGeneralAttribute readAttribute(DataInputFullStream in, ConstantPool pool, String name) throws IOException {
        StructGeneralAttribute attribute = super.readAttribute(in, pool, name);
        if ("Signature".equals(name) && DecompilerContext.getOption("dgs")) {
            StructGenericSignatureAttribute signature = (StructGenericSignatureAttribute)attribute;
            this.signature = GenericMain.parseFieldSignature(signature.getSignature());
        }
        return attribute;
    }
}

