/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.CounterContainer;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.SSAConstructorSparseEx;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarTypeProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.DotExporter;
import org.jetbrains.java.decompiler.util.FastSparseSetFactory;

public class VarVersionsProcessor {
    private final StructMethod method;
    private Map<Integer, VarVersionPair> mapOriginalVarIndices = Collections.emptyMap();
    private final VarTypeProcessor typeProcessor;

    public VarVersionsProcessor(StructMethod mt, MethodDescriptor md) {
        this.method = mt;
        this.typeProcessor = new VarTypeProcessor(mt, md);
    }

    public void setVarVersions(RootStatement root, VarVersionsProcessor previousVersionsProcessor) {
        SSAConstructorSparseEx ssa = new SSAConstructorSparseEx();
        ssa.splitVariables(root, this.method);
        FlattenStatementsHelper flattenHelper = new FlattenStatementsHelper();
        DirectGraph graph = flattenHelper.buildDirectGraph(root);
        DotExporter.toDotFile(graph, this.method, "setVarVersions");
        VarVersionsProcessor.mergePhiVersions(ssa, graph);
        this.typeProcessor.calculateVarTypes(root, graph);
        VarVersionsProcessor.eliminateNonJavaTypes(this.typeProcessor);
        this.setNewVarIndices(this.typeProcessor, graph, previousVersionsProcessor);
    }

    private static void mergePhiVersions(SSAConstructorSparseEx ssa, DirectGraph graph) {
        ArrayList<Set<VarVersionPair>> lst = new ArrayList<Set<VarVersionPair>>();
        for (Map.Entry<VarVersionPair, FastSparseSetFactory.FastSparseSet<Integer>> ent : ssa.getPhi().entrySet()) {
            Set<VarVersionPair> set = new HashSet<VarVersionPair>();
            set.add(ent.getKey());
            for (Integer version : ent.getValue()) {
                set.add(new VarVersionPair(ent.getKey().var, (int)version));
            }
            for (int i = lst.size() - 1; i >= 0; --i) {
                Set tset = (Set)lst.get(i);
                HashSet intersection = new HashSet(set);
                intersection.retainAll(tset);
                if (intersection.isEmpty()) continue;
                set.addAll(tset);
                lst.remove(i);
            }
            lst.add(set);
        }
        HashMap<VarVersionPair, Integer> phiVersions = new HashMap<VarVersionPair, Integer>();
        for (Set<VarVersionPair> set : lst) {
            int min = Integer.MAX_VALUE;
            for (VarVersionPair paar : set) {
                if (paar.version >= min) continue;
                min = paar.version;
            }
            for (VarVersionPair paar : set) {
                phiVersions.put(new VarVersionPair(paar.var, paar.version), min);
            }
        }
        VarVersionsProcessor.updateVersions(graph, phiVersions);
    }

    private static void updateVersions(DirectGraph graph, Map<VarVersionPair, Integer> versions) {
        graph.iterateExprents(exprent -> {
            List<Exprent> lst = exprent.getAllExprents(true);
            lst.add(exprent);
            for (Exprent expr : lst) {
                VarExprent var;
                Integer version;
                if (expr.type != 12 || (version = (Integer)versions.get(new VarVersionPair(var = (VarExprent)expr))) == null) continue;
                var.setVersion(version);
            }
            return 0;
        });
    }

    private static void eliminateNonJavaTypes(VarTypeProcessor typeProcessor) {
        Map<VarVersionPair, VarType> mapExprentMaxTypes = typeProcessor.getMapExprentMaxTypes();
        Map<VarVersionPair, VarType> mapExprentMinTypes = typeProcessor.getMapExprentMinTypes();
        for (VarVersionPair paar : new ArrayList<VarVersionPair>(mapExprentMinTypes.keySet())) {
            VarType type = mapExprentMinTypes.get(paar);
            VarType maxType = mapExprentMaxTypes.get(paar);
            if (type.type == 15 || type.type == 16) {
                type = maxType != null && maxType.type == 1 ? VarType.VARTYPE_CHAR : (type.type == 15 ? VarType.VARTYPE_BYTE : VarType.VARTYPE_SHORT);
                mapExprentMinTypes.put(paar, type);
                continue;
            }
            if (type.type != 13) continue;
            mapExprentMinTypes.put(paar, VarType.VARTYPE_OBJECT);
        }
    }

    private static void simpleMerge(VarTypeProcessor typeProcessor, DirectGraph graph, StructMethod mt) {
        Map<VarVersionPair, VarType> mapExprentMaxTypes = typeProcessor.getMapExprentMaxTypes();
        Map<VarVersionPair, VarType> mapExprentMinTypes = typeProcessor.getMapExprentMinTypes();
        HashMap<Integer, Set> mapVarVersions = new HashMap<Integer, Set>();
        for (VarVersionPair pair : mapExprentMinTypes.keySet()) {
            if (pair.version < 0) continue;
            mapVarVersions.computeIfAbsent(pair.var, k -> new HashSet()).add(pair.version);
        }
        boolean is_method_static = mt.hasModifier(8);
        HashMap<VarVersionPair, Integer> mapMergedVersions = new HashMap<VarVersionPair, Integer>();
        for (Map.Entry ent : mapVarVersions.entrySet()) {
            if (((Set)ent.getValue()).size() <= 1) continue;
            ArrayList lstVersions = new ArrayList((Collection)ent.getValue());
            Collections.sort(lstVersions);
            for (int i = 0; i < lstVersions.size(); ++i) {
                VarVersionPair firstPair = new VarVersionPair((Integer)ent.getKey(), (Integer)lstVersions.get(i));
                VarType firstType = mapExprentMinTypes.get(firstPair);
                if (firstPair.var == 0 && firstPair.version == 1 && !is_method_static) continue;
                for (int j = i + 1; j < lstVersions.size(); ++j) {
                    VarVersionPair secondPair = new VarVersionPair((Integer)ent.getKey(), (Integer)lstVersions.get(j));
                    VarType secondType = mapExprentMinTypes.get(secondPair);
                    if (!firstType.equals(secondType) && (!firstType.equals(VarType.VARTYPE_NULL) || secondType.type != 8) && (!secondType.equals(VarType.VARTYPE_NULL) || firstType.type != 8)) continue;
                    VarType firstMaxType = mapExprentMaxTypes.get(firstPair);
                    VarType secondMaxType = mapExprentMaxTypes.get(secondPair);
                    VarType type = firstMaxType == null ? secondMaxType : (secondMaxType == null ? firstMaxType : VarType.getCommonMinType(firstMaxType, secondMaxType));
                    mapExprentMaxTypes.put(firstPair, type);
                    mapMergedVersions.put(secondPair, firstPair.version);
                    mapExprentMaxTypes.remove(secondPair);
                    mapExprentMinTypes.remove(secondPair);
                    if (firstType.equals(VarType.VARTYPE_NULL)) {
                        mapExprentMinTypes.put(firstPair, secondType);
                        firstType = secondType;
                    }
                    typeProcessor.getMapFinalVars().put(firstPair, 1);
                    lstVersions.remove(j);
                    --j;
                }
            }
        }
        if (!mapMergedVersions.isEmpty()) {
            VarVersionsProcessor.updateVersions(graph, mapMergedVersions);
        }
    }

    private void setNewVarIndices(VarTypeProcessor typeProcessor, DirectGraph graph, VarVersionsProcessor previousVersionsProcessor) {
        Map<VarVersionPair, VarType> mapExprentMaxTypes = typeProcessor.getMapExprentMaxTypes();
        Map<VarVersionPair, VarType> mapExprentMinTypes = typeProcessor.getMapExprentMinTypes();
        Map<VarVersionPair, Integer> mapFinalVars = typeProcessor.getMapFinalVars();
        CounterContainer counters = DecompilerContext.getCounterContainer();
        HashMap<VarVersionPair, Integer> mapVarPaar = new HashMap<VarVersionPair, Integer>();
        HashMap<Integer, VarVersionPair> mapOriginalVarIndices = new HashMap<Integer, VarVersionPair>();
        mapOriginalVarIndices.putAll(this.mapOriginalVarIndices);
        ArrayList<VarVersionPair> vvps = new ArrayList<VarVersionPair>(mapExprentMinTypes.keySet());
        Collections.sort(vvps, (o1, o2) -> o1.var != o2.var ? o1.var - o2.var : o1.version - o2.version);
        for (VarVersionPair pair : vvps) {
            if (pair.version < 0) continue;
            int newIndex = pair.version == 1 ? pair.var : counters.getCounterAndIncrement(2);
            VarVersionPair newVar = new VarVersionPair(newIndex, 0);
            mapExprentMinTypes.put(newVar, mapExprentMinTypes.get(pair));
            mapExprentMaxTypes.put(newVar, mapExprentMaxTypes.get(pair));
            if (mapFinalVars.containsKey(pair)) {
                mapFinalVars.put(newVar, mapFinalVars.remove(pair));
            }
            mapVarPaar.put(pair, newIndex);
            mapOriginalVarIndices.put(newIndex, pair);
        }
        graph.iterateExprents(exprent -> {
            List<Exprent> lst = exprent.getAllExprents(true);
            lst.add(exprent);
            for (Exprent expr : lst) {
                VarType maxType;
                if (expr.type == 12) {
                    VarExprent newVar = (VarExprent)expr;
                    Integer newVarIndex = (Integer)mapVarPaar.get(new VarVersionPair(newVar));
                    if (newVarIndex == null) continue;
                    newVar.setIndex(newVarIndex);
                    newVar.setVersion(0);
                    continue;
                }
                if (expr.type != 3 || (maxType = (VarType)mapExprentMaxTypes.get(new VarVersionPair(expr.id, -1))) == null || !maxType.equals(VarType.VARTYPE_CHAR)) continue;
                ((ConstExprent)expr).setConstType(maxType);
            }
            return 0;
        });
        if (previousVersionsProcessor != null) {
            Map<Integer, VarVersionPair> oldIndices = previousVersionsProcessor.getMapOriginalVarIndices();
            this.mapOriginalVarIndices = new HashMap<Integer, VarVersionPair>(mapOriginalVarIndices.size());
            for (Map.Entry entry : mapOriginalVarIndices.entrySet()) {
                VarVersionPair value = (VarVersionPair)entry.getValue();
                VarVersionPair oldValue = oldIndices.get(value.var);
                value = oldValue != null ? oldValue : value;
                this.mapOriginalVarIndices.put((Integer)entry.getKey(), value);
            }
        } else {
            this.mapOriginalVarIndices = mapOriginalVarIndices;
        }
    }

    public VarType getVarType(VarVersionPair pair) {
        return this.typeProcessor.getVarType(pair);
    }

    public void setVarType(VarVersionPair pair, VarType type) {
        this.typeProcessor.setVarType(pair, type);
    }

    public int getVarFinal(VarVersionPair pair) {
        Integer fin = this.typeProcessor.getMapFinalVars().get(pair);
        return fin == null ? 3 : fin;
    }

    public void setVarFinal(VarVersionPair pair, int finalType) {
        this.typeProcessor.getMapFinalVars().put(pair, finalType);
    }

    public Map<Integer, VarVersionPair> getMapOriginalVarIndices() {
        return this.mapOriginalVarIndices;
    }

    public VarTypeProcessor getTypeProcessor() {
        return this.typeProcessor;
    }
}

